/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.queries.om;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bimserver.database.queries.om.CanInclude;
import org.bimserver.database.queries.om.InBoundingBox;
import org.bimserver.database.queries.om.Include;
import org.bimserver.database.queries.om.Query;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.shared.QueryException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;

public class JsonQueryObjectModelConverter {
    private static final Map<String, Include> CACHED_DEFINES = new HashMap<String, Include>();
    private PackageMetaData packageMetaData;

    public JsonQueryObjectModelConverter(PackageMetaData packageMetaData) {
        this.packageMetaData = packageMetaData;
    }

    public ObjectNode toJson(Query query) {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode queryNode = objectMapper.createObjectNode();
        Map<String, Include> defines = query.getDefines();
        ObjectNode definesNode = objectMapper.createObjectNode();
        queryNode.set("defines", (JsonNode)definesNode);
        for (String key : defines.keySet()) {
            ObjectNode includeNode = objectMapper.createObjectNode();
            Include include = defines.get(key);
            ArrayNode fieldsNode = objectMapper.createArrayNode();
            for (EReference eReference : include.getFields()) {
                fieldsNode.add(eReference.getName());
            }
            definesNode.set(key, (JsonNode)includeNode);
        }
        ArrayNode queryPartsNode = objectMapper.createArrayNode();
        queryNode.set("queries", (JsonNode)queryPartsNode);
        for (QueryPart queryPart : query.getQueryParts()) {
            ObjectNode queryPartNode = objectMapper.createObjectNode();
            if (queryPart.hasTypes()) {
                ArrayNode typesNode = objectMapper.createArrayNode();
                queryPartNode.set("types", (JsonNode)typesNode);
                for (EClass type : queryPart.getTypes()) {
                    typesNode.add(type.getName());
                }
            }
            if (queryPart.hasOids()) {
                ArrayNode oidsNode = objectMapper.createArrayNode();
                queryPartNode.set("oids", (JsonNode)oidsNode);
                Iterator<Object> iterator = queryPart.getOids().iterator();
                while (iterator.hasNext()) {
                    long oid = (Long)iterator.next();
                    oidsNode.add(oid);
                }
            }
            queryPartsNode.add((JsonNode)queryPartNode);
        }
        return queryNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Query parseJson(String queryName, ObjectNode fullQuery) throws QueryException {
        Query query = new Query(queryName, this.packageMetaData);
        if (fullQuery.has("defines")) {
            JsonNode defines = fullQuery.get("defines");
            if (!(defines instanceof ObjectNode)) throw new QueryException("\"defines\" must be of type object");
            this.parseDefines(query, (ObjectNode)fullQuery.get("defines"));
        }
        if (fullQuery.has("queries")) {
            JsonNode queriesNode = fullQuery.get("queries");
            if (!(queriesNode instanceof ArrayNode)) throw new QueryException("\"queries\" must be of type array");
            ArrayNode queries = (ArrayNode)fullQuery.get("queries");
            if (queries.size() == 0) {
                throw new QueryException("\"queries\" must contain at least one query");
            }
            for (int i = 0; i < queries.size(); ++i) {
                this.parseJsonQuery(query, (ObjectNode)queries.get(i));
            }
            return query;
        } else if (fullQuery.has("query")) {
            JsonNode queryNode = fullQuery.get("query");
            if (!(queryNode instanceof ObjectNode)) throw new QueryException("\"query\" must be of type object");
            this.parseJsonQuery(query, (ObjectNode)fullQuery.get("query"));
            return query;
        } else {
            if (fullQuery.has("defines")) return query;
            this.parseJsonQuery(query, fullQuery);
        }
        return query;
    }

    private void parseDefines(Query query, ObjectNode jsonNode) throws QueryException {
        JsonNode defineNode;
        String fieldName;
        Iterator fieldNames = jsonNode.fieldNames();
        int i = 0;
        while (fieldNames.hasNext()) {
            fieldName = (String)fieldNames.next();
            defineNode = jsonNode.get(fieldName);
            if (!(defineNode instanceof ObjectNode)) {
                throw new QueryException("\"defines\"[" + i + "] must be of type object");
            }
            Include include = new Include(this.packageMetaData);
            query.addDefine(fieldName, include);
            ++i;
        }
        fieldNames = jsonNode.fieldNames();
        while (fieldNames.hasNext()) {
            fieldName = (String)fieldNames.next();
            defineNode = jsonNode.get(fieldName);
            ObjectNode define = (ObjectNode)defineNode;
            this.parseInclude(query, define, query.getDefine(fieldName));
        }
    }

    private Include parseInclude(Query query, ObjectNode jsonNode, Include include) throws QueryException {
        EClass eClass;
        JsonNode typeNode;
        int i;
        ArrayNode types;
        JsonNode typesNode;
        EClass eClass2;
        JsonNode typeNode2;
        if (include == null) {
            include = new Include(this.packageMetaData);
        }
        if (!jsonNode.has("type") && !jsonNode.has("types")) {
            throw new QueryException("includes require a \"type\" or \"types\" field " + jsonNode);
        }
        if (jsonNode.has("type")) {
            typeNode2 = jsonNode.get("type");
            if (typeNode2.isTextual()) {
                eClass2 = this.packageMetaData.getEClassIncludingDependencies(typeNode2.asText());
                if (eClass2 == null) {
                    throw new QueryException("Cannot find type \"" + typeNode2.asText() + "\"");
                }
                include.addType(eClass2, false);
            } else {
                throw new QueryException("\"type\" field mst be of type string");
            }
        }
        if (jsonNode.has("types")) {
            typesNode = jsonNode.get("types");
            if (typesNode instanceof ArrayNode) {
                types = (ArrayNode)typesNode;
                if (types.size() == 0) {
                    throw new QueryException("\"types\" must have a least one element");
                }
                for (i = 0; i < types.size(); ++i) {
                    typeNode = types.get(i);
                    if (!typeNode.isTextual()) {
                        throw new QueryException("\"types\"[" + i + "] field mst be of type string");
                    }
                    eClass = this.packageMetaData.getEClass(typeNode.asText());
                    include.addType(eClass, false);
                }
            } else {
                throw new QueryException("\"types\" must be of type array");
            }
        }
        if (jsonNode.has("outputType")) {
            typeNode2 = jsonNode.get("outputType");
            if (typeNode2.isTextual()) {
                eClass2 = this.packageMetaData.getEClassIncludingDependencies(typeNode2.asText());
                include.addOutputType(eClass2);
            } else {
                throw new QueryException("\"outputType\" field mst be of type string");
            }
        }
        if (jsonNode.has("outputTypes")) {
            typesNode = jsonNode.get("outputTypes");
            if (typesNode instanceof ArrayNode) {
                types = (ArrayNode)typesNode;
                if (types.size() == 0) {
                    throw new QueryException("\"outputTypes\" must have a least one element");
                }
                for (i = 0; i < types.size(); ++i) {
                    typeNode = types.get(i);
                    if (!typeNode.isTextual()) {
                        throw new QueryException("\"outputTypes\"[" + i + "] field mst be of type string");
                    }
                    eClass = this.packageMetaData.getEClass(typeNode.asText());
                    include.addOutputType(eClass);
                }
            } else {
                throw new QueryException("\"outputTypes\" must be of type array");
            }
        }
        if (jsonNode.has("field")) {
            JsonNode fieldNode = jsonNode.get("field");
            if (fieldNode.isTextual()) {
                include.addField(fieldNode.asText());
            } else {
                throw new QueryException("\"field\" must be of type string");
            }
        }
        if (jsonNode.has("fields")) {
            JsonNode fieldsNode = jsonNode.get("fields");
            if (fieldsNode instanceof ArrayNode) {
                ArrayNode fields = (ArrayNode)fieldsNode;
                for (i = 0; i < fields.size(); ++i) {
                    JsonNode fieldNode = fields.get(i);
                    if (!fieldNode.isTextual()) {
                        throw new QueryException("\"fields\"[" + i + "] must be of type string");
                    }
                    include.addField(fieldNode.asText());
                }
            } else {
                throw new QueryException("\"fields\" must be of type array");
            }
        }
        if (jsonNode.has("include")) {
            JsonNode includeNode = jsonNode.get("include");
            this.processSubInclude(query, include, includeNode);
        }
        if (jsonNode.has("includes")) {
            JsonNode includesNode = jsonNode.get("includes");
            if (includesNode instanceof ArrayNode) {
                ArrayNode includes = (ArrayNode)includesNode;
                for (i = 0; i < includes.size(); ++i) {
                    this.processSubInclude(query, include, includes.get(i));
                }
            } else {
                throw new QueryException("\"includes\" must be of type array");
            }
        }
        return include;
    }

    public Include getDefineFromFile(String includeName) throws QueryException {
        URL resource;
        Include include = CACHED_DEFINES.get(includeName);
        if (include != null) {
            return include;
        }
        String namespaceString = includeName.substring(0, includeName.indexOf(":"));
        String singleIncludeName = includeName.substring(includeName.indexOf(":") + 1);
        try {
            resource = this.getClass().getClassLoader().loadClass("org.bimserver.database.queries.StartFrame").getResource("json/" + namespaceString + ".json");
            if (resource == null) {
                throw new QueryException("Could not find '" + namespaceString + "' namespace in predefined queries");
            }
        }
        catch (ClassNotFoundException e1) {
            throw new QueryException("Could not find '" + namespaceString + "' namespace in predefined queries");
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        try {
            ObjectNode predefinedQuery = (ObjectNode)objectMapper.readValue(resource, ObjectNode.class);
            JsonQueryObjectModelConverter converter = new JsonQueryObjectModelConverter(this.packageMetaData);
            Query query = converter.parseJson(namespaceString, predefinedQuery);
            Include define = query.getDefine(singleIncludeName);
            if (define == null) {
                throw new QueryException("Could not find '" + singleIncludeName + "' in defines in namespace " + query.getName());
            }
            CACHED_DEFINES.put(includeName, define);
            return define;
        }
        catch (JsonParseException e) {
            throw new QueryException((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new QueryException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new QueryException(e);
        }
    }

    private void processSubInclude(Query query, CanInclude parentInclude, JsonNode includeNode) throws QueryException {
        if (includeNode instanceof ObjectNode) {
            ObjectNode innerInclude = (ObjectNode)includeNode;
            parentInclude.addInclude(this.parseInclude(query, innerInclude, null));
        } else if (includeNode.isTextual()) {
            String includeName = includeNode.asText();
            if (includeName.contains(":")) {
                parentInclude.addInclude(this.getDefineFromFile(includeName));
            } else {
                Include otherInclude = query.getDefine(includeName);
                if (otherInclude == null) {
                    throw new QueryException("Cannot find define \"" + includeName + "\"");
                }
                parentInclude.addInclude(otherInclude);
            }
        } else {
            throw new QueryException("\"include\" must be of type object or string");
        }
    }

    private void parseJsonQuery(Query query, ObjectNode objectNode) throws QueryException {
        int i;
        QueryPart queryPart = new QueryPart(this.packageMetaData);
        if (objectNode.has("type")) {
            JsonNode typeNode = objectNode.get("type");
            if (typeNode.isTextual()) {
                String type = typeNode.asText();
                this.addType(objectNode, queryPart, type);
            } else {
                throw new QueryException("\"type\" must be of type string");
            }
        }
        if (objectNode.has("types")) {
            JsonNode typesNode = objectNode.get("types");
            if (typesNode instanceof ArrayNode) {
                ArrayNode types = (ArrayNode)typesNode;
                for (i = 0; i < types.size(); ++i) {
                    JsonNode typeNode = types.get(i);
                    if (!typeNode.isTextual()) {
                        throw new QueryException("\"types\"[" + i + "] must be of type string");
                    }
                    String type = typeNode.asText();
                    this.addType(objectNode, queryPart, type);
                }
            } else {
                throw new QueryException("\"types\" must be of type array");
            }
        }
        if (objectNode.has("includeAllFields") && objectNode.get("includeAllFields").asBoolean()) {
            queryPart.setIncludeAllFields(true);
        }
        if (objectNode.has("oid")) {
            JsonNode oidNode = objectNode.get("oid");
            if (oidNode.isNumber()) {
                queryPart.addOid(oidNode.asLong());
            } else {
                throw new QueryException("\"oid\" must be of type number");
            }
        }
        if (objectNode.has("oids")) {
            JsonNode oidsNode = objectNode.get("oids");
            if (oidsNode instanceof ArrayNode) {
                ArrayNode oids = (ArrayNode)oidsNode;
                for (i = 0; i < oids.size(); ++i) {
                    JsonNode oidNode = oids.get(i);
                    if (!oidNode.isNumber()) {
                        throw new QueryException("\"oids\"[" + i + "] must be of type number");
                    }
                    queryPart.addOid(oidNode.asLong());
                }
            } else {
                throw new QueryException("\"oids\" must be of type array");
            }
        }
        if (objectNode.has("guid")) {
            JsonNode guidNode = objectNode.get("guid");
            if (guidNode.isTextual()) {
                queryPart.addGuid(guidNode.asText());
            } else {
                throw new QueryException("\"guid\" must be of type string");
            }
        }
        if (objectNode.has("guids")) {
            JsonNode guidsNode = objectNode.get("guids");
            if (guidsNode instanceof ArrayNode) {
                ArrayNode guids = (ArrayNode)guidsNode;
                for (i = 0; i < guids.size(); ++i) {
                    JsonNode guidNode = guids.get(i);
                    if (!guidNode.isTextual()) {
                        throw new QueryException("\"guids\"[" + i + "] must be of type string");
                    }
                    queryPart.addGuid(guidNode.asText());
                }
            } else {
                throw new QueryException("\"guids\" must be of type array");
            }
        }
        if (objectNode.has("properties")) {
            JsonNode propertiesNode = objectNode.get("properties");
            if (propertiesNode instanceof ObjectNode) {
                ObjectNode properties = (ObjectNode)objectNode.get("properties");
                Iterator fields = properties.fields();
                while (fields.hasNext()) {
                    Map.Entry entry = (Map.Entry)fields.next();
                    JsonNode value = (JsonNode)entry.getValue();
                    if (value.isValueNode()) {
                        queryPart.addProperty((String)entry.getKey(), value.asBoolean());
                        continue;
                    }
                    throw new QueryException("property \"" + (String)entry.getKey() + "\" type not supported");
                }
            } else {
                throw new QueryException("\"properties\" must be of type object");
            }
        }
        if (objectNode.has("inBoundingBox")) {
            JsonNode boundingBoxNode = objectNode.get("inBoundingBox");
            if (boundingBoxNode instanceof ObjectNode) {
                ObjectNode boundingBox = (ObjectNode)boundingBoxNode;
                double x = this.checkFloat(boundingBox, "x");
                double y = this.checkFloat(boundingBox, "y");
                double z = this.checkFloat(boundingBox, "z");
                double width = this.checkFloat(boundingBox, "width");
                double height = this.checkFloat(boundingBox, "height");
                double depth = this.checkFloat(boundingBox, "depth");
                queryPart.setInBoundingBox(new InBoundingBox(x, y, z, width, height, depth));
            } else {
                throw new QueryException("\"inBoundingBox\" should be of type object");
            }
        }
        if (objectNode.has("include")) {
            JsonNode includeNode = objectNode.get("include");
            this.processSubInclude(query, queryPart, includeNode);
        }
        if (objectNode.has("includes")) {
            JsonNode includesNode = objectNode.get("includes");
            if (includesNode instanceof ArrayNode) {
                ArrayNode includes = (ArrayNode)includesNode;
                for (int i2 = 0; i2 < includes.size(); ++i2) {
                    JsonNode include = includes.get(i2);
                    this.processSubInclude(query, queryPart, include);
                }
            } else {
                throw new QueryException("\"includes\" should be of type array");
            }
        }
        if (objectNode.has("fields")) {
            objectNode.get("fields");
        }
        Iterator fieldNames = objectNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            if (fieldName.equals("includeAllFields") || fieldName.equals("type") || fieldName.equals("types") || fieldName.equals("oid") || fieldName.equals("oids") || fieldName.equals("guid") || fieldName.equals("guids") || fieldName.equals("properties") || fieldName.equals("inBoundingBox") || fieldName.equals("include") || fieldName.equals("includes") || fieldName.equals("includeAllSubtypes")) continue;
            throw new QueryException("Unknown field: \"" + fieldName + "\"");
        }
        query.addQueryPart(queryPart);
    }

    private double checkFloat(ObjectNode node, String key) throws QueryException {
        if (!node.has(key)) {
            throw new QueryException("\"" + key + "\" not found on \"inBoundingBox\"");
        }
        JsonNode jsonNode = node.get(key);
        if (jsonNode.isNumber()) {
            return jsonNode.asDouble();
        }
        throw new QueryException("\"" + key + "\" should be of type number");
    }

    private void addType(ObjectNode objectNode, QueryPart queryPart, String type) throws QueryException {
        if (type.equals("Object")) {
            return;
        }
        EClass eClass = this.packageMetaData.getEClassIncludingDependencies(type);
        if (eClass == null) {
            throw new QueryException("Type \"" + type + "\" not found");
        }
        queryPart.addType(eClass, objectNode.has("includeAllSubtypes") && objectNode.get("includeAllSubtypes").asBoolean());
    }
}

