/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.queries.om;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bimserver.database.queries.om.CanInclude;
import org.bimserver.database.queries.om.PartOfQuery;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.shared.QueryException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;

public class Include
extends PartOfQuery
implements CanInclude {
    private Set<EClass> types;
    private List<EClass> outputTypes;
    private List<EReference> fields;
    private List<Include> includes;
    private PackageMetaData packageMetaData;

    public Include(PackageMetaData packageMetaData) {
        this.packageMetaData = packageMetaData;
    }

    public void addField(String fieldName) throws QueryException {
        EReference feature = null;
        for (EClass eClass : this.types) {
            if (eClass.getEStructuralFeature(fieldName) == null) {
                throw new QueryException("Class \"" + eClass.getName() + "\" does not have the field \"" + fieldName + "\"");
            }
            if (feature == null) {
                if (!(eClass.getEStructuralFeature(fieldName) instanceof EReference)) {
                    throw new QueryException(fieldName + " is not a reference");
                }
                feature = (EReference)eClass.getEStructuralFeature(fieldName);
                continue;
            }
            if (feature == eClass.getEStructuralFeature(fieldName)) continue;
            throw new QueryException("Classes \"" + eClass.getName() + "\" and \"" + feature.getEContainingClass().getName() + "\" have fields with the same name, but they are not logically the same");
        }
        if (this.fields == null) {
            this.fields = new ArrayList<EReference>();
        }
        this.fields.add(feature);
    }

    @Override
    public void addInclude(Include newInclude) {
        if (this.includes == null) {
            this.includes = new ArrayList<Include>();
        }
        this.includes.add(newInclude);
    }

    public List<EReference> getFields() {
        return this.fields;
    }

    public void addType(EClass eClass, boolean includeAllSubTypes) {
        if (eClass == null) {
            throw new IllegalArgumentException("eClass cannot be null");
        }
        if (this.types == null) {
            this.types = new HashSet<EClass>();
        }
        this.types.add(eClass);
        if (includeAllSubTypes) {
            this.types.addAll(this.packageMetaData.getAllSubClasses(eClass));
        }
    }

    public void addOutputType(EClass eClass) {
        if (this.outputTypes == null) {
            this.outputTypes = new ArrayList<EClass>();
        }
        this.outputTypes.add(eClass);
    }

    public List<EClass> getOutputTypes() {
        return this.outputTypes;
    }

    public boolean hasOutputTypes() {
        return this.outputTypes != null;
    }

    public Set<EClass> getTypes() {
        return this.types;
    }

    public boolean hasFields() {
        return this.fields != null;
    }

    public boolean hasTypes() {
        return this.types != null;
    }

    @Override
    public List<Include> getIncludes() {
        return this.includes;
    }

    @Override
    public boolean hasIncludes() {
        return this.includes != null;
    }

    @Override
    public boolean isIncludeAllFields() {
        return false;
    }

    @Override
    public void dump(int indent, StringBuilder sb) {
        if (indent > 10) {
            sb.append("..trimmed\n");
            return;
        }
        if (this.hasTypes()) {
            sb.append(this.indent(indent) + "types\n");
            for (EClass eClass : this.getTypes()) {
                sb.append(this.indent(indent + 1) + eClass.getName() + "\n");
            }
        }
        if (this.hasFields()) {
            sb.append(this.indent(indent) + "fields\n");
            for (EReference field : this.getFields()) {
                sb.append(this.indent(indent + 1) + field.getName() + "\n");
            }
        }
        if (this.hasIncludes()) {
            sb.append(this.indent(indent) + "includes\n");
            for (Include include : this.getIncludes()) {
                include.dump(indent + 1, sb);
            }
        }
        if (this.hasOutputTypes()) {
            sb.append(this.indent(indent) + "outputTypes\n");
            for (EClass outputType : this.getOutputTypes()) {
                sb.append(this.indent(indent + 1) + outputType.getName() + "\n");
            }
        }
    }

    public Include createInclude() {
        Include include = new Include(this.packageMetaData);
        this.addInclude(include);
        return include;
    }
}

