/*
 * Decompiled with CFR 0.152.
 */
package org.ifcopenshell;

import java.io.IOException;
import java.nio.file.Path;
import org.bimserver.models.store.BooleanType;
import org.bimserver.models.store.ObjectDefinition;
import org.bimserver.models.store.ParameterDefinition;
import org.bimserver.models.store.PrimitiveDefinition;
import org.bimserver.models.store.PrimitiveEnum;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.models.store.StringType;
import org.bimserver.models.store.Type;
import org.bimserver.models.store.TypeDefinition;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.PluginContext;
import org.bimserver.plugins.renderengine.RenderEngine;
import org.bimserver.plugins.renderengine.RenderEngineException;
import org.bimserver.plugins.renderengine.RenderEnginePlugin;
import org.bimserver.plugins.renderengine.VersionInfo;
import org.bimserver.shared.exceptions.PluginException;
import org.ifcopenshell.IfcGeomServerClient;
import org.ifcopenshell.IfcOpenShellEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfcOpenShellEnginePlugin
implements RenderEnginePlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(IfcOpenShellEnginePlugin.class);
    public static final String DEFAULT_BUILD_VERSION = "v0.7.0-c7830e9";
    private static final String BUILD_VERSION = "buildversion";
    private static final String CALCULATE_QUANTITIES_SETTING = "calculatequantities";
    private static final String APPLY_LAYER_SETS = "applylayersets";
    private static final String DISABLE_OPENING_SUBTRACTIONS = "disableopeningsubtrations";
    private Path executableFilename;
    private VersionInfo versionInfo;
    private boolean calculateQuantities = true;
    private boolean applyLayerSets = true;
    private boolean disableOpeningSubtractions = false;

    public RenderEngine createRenderEngine(PluginConfiguration pluginConfiguration, String schema) throws RenderEngineException {
        try {
            return new IfcOpenShellEngine(this.executableFilename, this.calculateQuantities, this.applyLayerSets, this.disableOpeningSubtractions);
        }
        catch (IOException e) {
            throw new RenderEngineException((Exception)e);
        }
    }

    public void init(PluginContext pluginContext, PluginConfiguration systemSettings) throws PluginException {
        if (systemSettings != null) {
            this.calculateQuantities = systemSettings.getBoolean(CALCULATE_QUANTITIES_SETTING, true);
            this.applyLayerSets = systemSettings.getBoolean(APPLY_LAYER_SETS, true);
            this.disableOpeningSubtractions = systemSettings.getBoolean(DISABLE_OPENING_SUBTRACTIONS, false);
        }
        String buildVersion = DEFAULT_BUILD_VERSION;
        if (systemSettings != null && systemSettings.getString(BUILD_VERSION) != null && !systemSettings.getString(BUILD_VERSION).trim().contentEquals("")) {
            buildVersion = systemSettings.getString(BUILD_VERSION);
            LOGGER.info("Using overruled system setting for build version");
        }
        try (IfcGeomServerClient test = new IfcGeomServerClient(IfcGeomServerClient.ExecutableSource.S3, buildVersion, pluginContext.getTempDir());){
            this.executableFilename = test.getExecutableFilename();
            this.versionInfo = new VersionInfo(buildVersion, test.getProtocolVersion(), test.getBuildDateTime(), test.getPlatform());
        }
        LOGGER.info("Using " + this.executableFilename);
    }

    public ObjectDefinition getUserSettingsDefinition() {
        return null;
    }

    public ObjectDefinition getSystemSettingsDefinition() {
        ObjectDefinition settings = StoreFactory.eINSTANCE.createObjectDefinition();
        PrimitiveDefinition stringType = StoreFactory.eINSTANCE.createPrimitiveDefinition();
        stringType.setType(PrimitiveEnum.STRING);
        PrimitiveDefinition booleanType = StoreFactory.eINSTANCE.createPrimitiveDefinition();
        booleanType.setType(PrimitiveEnum.BOOLEAN);
        StringType defaultBuildVersion = StoreFactory.eINSTANCE.createStringType();
        defaultBuildVersion.setValue(DEFAULT_BUILD_VERSION);
        BooleanType defaultTrue = StoreFactory.eINSTANCE.createBooleanType();
        defaultTrue.setValue(true);
        BooleanType defaultFalse = StoreFactory.eINSTANCE.createBooleanType();
        defaultFalse.setValue(false);
        ParameterDefinition buildVersionParameter = StoreFactory.eINSTANCE.createParameterDefinition();
        buildVersionParameter.setIdentifier(BUILD_VERSION);
        buildVersionParameter.setName("Build version");
        buildVersionParameter.setDescription("Build version of IfcOpenShell binary, usually consisting of version number and commit SHA. This overrules the default for the currently installed IfcOpenShell plugin");
        buildVersionParameter.setType((TypeDefinition)stringType);
        buildVersionParameter.setRequired(false);
        buildVersionParameter.setDefaultValue((Type)defaultBuildVersion);
        ParameterDefinition calculateQuantities = StoreFactory.eINSTANCE.createParameterDefinition();
        calculateQuantities.setIdentifier(CALCULATE_QUANTITIES_SETTING);
        calculateQuantities.setName("Calculate Quantities");
        calculateQuantities.setDescription("Calculates volumes and areas, Takes a bit more time (about 15%)");
        calculateQuantities.setType((TypeDefinition)booleanType);
        calculateQuantities.setRequired(false);
        calculateQuantities.setDefaultValue((Type)defaultTrue);
        ParameterDefinition applyLayerSets = StoreFactory.eINSTANCE.createParameterDefinition();
        applyLayerSets.setIdentifier(APPLY_LAYER_SETS);
        applyLayerSets.setName("Apply Layer Sets");
        applyLayerSets.setDescription("Splits certain objects into several layers, depending on the model can take about 10x more processing time, and results in more geometry");
        applyLayerSets.setType((TypeDefinition)booleanType);
        applyLayerSets.setRequired(false);
        applyLayerSets.setDefaultValue((Type)defaultTrue);
        ParameterDefinition disableOpeningSubtractions = StoreFactory.eINSTANCE.createParameterDefinition();
        disableOpeningSubtractions.setIdentifier(DISABLE_OPENING_SUBTRACTIONS);
        disableOpeningSubtractions.setName("Disable Opening Subtractions");
        disableOpeningSubtractions.setDescription("Omits subtractions of voiding opening elements form the voided elements.");
        disableOpeningSubtractions.setType((TypeDefinition)booleanType);
        disableOpeningSubtractions.setRequired(false);
        disableOpeningSubtractions.setDefaultValue((Type)defaultFalse);
        settings.getParameters().add((Object)buildVersionParameter);
        settings.getParameters().add((Object)calculateQuantities);
        settings.getParameters().add((Object)applyLayerSets);
        settings.getParameters().add((Object)disableOpeningSubtractions);
        return settings;
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }
}

