/*
 * Decompiled with CFR 0.152.
 */
package nl.tue.buildingsmart.express.population.test;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.TreeSet;
import nl.tue.buildingsmart.express.dictionary.Namespaces;
import nl.tue.buildingsmart.express.population.EntityInstance;
import nl.tue.buildingsmart.express.population.ModelPopulation;

public class PopulationMetrics {
    ModelPopulation pop;
    Namespaces nsConf;
    HashMap<String, Integer> namespaceMembers = new HashMap();

    public PopulationMetrics(ModelPopulation pop, Namespaces nsConf) {
        this.pop = pop;
        this.nsConf = nsConf;
    }

    public void countEntitiesPerNamespace() {
        for (String ns : this.nsConf.getNamespaces()) {
            this.namespaceMembers.put(ns, new Integer(0));
        }
        for (EntityInstance entInst : this.pop.getInstances().values()) {
            String ns = this.nsConf.getNS(entInst.getEntityDefinition().getName());
            if (ns == null) {
                System.out.println("Namespace for " + entInst.getEntityDefinition().getName() + " not found!");
                continue;
            }
            this.namespaceMembers.put(ns, this.namespaceMembers.get(ns) + 1);
        }
        TreeSet<String> ts = new TreeSet<String>(this.namespaceMembers.keySet());
        for (String ns : ts) {
            System.out.println(ns + ";" + this.namespaceMembers.get(ns));
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length > 1) {
            try (FileInputStream spf = new FileInputStream(args[0]);){
                Namespaces namespaces = new Namespaces(args[1]);
                if (namespaces.readNSConfig()) {
                    System.out.println("read ns config");
                } else {
                    System.out.println("failed to read ns config");
                }
                for (String namespace : namespaces.getNamespaces()) {
                    System.out.println(namespace);
                }
                ModelPopulation model = new ModelPopulation(spf);
                model.setSchemaFile(Paths.get("src", "schema", "IFC2X3_TC1.exp"));
                model.load();
                new PopulationMetrics(model, namespaces).countEntitiesPerNamespace();
            }
        }
    }
}

