/*
 * Decompiled with CFR 0.152.
 */
package nl.tue.buildingsmart.express.population;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import nl.tue.buildingsmart.express.parser.ExpressSchemaParser;
import nl.tue.buildingsmart.express.population.AttributeInstance;
import nl.tue.buildingsmart.express.population.EntityInstance;
import nl.tue.buildingsmart.express.population.ModelPopulation;
import nl.tue.buildingsmart.express.population.ParseException;
import nl.tue.buildingsmart.express.population.Part21ParserConstants;
import nl.tue.buildingsmart.express.population.Part21ParserTokenManager;
import nl.tue.buildingsmart.express.population.SimpleCharStream;
import nl.tue.buildingsmart.express.population.Token;
import nl.tue.buildingsmart.schema.Attribute;
import nl.tue.buildingsmart.schema.EntityDefinition;
import nl.tue.buildingsmart.schema.ExplicitAttribute;
import nl.tue.buildingsmart.schema.InverseAttribute;
import nl.tue.buildingsmart.schema.SchemaDefinition;

public class Part21Parser
implements Part21ParserConstants {
    public Vector current_record = new Vector();
    public Object[] current_entity = new Object[2];
    private SchemaDefinition schema;
    private String schemaName;
    private Path schemaFile;
    private ModelPopulation model;
    private HashMap<Integer, EntityInstance> instances;
    private FileInputStream inputStream;
    private boolean verbose;
    public Part21ParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[0];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[26];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List jj_expentries = new ArrayList();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public void init() {
        this.instances = new HashMap();
        this.verbose = false;
        this.schemaName = new String("");
        if (this.schema == null) {
            try {
                InputStream inputStream = Files.newInputStream(this.schemaFile, new OpenOption[0]);
                try {
                    ExpressSchemaParser schemaParser = new ExpressSchemaParser(inputStream);
                    schemaParser.parse();
                    this.schema = schemaParser.getSchema();
                    if (this.verbose) {
                        System.out.println("Loading Schema " + this.schema.getName() + " successful");
                    }
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public HashMap<Integer, EntityInstance> getInstances() {
        return this.instances;
    }

    public void setInstances(HashMap<Integer, EntityInstance> instances) {
        this.instances = instances;
    }

    public SchemaDefinition getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaDefinition schema) {
        this.schema = schema;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public Path getSchemaFile() {
        return this.schemaFile;
    }

    public void setSchemaFile(Path schemaFile) {
        this.schemaFile = schemaFile;
    }

    public ModelPopulation getModel() {
        return this.model;
    }

    public void setModel(ModelPopulation model) {
        this.model = model;
    }

    public final void exchange_file() throws ParseException {
        this.jj_consume_token(50);
        this.header_section();
        this.data_section();
        this.jj_consume_token(51);
    }

    public final void header_section() throws ParseException {
        this.jj_consume_token(52);
        this.header_entity();
        this.header_entity();
        this.header_entity();
        if (this.jj_2_1(3)) {
            this.header_entity_list();
        }
        this.jj_consume_token(53);
    }

    public final void header_entity_list() throws ParseException {
        this.header_entity();
        while (this.jj_2_2(3)) {
            this.header_entity();
        }
    }

    public final void header_entity() throws ParseException {
        Token name = null;
        name = this.jj_consume_token(22);
        this.jj_consume_token(7);
        if (this.jj_2_3(3)) {
            this.parameter_list();
        }
        if (name.image.indexOf("FILE_SCHEMA") > -1) {
            String schema_name = ((String[])((Vector)this.current_record.get(9)).get(0))[1];
            this.setSchemaName(schema_name);
        }
        this.jj_consume_token(8);
        this.jj_consume_token(13);
    }

    public final void parameter_list() throws ParseException {
        this.parameter();
        while (this.jj_2_4(3)) {
            this.jj_consume_token(15);
            this.parameter();
        }
    }

    public final void parameter() throws ParseException {
        if (this.jj_2_5(3)) {
            this.typed_parameter();
        } else if (this.jj_2_6(3)) {
            this.untyped_parameter();
        } else if (this.jj_2_7(3)) {
            this.omitted_parameter();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void typed_parameter() throws ParseException {
        Token t = null;
        Object[] pair = new Object[2];
        Vector park_current = (Vector)this.current_record.clone();
        this.current_record.clear();
        t = this.jj_consume_token(22);
        this.jj_consume_token(7);
        this.parameter();
        this.jj_consume_token(8);
        pair[0] = t.image;
        pair[1] = this.current_record.clone();
        park_current.add(pair);
        this.current_record = (Vector)park_current.clone();
    }

    public final void untyped_parameter() throws ParseException {
        Token t = null;
        String[] pair = new String[2];
        if (this.jj_2_8(3)) {
            t = this.jj_consume_token(18);
            if (t != null) {
                pair[0] = "DOLLAR";
                pair[1] = t.image;
                this.current_record.add(pair);
                if (this.verbose) {
                    System.out.print("DOLLAR" + t.image + ", ");
                }
            }
        } else if (this.jj_2_9(3)) {
            t = this.jj_consume_token(21);
            if (t != null) {
                pair[0] = "INTEGER";
                pair[1] = t.image;
                this.current_record.add(pair);
                if (this.verbose) {
                    System.out.print("INTEGER" + t.image + ", ");
                }
            }
        } else if (this.jj_2_10(3)) {
            t = this.jj_consume_token(26);
            if (t != null) {
                pair[0] = "REAL";
                pair[1] = t.image;
                this.current_record.add(pair);
                if (this.verbose) {
                    System.out.print("REAL" + t.image + ", ");
                }
            }
        } else if (this.jj_2_11(3)) {
            t = this.jj_consume_token(28);
            if (t != null) {
                pair[0] = "STRING";
                pair[1] = t.image;
                this.current_record.add(pair);
                if (this.verbose) {
                    System.out.print("STRING" + t.image + ", ");
                }
            }
        } else if (this.jj_2_12(3)) {
            t = this.jj_consume_token(29);
            if (t != null) {
                pair[0] = "ENTITY_INSTANCE_NAME";
                pair[1] = t.image;
                this.current_record.add(pair);
                if (this.verbose) {
                    System.out.print("ENTITY_INSTANCE_NAME" + t.image + ", ");
                }
            }
        } else if (this.jj_2_13(3)) {
            t = this.jj_consume_token(30);
            if (t != null) {
                pair[0] = "ENUMERATION";
                pair[1] = t.image;
                this.current_record.add(pair);
                if (this.verbose) {
                    System.out.print("ENUMERATION" + t.image + ", ");
                }
            }
        } else if (this.jj_2_14(3)) {
            t = this.jj_consume_token(32);
            if (t != null) {
                pair[0] = "BINARY";
                pair[1] = t.image;
                this.current_record.add(pair);
                if (this.verbose) {
                    System.out.print("BINARY" + t.image + ", ");
                }
            }
        } else if (this.jj_2_15(3)) {
            this.list();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void omitted_parameter() throws ParseException {
        Token t = null;
        String[] pair = new String[2];
        t = this.jj_consume_token(19);
        if (t != null) {
            pair[0] = "STAR";
            pair[1] = t.image;
            this.current_record.add(pair);
            if (this.verbose) {
                System.out.print("STAR" + t.image + ", ");
            }
        }
    }

    public final void list() throws ParseException {
        Vector park_current = (Vector)this.current_record.clone();
        this.current_record.clear();
        if (this.verbose) {
            System.out.print("list, ");
        }
        this.jj_consume_token(7);
        while (this.jj_2_16(3)) {
            this.parameter();
            while (this.jj_2_17(3)) {
                this.jj_consume_token(15);
                this.parameter();
            }
        }
        this.jj_consume_token(8);
        park_current.add(this.current_record.clone());
        this.current_record = (Vector)park_current.clone();
    }

    public final void data_section() throws ParseException {
        this.jj_consume_token(54);
        this.entity_instance_list();
        this.jj_consume_token(53);
    }

    public final void entity_instance_list() throws ParseException {
        this.entity_instance();
        while (this.jj_2_18(3)) {
            this.entity_instance();
        }
    }

    public final void entity_instance() throws ParseException {
        if (this.jj_2_19(3)) {
            if (this.verbose) {
                System.out.print("entity_instance, ");
            }
            this.simple_entity_instance();
        } else if (this.jj_2_20(3)) {
            this.complex_entity_instance();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public void simple_entity_instance() throws ParseException {
        Token name = null;
        name = this.jj_consume_token(29);
        this.jj_consume_token(17);
        if (this.jj_2_21(3)) {
            this.scope();
        }
        this.simple_record();
        this.jj_consume_token(13);
        Integer id = new Integer(name.image.substring(1, name.image.length()));
        EntityInstance ent = new EntityInstance(this.getModel(), id);
        EntityDefinition entDef = this.schema.getEntityBN((String)this.current_entity[0]);
        ent.setEntityDefinition(entDef);
        Iterator<Attribute> attribIter = entDef.getAttributes(true).iterator();
        int attribCount = entDef.getAttributes(true).size();
        int recordSize = this.current_record.size();
        Iterator recordIter = this.current_record.iterator();
        while (attribIter.hasNext()) {
            Attribute attr = attribIter.next();
            if (attr instanceof InverseAttribute) continue;
            AttributeInstance ai = new AttributeInstance();
            ai.setAttributeType((ExplicitAttribute)attr);
            Object tmp = recordIter.next();
            if (tmp instanceof String[]) {
                String[] singleval = (String[])tmp;
                ai.setValue(singleval[1]);
                ai.setP21Header(singleval[0]);
            } else if (tmp instanceof Vector) {
                Vector<String> tmpVec = new Vector<String>();
                Iterator vecIter = ((Vector)tmp).iterator();
                String header = "";
                while (vecIter.hasNext()) {
                    Object value = vecIter.next();
                    if (!(value instanceof String[])) continue;
                    String[] stringVal = (String[])value;
                    if (!header.equals("") && !stringVal[0].equals(header)) {
                        System.err.println("ERROR: " + stringVal[0] + " has different header than " + header);
                    }
                    tmpVec.add(stringVal[1]);
                    ai.setP21Header(stringVal[0]);
                    header = stringVal[0];
                }
                ai.setValue(tmpVec);
            } else if (tmp instanceof Object[]) {
                Object[] inline = (Object[])tmp;
                ai.setP21Header((String)inline[0]);
                if (inline[1] instanceof Vector) {
                    Vector<String> tmpVec = new Vector<String>();
                    for (Object value : (Vector)inline[1]) {
                        if (!(value instanceof String[])) continue;
                        tmpVec.add(((String[])value)[1]);
                    }
                    ai.setValue(tmpVec);
                }
            }
            ent.addAttribute(ai);
        }
        this.instances.put(id, ent);
    }

    public final void complex_entity_instance() throws ParseException {
        Object t = null;
        this.jj_consume_token(29);
        this.jj_consume_token(17);
        if (this.jj_2_22(3)) {
            this.scope();
        }
        this.subsuper_record();
        this.jj_consume_token(13);
        if (this.verbose) {
            System.out.println("Complex:" + t);
        }
    }

    public final void scope() throws ParseException {
        this.jj_consume_token(55);
        this.entity_instance_list();
        this.jj_consume_token(56);
        if (this.jj_2_23(3)) {
            this.export_list();
        }
    }

    public final void export_list() throws ParseException {
        this.jj_consume_token(20);
        this.jj_consume_token(29);
        while (this.jj_2_24(3)) {
            this.jj_consume_token(15);
            this.jj_consume_token(29);
        }
        this.jj_consume_token(20);
    }

    public final void simple_record() throws ParseException {
        Token record = null;
        this.current_entity = new Object[2];
        this.current_record = new Vector();
        record = this.jj_consume_token(22);
        if (this.verbose) {
            System.out.print("record: " + record.image + " ");
        }
        this.jj_consume_token(7);
        if (this.jj_2_25(3)) {
            this.parameter_list();
        }
        this.jj_consume_token(8);
        if (this.verbose) {
            System.out.println(" end record: " + this.current_record.size());
        }
        this.current_entity[0] = record.image;
        this.current_entity[1] = this.current_record.clone();
    }

    public final void subsuper_record() throws ParseException {
        this.jj_consume_token(7);
        this.simple_record_list();
        this.jj_consume_token(8);
    }

    public final void simple_record_list() throws ParseException {
        this.simple_record();
        while (this.jj_2_26(3)) {
            this.simple_record();
        }
        if (this.verbose) {
            System.out.print("simple_record_list triggered");
        }
    }

    public final void syntax() throws ParseException {
        this.exchange_file();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    private boolean jj_3_8() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_9()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_10()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_11()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_12()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_13()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_14()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_15()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_23() {
        return this.jj_3R_20();
    }

    private boolean jj_3_24() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_22() {
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_14() {
        return this.jj_scan_token(19);
    }

    private boolean jj_3_25() {
        return this.jj_3R_10();
    }

    private boolean jj_3_21() {
        return this.jj_3R_19();
    }

    private boolean jj_3R_12() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_3R_11();
    }

    private boolean jj_3_15() {
        return this.jj_3R_15();
    }

    private boolean jj_3_7() {
        return this.jj_3R_14();
    }

    private boolean jj_3_22() {
        return this.jj_3R_19();
    }

    private boolean jj_3_6() {
        return this.jj_3R_13();
    }

    private boolean jj_3R_21() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_scan_token(7)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_25()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(8);
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_3R_11();
    }

    private boolean jj_3_20() {
        return this.jj_3R_18();
    }

    private boolean jj_3_5() {
        return this.jj_3R_12();
    }

    private boolean jj_3R_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_6()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_7()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_14() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_20() {
        Token xsp;
        if (this.jj_scan_token(20)) {
            return true;
        }
        if (this.jj_scan_token(29)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_24());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(20);
    }

    private boolean jj_3R_10() {
        Token xsp;
        if (this.jj_3R_11()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_4());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_13() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_19() {
        if (this.jj_scan_token(55)) {
            return true;
        }
        return this.jj_3R_23();
    }

    private boolean jj_3_18() {
        return this.jj_3R_16();
    }

    private boolean jj_3_2() {
        return this.jj_3R_9();
    }

    private boolean jj_3R_17() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        if (this.jj_scan_token(17)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_21()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_21();
    }

    private boolean jj_3R_18() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        if (this.jj_scan_token(17)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_22()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_22();
    }

    private boolean jj_3_12() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3_3() {
        return this.jj_3R_10();
    }

    private boolean jj_3_17() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_3R_11();
    }

    private boolean jj_3_19() {
        return this.jj_3R_17();
    }

    private boolean jj_3R_16() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_20()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_9() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_scan_token(7)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_3()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_23() {
        return this.jj_3R_16();
    }

    private boolean jj_3_1() {
        return this.jj_3R_8();
    }

    private boolean jj_3_11() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_8() {
        return this.jj_3R_9();
    }

    private boolean jj_3_16() {
        Token xsp;
        if (this.jj_3R_11()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_17());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_10() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3_26() {
        return this.jj_3R_21();
    }

    private boolean jj_3_9() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3R_15() {
        Token xsp;
        if (this.jj_scan_token(7)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_16());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(8);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[0];
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[0];
    }

    public Part21Parser(InputStream stream) {
        this(stream, null);
    }

    public Part21Parser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new Part21ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Part21Parser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new Part21ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Part21Parser(Part21ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Part21ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[57];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 0; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 57; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 26; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        Part21Parser.jj_la1_init_0();
        Part21Parser.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

