/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.testcontainers;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.regex.Pattern;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.DockerImageName;

public class OpensearchContainer<SELF extends OpensearchContainer<SELF>>
extends GenericContainer<SELF> {
    private static final Pattern OPENSEARCH_INITIAL_PASSWORD_VERSION = Pattern.compile("^(([3-9][.]\\d+[.]\\d+|[2][.][1][2-9]+[.]\\d+|[2][.][2-9]\\d+[.]\\d+)(-SNAPSHOT)?|latest)$");
    private static final String DEFAULT_USER = "admin";
    private static final String DEFAULT_PASSWORD = "admin";
    private static final String DEFAULT_INITIAL_PASSWORD = "_ad0m#Ns_";
    private static final int DEFAULT_HTTP_PORT = 9200;
    private static final int DEFAULT_TCP_PORT = 9300;
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"opensearchproject/opensearch");
    private boolean disableSecurity = true;
    private boolean requireInitialPassword = false;
    private String password = "admin";

    public OpensearchContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public OpensearchContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        String version = dockerImageName.getVersionPart();
        this.requireInitialPassword = version == null || version.isBlank() ? false : OPENSEARCH_INITIAL_PASSWORD_VERSION.matcher(version).matches();
    }

    public SELF withSecurityEnabled() {
        this.disableSecurity = false;
        return (SELF)((Object)((OpensearchContainer)this.self()));
    }

    protected void configure() {
        super.configure();
        this.withNetworkAliases(new String[]{"opensearch-" + Base58.randomString((int)6)});
        if (!this.getEnvMap().containsKey("discovery.type")) {
            this.withEnv("discovery.type", "single-node");
        }
        if (this.disableSecurity) {
            this.withEnv("DISABLE_SECURITY_PLUGIN", Boolean.toString(this.disableSecurity));
        } else if (this.requireInitialPassword) {
            this.password = (String)this.getEnvMap().get("OPENSEARCH_INITIAL_ADMIN_PASSWORD");
            if (this.password == null || this.password.isBlank()) {
                this.withEnv("OPENSEARCH_INITIAL_ADMIN_PASSWORD", DEFAULT_INITIAL_PASSWORD);
                this.password = DEFAULT_INITIAL_PASSWORD;
            }
        }
        this.addExposedPorts(new int[]{9200, 9300});
        WaitStrategy waitStrategy = !this.disableSecurity ? new HttpWaitStrategy().usingTls().allowInsecure().forPort(9200).withBasicCredentials("admin", this.password).forStatusCodeMatching(response -> response == 200 || response == 401).withReadTimeout(Duration.ofSeconds(10L)).withStartupTimeout(Duration.ofMinutes(5L)) : new HttpWaitStrategy().forPort(9200).forStatusCodeMatching(response -> response == 200).withReadTimeout(Duration.ofSeconds(10L)).withStartupTimeout(Duration.ofMinutes(5L));
        this.setWaitStrategy(waitStrategy);
    }

    public String getHttpHostAddress() {
        return (this.disableSecurity ? "http://" : "https://") + this.getHost() + ":" + this.getMappedPort(9200);
    }

    public boolean isSecurityEnabled() {
        return !this.disableSecurity;
    }

    @Deprecated
    public InetSocketAddress getTcpHost() {
        return new InetSocketAddress(this.getHost(), (int)this.getMappedPort(9300));
    }

    public String getUsername() {
        return "admin";
    }

    public String getPassword() {
        return this.password;
    }
}

