/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cli;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.util.KeyValuePair;
import org.opensearch.cli.Command;
import org.opensearch.cli.Terminal;
import org.opensearch.cli.UserException;
import org.opensearch.core.internal.io.IOUtils;

public class MultiCommand
extends Command {
    protected final Map<String, Command> subcommands = new LinkedHashMap<String, Command>();
    private final NonOptionArgumentSpec<String> arguments = this.parser.nonOptions("command");
    private final OptionSpec<KeyValuePair> settingOption = this.parser.accepts("E", "Configure a setting").withRequiredArg().ofType(KeyValuePair.class);

    public MultiCommand(String description, Runnable beforeMain) {
        super(description, beforeMain);
        this.parser.posixlyCorrect(true);
    }

    @Override
    protected void printAdditionalHelp(Terminal terminal) {
        if (this.subcommands.isEmpty()) {
            throw new IllegalStateException("No subcommands configured");
        }
        terminal.println("Commands");
        terminal.println("--------");
        for (Map.Entry<String, Command> subcommand : this.subcommands.entrySet()) {
            terminal.println(subcommand.getKey() + " - " + subcommand.getValue().description);
        }
        terminal.println("");
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options) throws Exception {
        if (this.subcommands.isEmpty()) {
            throw new IllegalStateException("No subcommands configured");
        }
        ArrayList<CallSite> args = new ArrayList<CallSite>(this.arguments.values(options));
        if (args.isEmpty()) {
            throw new UserException(64, "Missing command");
        }
        String subcommandName = (String)args.remove(0);
        Command subcommand = this.subcommands.get(subcommandName);
        if (subcommand == null) {
            throw new UserException(64, "Unknown command [" + subcommandName + "]");
        }
        for (KeyValuePair pair : this.settingOption.values(options)) {
            args.add((CallSite)((Object)("-E" + pair)));
        }
        subcommand.mainWithoutErrorHandling(args.toArray(new String[0]), terminal);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.subcommands.values());
    }
}

