/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.opc.lib.da.browser;

import java.net.UnknownHostException;
import java.util.Collection;
import java.util.EnumSet;
import org.jinterop.dcom.common.JIException;
import org.openscada.opc.dcom.common.impl.EnumString;
import org.openscada.opc.dcom.da.OPCBROWSETYPE;
import org.openscada.opc.dcom.da.impl.OPCBrowseServerAddressSpace;
import org.openscada.opc.lib.da.browser.Access;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseBrowser {
    private static Logger _log = LoggerFactory.getLogger(BaseBrowser.class);
    protected OPCBrowseServerAddressSpace _browser;
    protected int _batchSize;

    public BaseBrowser(OPCBrowseServerAddressSpace browser) {
        this(browser, EnumString.DEFAULT_BATCH_SIZE);
    }

    public BaseBrowser(OPCBrowseServerAddressSpace browser, int batchSize) {
        this._browser = browser;
        this._batchSize = batchSize;
    }

    public void setBatchSize(int batchSize) {
        this._batchSize = batchSize;
    }

    public int getBatchSize() {
        return this._batchSize;
    }

    protected Collection<String> browse(OPCBROWSETYPE type, String filterCriteria, EnumSet<Access> accessMask, int variantType) throws IllegalArgumentException, UnknownHostException, JIException {
        int accessMaskValue = 0;
        if (accessMask.contains((Object)Access.READ)) {
            accessMaskValue |= Access.READ.getCode();
        }
        if (accessMask.contains((Object)Access.WRITE)) {
            accessMaskValue |= Access.WRITE.getCode();
        }
        _log.debug("Browsing with a batch size of " + this._batchSize);
        return this._browser.browse(type, filterCriteria, accessMaskValue, variantType).asCollection(this._batchSize);
    }

    public Collection<String> getAccessPaths(String itemId) throws IllegalArgumentException, UnknownHostException, JIException {
        return this._browser.browseAccessPaths(itemId).asCollection(this._batchSize);
    }
}

