/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.opc.lib.da;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.JIClsid;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.openscada.opc.dcom.da.OPCNAMESPACETYPE;
import org.openscada.opc.dcom.da.OPCSERVERSTATUS;
import org.openscada.opc.dcom.da.impl.OPCBrowseServerAddressSpace;
import org.openscada.opc.dcom.da.impl.OPCGroupStateMgt;
import org.openscada.opc.dcom.da.impl.OPCServer;
import org.openscada.opc.lib.common.AlreadyConnectedException;
import org.openscada.opc.lib.common.ConnectionInformation;
import org.openscada.opc.lib.common.NotConnectedException;
import org.openscada.opc.lib.da.DuplicateGroupException;
import org.openscada.opc.lib.da.ErrorMessageResolver;
import org.openscada.opc.lib.da.Group;
import org.openscada.opc.lib.da.ServerConnectionStateListener;
import org.openscada.opc.lib.da.ServerStateOperation;
import org.openscada.opc.lib.da.UnknownGroupException;
import org.openscada.opc.lib.da.browser.FlatBrowser;
import org.openscada.opc.lib.da.browser.TreeBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    private static Logger logger = LoggerFactory.getLogger(Server.class);
    private final ConnectionInformation connectionInformation;
    private JISession session;
    private JIComServer comServer;
    private OPCServer server;
    private boolean defaultActive = true;
    private int defaultUpdateRate = 1000;
    private Integer defaultTimeBias;
    private Float defaultPercentDeadband;
    private int defaultLocaleID = 0;
    private ErrorMessageResolver errorMessageResolver;
    private final Map<Integer, Group> groups = new HashMap<Integer, Group>();
    private final List<ServerConnectionStateListener> stateListeners = new CopyOnWriteArrayList<ServerConnectionStateListener>();
    private final ScheduledExecutorService scheduler;

    public Server(ConnectionInformation connectionInformation, ScheduledExecutorService scheduler) {
        this.connectionInformation = connectionInformation;
        this.scheduler = scheduler;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    protected synchronized boolean isConnected() {
        return this.session != null;
    }

    public synchronized void connect() throws IllegalArgumentException, UnknownHostException, JIException, AlreadyConnectedException {
        if (this.isConnected()) {
            throw new AlreadyConnectedException();
        }
        int socketTimeout = Integer.getInteger("rpc.socketTimeout", 0);
        logger.info(String.format("Socket timeout: %s ", socketTimeout));
        try {
            if (this.connectionInformation.getClsid() != null) {
                this.session = JISession.createSession((String)this.connectionInformation.getDomain(), (String)this.connectionInformation.getUser(), (String)this.connectionInformation.getPassword());
                this.session.setGlobalSocketTimeout(socketTimeout);
                this.comServer = new JIComServer(JIClsid.valueOf((String)this.connectionInformation.getClsid()), this.connectionInformation.getHost(), this.session);
            } else if (this.connectionInformation.getProgId() != null) {
                this.session = JISession.createSession((String)this.connectionInformation.getDomain(), (String)this.connectionInformation.getUser(), (String)this.connectionInformation.getPassword());
                this.session.setGlobalSocketTimeout(socketTimeout);
                this.comServer = new JIComServer(JIProgId.valueOf((String)this.connectionInformation.getProgId()), this.connectionInformation.getHost(), this.session);
            } else {
                throw new IllegalArgumentException("Neither clsid nor progid is valid!");
            }
            this.server = new OPCServer(this.comServer.createInstance());
            this.errorMessageResolver = new ErrorMessageResolver(this.server.getCommon(), this.defaultLocaleID);
        }
        catch (UnknownHostException e) {
            logger.info("Unknown host when connecting to server", (Throwable)e);
            this.cleanup();
            throw e;
        }
        catch (JIException e) {
            logger.info("Failed to connect to server", (Throwable)e);
            this.cleanup();
            throw e;
        }
        catch (Throwable e) {
            logger.warn("Unknown error", e);
            this.cleanup();
            throw new RuntimeException(e);
        }
        this.notifyConnectionStateChange(true);
    }

    protected void cleanup() {
        logger.info("Destroying DCOM session...");
        final JISession destructSession = this.session;
        Thread destructor = new Thread(new Runnable(){

            @Override
            public void run() {
                block5: {
                    long ts = System.currentTimeMillis();
                    try {
                        try {
                            logger.debug("Starting destruction of DCOM session");
                            JISession.destroySession((JISession)destructSession);
                            logger.info("Destructed DCOM session");
                        }
                        catch (Throwable e) {
                            logger.warn("Failed to destruct DCOM session", e);
                            logger.info(String.format("Session destruction took %s ms", System.currentTimeMillis() - ts));
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        logger.info(String.format("Session destruction took %s ms", System.currentTimeMillis() - ts));
                        throw throwable;
                    }
                    logger.info(String.format("Session destruction took %s ms", System.currentTimeMillis() - ts));
                }
            }
        }, "UtgardSessionDestructor");
        destructor.setName("OPCSessionDestructor");
        destructor.setDaemon(true);
        destructor.start();
        logger.info("Destroying DCOM session... forked");
        this.errorMessageResolver = null;
        this.session = null;
        this.comServer = null;
        this.server = null;
        this.groups.clear();
    }

    public synchronized void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.notifyConnectionStateChange(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.cleanup();
    }

    public void dispose() {
        this.disconnect();
    }

    protected synchronized Group getGroup(OPCGroupStateMgt groupMgt) throws JIException, IllegalArgumentException, UnknownHostException {
        Integer serverHandle = groupMgt.getState().getServerHandle();
        if (this.groups.containsKey(serverHandle)) {
            return this.groups.get(serverHandle);
        }
        Group group = new Group(this, serverHandle, groupMgt);
        this.groups.put(serverHandle, group);
        return group;
    }

    public synchronized Group addGroup(String name) throws NotConnectedException, IllegalArgumentException, UnknownHostException, JIException, DuplicateGroupException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        try {
            OPCGroupStateMgt groupMgt = this.server.addGroup(name, this.defaultActive, this.defaultUpdateRate, 0, this.defaultTimeBias, this.defaultPercentDeadband, this.defaultLocaleID);
            return this.getGroup(groupMgt);
        }
        catch (JIException e) {
            switch (e.getErrorCode()) {
                case -1073479668: {
                    throw new DuplicateGroupException();
                }
            }
            throw e;
        }
    }

    public Group addGroup() throws IllegalArgumentException, UnknownHostException, NotConnectedException, JIException, DuplicateGroupException {
        return this.addGroup(null);
    }

    public Group findGroup(String name) throws IllegalArgumentException, UnknownHostException, JIException, UnknownGroupException, NotConnectedException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        try {
            OPCGroupStateMgt groupMgt = this.server.getGroupByName(name);
            return this.getGroup(groupMgt);
        }
        catch (JIException e) {
            switch (e.getErrorCode()) {
                case -2147024809: {
                    throw new UnknownGroupException(name);
                }
            }
            throw e;
        }
    }

    public int getDefaultLocaleID() {
        return this.defaultLocaleID;
    }

    public void setDefaultLocaleID(int defaultLocaleID) {
        this.defaultLocaleID = defaultLocaleID;
    }

    public Float getDefaultPercentDeadband() {
        return this.defaultPercentDeadband;
    }

    public void setDefaultPercentDeadband(Float defaultPercentDeadband) {
        this.defaultPercentDeadband = defaultPercentDeadband;
    }

    public Integer getDefaultTimeBias() {
        return this.defaultTimeBias;
    }

    public void setDefaultTimeBias(Integer defaultTimeBias) {
        this.defaultTimeBias = defaultTimeBias;
    }

    public int getDefaultUpdateRate() {
        return this.defaultUpdateRate;
    }

    public void setDefaultUpdateRate(int defaultUpdateRate) {
        this.defaultUpdateRate = defaultUpdateRate;
    }

    public boolean isDefaultActive() {
        return this.defaultActive;
    }

    public void setDefaultActive(boolean defaultActive) {
        this.defaultActive = defaultActive;
    }

    public FlatBrowser getFlatBrowser() {
        OPCBrowseServerAddressSpace browser = this.server.getBrowser();
        if (browser == null) {
            return null;
        }
        return new FlatBrowser(browser);
    }

    public TreeBrowser getTreeBrowser() throws JIException {
        OPCBrowseServerAddressSpace browser = this.server.getBrowser();
        if (browser == null) {
            return null;
        }
        if (browser.queryOrganization() != OPCNAMESPACETYPE.OPC_NS_HIERARCHIAL) {
            return null;
        }
        return new TreeBrowser(browser);
    }

    public synchronized String getErrorMessage(int errorCode) {
        if (this.errorMessageResolver == null) {
            return String.format("Unknown error (%08X)", errorCode);
        }
        String message = this.errorMessageResolver.getMessage(errorCode);
        if (message != null) {
            return message;
        }
        return String.format("Unknown error (%08X)", errorCode);
    }

    public synchronized void addStateListener(ServerConnectionStateListener listener) {
        this.stateListeners.add(listener);
        listener.connectionStateChanged(this.isConnected());
    }

    public synchronized void removeStateListener(ServerConnectionStateListener listener) {
        this.stateListeners.remove(listener);
    }

    protected void notifyConnectionStateChange(boolean connected) {
        ArrayList<ServerConnectionStateListener> list = new ArrayList<ServerConnectionStateListener>(this.stateListeners);
        for (ServerConnectionStateListener listener : list) {
            listener.connectionStateChanged(connected);
        }
    }

    public OPCSERVERSTATUS getServerState(int timeout) throws Throwable {
        return new ServerStateOperation(this.server).getServerState(timeout);
    }

    public OPCSERVERSTATUS getServerState() {
        try {
            return this.getServerState(2500);
        }
        catch (Throwable e) {
            logger.info("Server connection failed", e);
            this.dispose();
            return null;
        }
    }

    public void removeGroup(Group group, boolean force) throws JIException {
        if (this.groups.containsKey(group.getServerHandle())) {
            this.server.removeGroup(group.getServerHandle(), force);
            this.groups.remove(group.getServerHandle());
        }
    }
}

