/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.opc.lib.da;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.openscada.opc.lib.da.AutoReconnectListener;
import org.openscada.opc.lib.da.AutoReconnectState;
import org.openscada.opc.lib.da.Server;
import org.openscada.opc.lib.da.ServerConnectionStateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoReconnectController
implements ServerConnectionStateListener {
    private static Logger _log = LoggerFactory.getLogger(AutoReconnectController.class);
    private static final int DEFAULT_DELAY = 5000;
    private int _delay;
    private final Server _server;
    private final Set<AutoReconnectListener> _listeners = new CopyOnWriteArraySet<AutoReconnectListener>();
    private AutoReconnectState _state = AutoReconnectState.DISABLED;
    private Thread _connectTask = null;

    public AutoReconnectController(Server server) {
        this(server, 5000);
    }

    public AutoReconnectController(Server server, int delay) {
        this.setDelay(delay);
        this._server = server;
        this._server.addStateListener(this);
    }

    public void addListener(AutoReconnectListener listener) {
        if (listener != null) {
            this._listeners.add(listener);
            listener.stateChanged(this._state);
        }
    }

    public void removeListener(AutoReconnectListener listener) {
        this._listeners.remove(listener);
    }

    protected void notifyStateChange(AutoReconnectState state) {
        this._state = state;
        for (AutoReconnectListener listener : this._listeners) {
            listener.stateChanged(state);
        }
    }

    public int getDelay() {
        return this._delay;
    }

    public void setDelay(int delay) {
        if (delay <= 0) {
            delay = 5000;
        }
        this._delay = delay;
    }

    public synchronized void connect() {
        if (this.isRequested()) {
            return;
        }
        _log.debug("Requesting connection");
        this.notifyStateChange(AutoReconnectState.DISCONNECTED);
        this.triggerReconnect(false);
    }

    public synchronized void disconnect() {
        if (!this.isRequested()) {
            return;
        }
        _log.debug("Un-Requesting connection");
        this.notifyStateChange(AutoReconnectState.DISABLED);
        this._server.disconnect();
    }

    public boolean isRequested() {
        return this._state != AutoReconnectState.DISABLED;
    }

    @Override
    public synchronized void connectionStateChanged(boolean connected) {
        _log.debug("Connection state changed: " + connected);
        if (!connected) {
            if (this.isRequested()) {
                this.notifyStateChange(AutoReconnectState.DISCONNECTED);
                this.triggerReconnect(true);
            }
        } else if (!this.isRequested()) {
            this._server.disconnect();
        } else {
            this.notifyStateChange(AutoReconnectState.CONNECTED);
        }
    }

    private synchronized void triggerReconnect(final boolean wait) {
        if (this._connectTask != null) {
            _log.info("Connect thread already running");
            return;
        }
        _log.debug("Trigger reconnect");
        this._connectTask = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean result = false;
                try {
                    result = AutoReconnectController.this.performReconnect(wait);
                }
                catch (Throwable throwable) {
                    AutoReconnectController.this._connectTask = null;
                    _log.debug(String.format("performReconnect completed : %s", result));
                    if (!result) {
                        AutoReconnectController.this.triggerReconnect(true);
                    }
                    throw throwable;
                }
                AutoReconnectController.this._connectTask = null;
                _log.debug(String.format("performReconnect completed : %s", result));
                if (!result) {
                    AutoReconnectController.this.triggerReconnect(true);
                }
            }
        }, "OPCReconnectThread");
        this._connectTask.setDaemon(true);
        this._connectTask.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performReconnect(boolean wait) {
        try {
            if (wait) {
                this.notifyStateChange(AutoReconnectState.WAITING);
                _log.debug(String.format("Delaying (%s)...", this._delay));
                Thread.sleep(this._delay);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.isRequested()) {
            _log.debug("Request canceled during delay");
            return true;
        }
        _log.debug("Connecting to server");
        this.notifyStateChange(AutoReconnectState.CONNECTING);
        AutoReconnectController autoReconnectController = this;
        synchronized (autoReconnectController) {
            try {
                this._server.connect();
                return true;
            }
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Throwable e) {
                    _log.info("Re-connect failed", e);
                    this.notifyStateChange(AutoReconnectState.DISCONNECTED);
                    return false;
                }
            }
        }
    }
}

