/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.uuid;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Random;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UUIDGenerator {
    private static final Logger logger = LoggerFactory.getLogger(UUIDGenerator.class);
    private static byte[] node;
    private static long lastTime;
    private static int sequence;
    private static final Random random;
    private static final boolean useDummyMac;
    private static final int MAX_SEQUENCE_NUMBER = 16384;
    private static long TIME_DIFF;
    private static long lastMillis;
    private static long lastNanos;

    static {
        useDummyMac = Boolean.getBoolean("jinterop.useDummyMac");
        random = new SecureRandom();
        sequence = random.nextInt();
        node = UUIDGenerator.getMacAddress();
        TIME_DIFF = 122192928000000000L;
    }

    private static byte[] getMacAddress() {
        byte[] dummy = new byte[6];
        if (!useDummyMac) {
            try {
                Enumeration<NetworkInterface> i = NetworkInterface.getNetworkInterfaces();
                while (i.hasMoreElements()) {
                    NetworkInterface ni = i.nextElement();
                    try {
                        byte[] mac;
                        if (ni.isLoopback() || (mac = ni.getHardwareAddress()) == null) continue;
                        if (mac.length == dummy.length) {
                            return mac;
                        }
                        if (mac.length > dummy.length) {
                            System.arraycopy(mac, 0, dummy, 0, Math.min(dummy.length, mac.length));
                            return dummy;
                        }
                        System.arraycopy(mac, 0, dummy, 0, Math.min(dummy.length, mac.length));
                        return dummy;
                    }
                    catch (SocketException socketException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Failed to generate node id. Using dummy.", (Throwable)e);
            }
        }
        random.nextBytes(dummy);
        dummy[0] = (byte)(dummy[0] | 0xFFFFFF80);
        return dummy;
    }

    public static synchronized UUID generateID() {
        UUIDGenerator.updateTime(UUIDGenerator.makeTime());
        byte[] data = new byte[8];
        data[3] = (byte)((lastTime & 0xFFL) >> 0 & 0xFFL);
        data[2] = (byte)((lastTime & 0xFF00L) >> 8 & 0xFFL);
        data[1] = (byte)((lastTime & 0xFF0000L) >> 16 & 0xFFL);
        data[0] = (byte)((lastTime & 0xFF000000L) >> 24 & 0xFFL);
        data[5] = (byte)((lastTime & 0xFF00000000L) >> 32 & 0xFFL);
        data[4] = (byte)((lastTime & 0xFF0000000000L) >> 40 & 0xFFL);
        data[7] = (byte)((lastTime & 0xFF000000000000L) >> 48 & 0xFFL);
        data[6] = (byte)((lastTime & 0xFF00000000000000L) >> 56 & 0xFFL);
        data[6] = (byte)(data[6] & 0xF);
        data[6] = (byte)(data[6] | 0x10);
        long l1 = 0L;
        int i = 0;
        while (i < 8) {
            l1 = l1 << 8 | (long)(data[i] & 0xFF);
            ++i;
        }
        long l2 = 0L;
        data[1] = (byte)(sequence & 0xFF & 0xFF);
        data[0] = (byte)((sequence & 0xFF00) >> 8 & 0xFF);
        data[0] = (byte)(data[0] & 0x3F);
        data[0] = (byte)(data[0] | 0x80);
        int i2 = 0;
        while (i2 < 2) {
            l2 = l2 << 8 | (long)(data[i2] & 0xFF);
            ++i2;
        }
        i2 = 0;
        while (i2 < 6) {
            l2 = l2 << 8 | (long)(node[i2] & 0xFF);
            ++i2;
        }
        return new UUID(l1, l2);
    }

    private static void updateTime(long time) {
        if (lastTime >= time) {
            ++sequence;
            sequence %= 16384;
        } else {
            lastTime = time;
        }
    }

    static long makeTime() {
        long time = System.currentTimeMillis() * 10000L;
        long nanos = System.nanoTime();
        if (lastMillis == time) {
            time += (nanos - lastNanos) / 100L;
        } else {
            lastMillis = time;
            lastNanos = nanos;
        }
        return TIME_DIFF + time;
    }
}

