/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python;

import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.python.tree.Py;
import org.openrewrite.python.tree.PyContainer;
import org.openrewrite.python.tree.PyLeftPadded;
import org.openrewrite.python.tree.PyRightPadded;
import org.openrewrite.python.tree.PySpace;

public class PythonVisitor<P>
extends JavaVisitor<P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof Py.CompilationUnit;
    }

    public String getLanguage() {
        return "python";
    }

    public J visitCompilationUnit(Py.CompilationUnit cu, P p) {
        Py.CompilationUnit c = cu;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.getPadding().withImports(ListUtils.map(c.getPadding().getImports(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.IMPORT, p)));
        c = c.withStatements(ListUtils.map(c.getStatements(), e -> (Statement)this.visitAndCast((Tree)e, p)));
        c = c.withEof(this.visitSpace(c.getEof(), Space.Location.COMPILATION_UNIT_EOF, p));
        return c;
    }

    public J visitKeyValue(Py.KeyValue keyValue, P p) {
        Py.KeyValue e = keyValue;
        Expression temp = (Expression)this.visitExpression(e = e.withPrefix(this.visitSpace(e.getPrefix(), PySpace.Location.DICT_ENTRY, p)), p);
        if (!(temp instanceof Py.KeyValue)) {
            return temp;
        }
        e = (Py.KeyValue)temp;
        e = e.getPadding().withKey(this.visitRightPadded(e.getPadding().getKey(), PyRightPadded.Location.DICT_ENTRY_KEY, p));
        e = e.withValue((Expression)this.visitAndCast((Tree)e.getValue(), p));
        e = e.withType(this.visitType(e.getType(), p));
        return e;
    }

    public J visitDictLiteral(Py.DictLiteral dict, P p) {
        Py.DictLiteral d = dict;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), PySpace.Location.DICT_LITERAL_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(d = d.withMarkers(this.visitMarkers(d.getMarkers(), p)), p);
        if (!(temp instanceof Py.DictLiteral)) {
            return temp;
        }
        d = (Py.DictLiteral)temp;
        d = d.getPadding().withElements(this.visitContainer(d.getPadding().getElements(), PyContainer.Location.DICT_LITERAL_ELEMENTS, p));
        return d;
    }

    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        throw new UnsupportedOperationException("Python has a different structure for its compilation unit. See P.CompilationUnit.");
    }

    public J visitPassStatement(Py.PassStatement ogPass, P p) {
        Py.PassStatement pass = ogPass;
        pass = pass.withPrefix(this.visitSpace(pass.getPrefix(), PySpace.Location.PASS_PREFIX, p));
        pass = pass.withMarkers(this.visitMarkers(pass.getMarkers(), p));
        return this.visitStatement(pass, p);
    }

    public J visitComprehensionExpression(Py.ComprehensionExpression ogComp, P p) {
        Py.ComprehensionExpression comp = ogComp;
        comp = comp.withPrefix(this.visitSpace(comp.getPrefix(), PySpace.Location.COMPREHENSION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(comp = comp.withMarkers(this.visitMarkers(comp.getMarkers(), p)), p);
        if (!(temp instanceof Py.ComprehensionExpression)) {
            return temp;
        }
        comp = (Py.ComprehensionExpression)temp;
        comp = comp.withResult((Expression)this.visitAndCast((Tree)comp.getResult(), p));
        comp = comp.withClauses(ListUtils.map(comp.getClauses(), clause -> (Py.ComprehensionExpression.Clause)this.visitAndCast((Tree)clause, p)));
        comp = comp.withSuffix(this.visitSpace(comp.getSuffix(), PySpace.Location.COMPREHENSION_SUFFIX, p));
        comp = comp.withType(this.visitType(comp.getType(), p));
        return comp;
    }

    public J visitComprehensionClause(Py.ComprehensionExpression.Clause ogClause, P p) {
        Py.ComprehensionExpression.Clause clause = ogClause;
        clause = clause.withPrefix(this.visitSpace(clause.getPrefix(), PySpace.Location.COMPREHENSION_CLAUSE_PREFIX, p));
        clause = clause.withMarkers(this.visitMarkers(clause.getMarkers(), p));
        clause = clause.withIteratorVariable((Expression)this.visitAndCast((Tree)clause.getIteratorVariable(), p));
        clause = clause.withConditions(ListUtils.map(clause.getConditions(), condition -> (Py.ComprehensionExpression.Condition)this.visitAndCast((Tree)condition, p)));
        return clause;
    }

    public J visitComprehensionCondition(Py.ComprehensionExpression.Condition ogCondition, P p) {
        Py.ComprehensionExpression.Condition condition = ogCondition;
        condition = condition.withPrefix(this.visitSpace(condition.getPrefix(), PySpace.Location.COMPREHENSION_CONDITION_PREFIX, p));
        condition = condition.withMarkers(this.visitMarkers(condition.getMarkers(), p));
        condition = condition.withExpression((Expression)this.visitAndCast((Tree)condition.getExpression(), p));
        return condition;
    }

    public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, PyRightPadded.Location loc, P p) {
        return super.visitRightPadded(right, JRightPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public <T> JLeftPadded<T> visitLeftPadded(@Nullable JLeftPadded<T> left, PyLeftPadded.Location loc, P p) {
        return super.visitLeftPadded(left, JLeftPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public Space visitSpace(Space space, PySpace.Location loc, P p) {
        return this.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    public <J2 extends J> JContainer<J2> visitContainer(JContainer<J2> container, PyContainer.Location loc, P p) {
        return super.visitContainer(container, JContainer.Location.LANGUAGE_EXTENSION, p);
    }

    public J visitAwaitExpression(Py.AwaitExpression ogAwait, P p) {
        Py.AwaitExpression await = ogAwait;
        await = await.withPrefix(this.visitSpace(await.getPrefix(), PySpace.Location.AWAIT_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(await = await.withMarkers(this.visitMarkers(await.getMarkers(), p)), p);
        if (!(temp instanceof Py.AwaitExpression)) {
            return temp;
        }
        await = (Py.AwaitExpression)temp;
        await = await.withExpression((Expression)this.visitAndCast((Tree)await.getExpression(), p));
        await = await.withType(this.visitType(await.getType(), p));
        return await;
    }

    public J visitAssertStatement(Py.AssertStatement ogAssert, P p) {
        Py.AssertStatement assert_ = ogAssert;
        assert_ = assert_.withPrefix(this.visitSpace(assert_.getPrefix(), PySpace.Location.ASSERT_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(assert_ = assert_.withMarkers(this.visitMarkers(assert_.getMarkers(), p)), p);
        if (!(temp instanceof Py.AssertStatement)) {
            return temp;
        }
        assert_ = (Py.AssertStatement)temp;
        assert_ = assert_.getPadding().withExpressions(ListUtils.map(assert_.getPadding().getExpressions(), t -> this.visitRightPadded((JRightPadded)t, PyRightPadded.Location.ASSERT_ELEMENT, p)));
        return assert_;
    }

    public J visitYieldExpression(Py.YieldExpression ogYield, P p) {
        Py.YieldExpression yield = ogYield;
        yield = yield.withPrefix(this.visitSpace(yield.getPrefix(), PySpace.Location.YIELD_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(yield = yield.withMarkers(this.visitMarkers(yield.getMarkers(), p)), p);
        if (!(temp instanceof Py.YieldExpression)) {
            return temp;
        }
        yield = (Py.YieldExpression)temp;
        yield = yield.getPadding().withFrom(this.visitLeftPadded(yield.getPadding().getFrom(), PyLeftPadded.Location.YIELD_FROM, p));
        yield = yield.getPadding().withExpressions(ListUtils.map(yield.getPadding().getExpressions(), t -> this.visitRightPadded((JRightPadded)t, PyRightPadded.Location.YIELD_ELEMENT, p)));
        return yield;
    }

    public J visitDelStatement(Py.DelStatement ogDel, P p) {
        Py.DelStatement del = ogDel;
        del = del.withPrefix(this.visitSpace(del.getPrefix(), PySpace.Location.DEL_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(del = del.withMarkers(this.visitMarkers(del.getMarkers(), p)), p);
        if (!(temp instanceof Py.DelStatement)) {
            return temp;
        }
        del = (Py.DelStatement)temp;
        del = del.getPadding().withTargets(ListUtils.map(del.getPadding().getTargets(), t -> this.visitRightPadded((JRightPadded)t, PyRightPadded.Location.DEL_ELEMENT, p)));
        return del;
    }

    public J visitExceptionType(Py.ExceptionType ogType, P p) {
        Py.ExceptionType type = ogType;
        type = type.withPrefix(this.visitSpace(type.getPrefix(), PySpace.Location.EXCEPTION_TYPE_PREFIX, p));
        type = type.withMarkers(this.visitMarkers(type.getMarkers(), p));
        type = type.withExpression((Expression)this.visitAndCast((Tree)type.getExpression(), p));
        return type;
    }

    public J visitTypeHint(Py.TypeHint ogType, P p) {
        Py.TypeHint type = ogType;
        type = type.withPrefix(this.visitSpace(type.getPrefix(), PySpace.Location.EXCEPTION_TYPE_PREFIX, p));
        type = type.withMarkers(this.visitMarkers(type.getMarkers(), p));
        type = type.withExpression((Expression)this.visitAndCast((Tree)type.getExpression(), p));
        return type;
    }

    public J visitVariableScopeStatement(Py.VariableScopeStatement ogStmt, P p) {
        Py.VariableScopeStatement stmt = ogStmt;
        stmt = stmt.withPrefix(this.visitSpace(stmt.getPrefix(), PySpace.Location.VARIABLE_SCOPE_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(stmt = stmt.withMarkers(this.visitMarkers(stmt.getMarkers(), p)), p);
        if (!(temp instanceof Py.VariableScopeStatement)) {
            return temp;
        }
        stmt = (Py.VariableScopeStatement)temp;
        stmt = stmt.getPadding().withNames(ListUtils.map(stmt.getPadding().getNames(), t -> this.visitRightPadded((JRightPadded)t, PyRightPadded.Location.VARIABLE_SCOPE_ELEMENT, p)));
        return stmt;
    }

    public J visitErrorFromExpression(Py.ErrorFromExpression ogExpr, P p) {
        Py.ErrorFromExpression expr = ogExpr;
        expr = expr.withPrefix(this.visitSpace(expr.getPrefix(), PySpace.Location.ERROR_FROM_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(expr = expr.withMarkers(this.visitMarkers(expr.getMarkers(), p)), p);
        if (!(temp instanceof Py.ErrorFromExpression)) {
            return temp;
        }
        expr = (Py.ErrorFromExpression)temp;
        expr = expr.withError((Expression)this.visitAndCast((Tree)expr.getError(), p));
        expr = expr.getPadding().withFrom(this.visitLeftPadded(expr.getPadding().getFrom(), PyLeftPadded.Location.ERROR_FROM, p));
        return expr;
    }

    public J visitMatchCasePattern(Py.MatchCase.Pattern ogPattern, P p) {
        Py.MatchCase.Pattern pattern = ogPattern;
        pattern = pattern.withPrefix(this.visitSpace(pattern.getPrefix(), PySpace.Location.MATCH_PATTERN_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(pattern = pattern.withMarkers(this.visitMarkers(pattern.getMarkers(), p)), p);
        if (!(temp instanceof Py.MatchCase.Pattern)) {
            return temp;
        }
        pattern = (Py.MatchCase.Pattern)temp;
        pattern.withChildren(ListUtils.map(pattern.getChildren(), child -> (Expression)this.visitAndCast((Tree)child, p)));
        return pattern;
    }

    public J visitMatchCase(Py.MatchCase ogMatch, P p) {
        Py.MatchCase case_ = ogMatch;
        case_ = case_.withPrefix(this.visitSpace(case_.getPrefix(), PySpace.Location.MATCH_CASE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(case_ = case_.withMarkers(this.visitMarkers(case_.getMarkers(), p)), p);
        if (!(temp instanceof Py.MatchCase)) {
            return temp;
        }
        case_ = (Py.MatchCase)temp;
        case_ = case_.getPadding().withGuard(this.visitLeftPadded(case_.getPadding().getGuard(), PyLeftPadded.Location.MATCH_CASE_GUARD, p));
        case_ = case_.withPattern((Py.MatchCase.Pattern)this.visitAndCast((Tree)case_.getPattern(), p));
        return case_;
    }

    public J visitSpecialParameter(Py.SpecialParameter ogParam, P p) {
        Py.SpecialParameter param = ogParam;
        param = param.withPrefix(this.visitSpace(param.getPrefix(), PySpace.Location.SPECIAL_PARAM_PREFIX, p));
        param = param.withMarkers(this.visitMarkers(param.getMarkers(), p));
        param = param.withTypeHint((Py.TypeHint)this.visitAndCast((Tree)param.getTypeHint(), p));
        return param;
    }

    public J visitTypeHintedExpression(Py.TypeHintedExpression ogExpr, P p) {
        Py.TypeHintedExpression expr = ogExpr;
        expr = expr.withPrefix(this.visitSpace(expr.getPrefix(), PySpace.Location.TYPE_HINTED_EXPRESSION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(expr = expr.withMarkers(this.visitMarkers(expr.getMarkers(), p)), p);
        if (!(temp instanceof Py.TypeHintedExpression)) {
            return temp;
        }
        expr = (Py.TypeHintedExpression)temp;
        expr = expr.withTypeHint((Py.TypeHint)this.visitAndCast((Tree)expr.getTypeHint(), p));
        expr = expr.withExpression((Expression)this.visitAndCast((Tree)expr.getExpression(), p));
        return expr;
    }

    public J visitTrailingElseWrapper(Py.TrailingElseWrapper ogWrapper, P p) {
        Py.TrailingElseWrapper wrapper = ogWrapper;
        wrapper = wrapper.withPrefix(this.visitSpace(wrapper.getPrefix(), PySpace.Location.TRAILING_ELSE_WRAPPER_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(wrapper = wrapper.withMarkers(this.visitMarkers(wrapper.getMarkers(), p)), p);
        if (!(temp instanceof Py.TrailingElseWrapper)) {
            return temp;
        }
        wrapper = (Py.TrailingElseWrapper)temp;
        wrapper = wrapper.getPadding().withElseBlock((JLeftPadded<J.Block>)this.visitLeftPadded(wrapper.getPadding().getElseBlock(), JLeftPadded.Location.LANGUAGE_EXTENSION, p));
        return wrapper;
    }

    public J visitSpecialArgument(Py.SpecialArgument ogArg, P p) {
        Py.SpecialArgument arg = ogArg;
        arg = arg.withPrefix(this.visitSpace(arg.getPrefix(), PySpace.Location.SPECIAL_ARG_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(arg = arg.withMarkers(this.visitMarkers(arg.getMarkers(), p)), p);
        if (!(temp instanceof Py.SpecialArgument)) {
            return temp;
        }
        arg = (Py.SpecialArgument)temp;
        arg = arg.withExpression((Expression)this.visitAndCast((Tree)arg.getExpression(), p));
        arg = arg.withType(this.visitType(arg.getType(), p));
        return arg;
    }

    public J visitNamedArgument(Py.NamedArgument ogArg, P p) {
        Py.NamedArgument arg = ogArg;
        arg = arg.withPrefix(this.visitSpace(arg.getPrefix(), PySpace.Location.NAMED_ARGUMENT_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(arg = arg.withMarkers(this.visitMarkers(arg.getMarkers(), p)), p);
        if (!(temp instanceof Py.NamedArgument)) {
            return temp;
        }
        arg = (Py.NamedArgument)temp;
        arg = arg.withName((J.Identifier)this.visitAndCast((Tree)arg.getName(), p));
        arg = arg.withType(this.visitType(arg.getType(), p));
        return arg;
    }
}

