/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionTypeUtil;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyBuiltinCache {
    public static final String BUILTIN_FILE = "__builtin__.py";
    public static final String BUILTIN_FILE_3K = "builtins.py";
    private static final String EXCEPTIONS_FILE = "exceptions.py";
    private static final PyBuiltinCache DUD_INSTANCE = new PyBuiltinCache(null, null);
    @NotNull
    private final Map<String, PyClassTypeImpl> myTypeCache = new HashMap<String, PyClassTypeImpl>();
    @Nullable
    private PyFile myBuiltinsFile;
    @Nullable
    private PyFile myExceptionsFile;
    private long myModStamp = -1L;

    public PyBuiltinCache() {
    }

    public PyBuiltinCache(@Nullable PyFile builtins, @Nullable PyFile exceptions) {
        this.myBuiltinsFile = builtins;
        this.myExceptionsFile = exceptions;
    }

    @NotNull
    public static PyBuiltinCache getInstance(@Nullable PsiElement reference) {
        block5: {
            if (reference != null) {
                PyBuiltinCache pyBuiltinCache;
                try {
                    Sdk sdk = PyBuiltinCache.findSdkForFile(reference.getContainingFile());
                    if (sdk == null) break block5;
                    pyBuiltinCache = PythonSdkPathCache.getInstance((Project)reference.getProject(), (Sdk)sdk).getBuiltins();
                }
                catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
                    // empty catch block
                }
                if (pyBuiltinCache == null) {
                    PyBuiltinCache.$$$reportNull$$$0(0);
                }
                return pyBuiltinCache;
            }
        }
        PyBuiltinCache pyBuiltinCache = DUD_INSTANCE;
        if (pyBuiltinCache == null) {
            PyBuiltinCache.$$$reportNull$$$0(1);
        }
        return pyBuiltinCache;
    }

    @Nullable
    public static Sdk findSdkForFile(PsiFileSystemItem psifile) {
        if (psifile == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement(psifile);
        if (module != null) {
            return PythonSdkUtil.findPythonSdk((Module)module);
        }
        return PyBuiltinCache.findSdkForNonModuleFile(psifile);
    }

    @Nullable
    public static Sdk findSdkForNonModuleFile(@NotNull PsiFileSystemItem psiFile) {
        ProjectRootManager projectRootManager;
        PsiFile contextFile;
        if (psiFile == null) {
            PyBuiltinCache.$$$reportNull$$$0(2);
        }
        VirtualFile vfile = psiFile instanceof PsiFile ? ((contextFile = FileContextUtil.getContextFile(psiFile)) != null ? contextFile.getOriginalFile().getVirtualFile() : null) : psiFile.getVirtualFile();
        Sdk sdk = null;
        if (vfile != null && (sdk = (projectRootManager = ProjectRootManager.getInstance((Project)psiFile.getProject())).getProjectSdk()) == null) {
            List<OrderEntry> orderEntries = projectRootManager.getFileIndex().getOrderEntriesForFile(vfile);
            for (OrderEntry orderEntry : orderEntries) {
                if (orderEntry instanceof JdkOrderEntry) {
                    sdk = ((JdkOrderEntry)orderEntry).getJdk();
                    continue;
                }
                if (!OrderEntryUtil.isModuleLibraryOrderEntry((OrderEntry)orderEntry)) continue;
                sdk = PythonSdkUtil.findPythonSdk((Module)orderEntry.getOwnerModule());
            }
        }
        return sdk;
    }

    @Nullable
    public static PyFile getBuiltinsForSdk(@NotNull Project project, @NotNull Sdk sdk) {
        if (project == null) {
            PyBuiltinCache.$$$reportNull$$$0(3);
        }
        if (sdk == null) {
            PyBuiltinCache.$$$reportNull$$$0(4);
        }
        return PyBuiltinCache.getSkeletonFile(project, sdk, PyBuiltinCache.getBuiltinsFileName(PythonRuntimeService.getInstance().getLanguageLevelForSdk(sdk)));
    }

    @NotNull
    public static String getBuiltinsFileName(@NotNull LanguageLevel level) {
        if (level == null) {
            PyBuiltinCache.$$$reportNull$$$0(5);
        }
        return level.isPython2() ? BUILTIN_FILE : BUILTIN_FILE_3K;
    }

    @Nullable
    public static PyFile getExceptionsForSdk(@NotNull Project project, @NotNull Sdk sdk) {
        if (project == null) {
            PyBuiltinCache.$$$reportNull$$$0(6);
        }
        if (sdk == null) {
            PyBuiltinCache.$$$reportNull$$$0(7);
        }
        return PyBuiltinCache.getSkeletonFile(project, sdk, EXCEPTIONS_FILE);
    }

    @Nullable
    private static PyFile getSkeletonFile(@NotNull Project project, @NotNull Sdk sdk, @NotNull String name) {
        SdkTypeId sdkType;
        if (project == null) {
            PyBuiltinCache.$$$reportNull$$$0(8);
        }
        if (sdk == null) {
            PyBuiltinCache.$$$reportNull$$$0(9);
        }
        if (name == null) {
            PyBuiltinCache.$$$reportNull$$$0(10);
        }
        if ("Python SDK".equals((sdkType = sdk.getSdkType()).getName())) {
            int index = name.indexOf(".");
            if (index != -1) {
                name = name.substring(0, index);
            }
            List results = PyResolveImportUtil.resolveQualifiedName((QualifiedName)QualifiedName.fromComponents(name), (PyQualifiedNameResolveContext)PyResolveImportUtil.fromSdk((Project)project, (Sdk)sdk));
            return PyUtil.as(ContainerUtil.getFirstItem(results), PyFile.class);
        }
        return null;
    }

    @Nullable
    public PyType createLiteralCollectionType(PySequenceExpression sequence, String name, @NotNull TypeEvalContext context) {
        PyClass cls;
        if (context == null) {
            PyBuiltinCache.$$$reportNull$$$0(11);
        }
        if ((cls = this.getClass(name)) != null) {
            PyTypedDictType typedDictType;
            if (sequence instanceof PyDictLiteralExpression && (typedDictType = PyCollectionTypeUtil.INSTANCE.getTypedDictTypeWithModifications(sequence, context)) != null) {
                return typedDictType;
            }
            List<PyType> literalCollectionType = PyCollectionTypeUtil.INSTANCE.getTypeByModifications(sequence, context);
            return new PyCollectionTypeImpl(cls, false, literalCollectionType);
        }
        return null;
    }

    @Nullable
    public PyFile getBuiltinsFile() {
        return this.myBuiltinsFile;
    }

    public boolean isValid() {
        return this.myBuiltinsFile != null && this.myBuiltinsFile.isValid();
    }

    @Nullable
    public PsiElement getByName(@NonNls String name) {
        PsiElement element;
        if (this.myBuiltinsFile != null && (element = this.myBuiltinsFile.getElementNamed(name)) != null) {
            return element;
        }
        if (this.myExceptionsFile != null) {
            return this.myExceptionsFile.getElementNamed(name);
        }
        return null;
    }

    @Nullable
    public PyClass getClass(@NonNls String name) {
        if (this.myBuiltinsFile != null) {
            return this.myBuiltinsFile.findTopLevelClass(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PyClassTypeImpl getObjectType(@NonNls String name) {
        PyClassTypeImpl val;
        Map<String, PyClassTypeImpl> map = this.myTypeCache;
        synchronized (map) {
            if (this.myBuiltinsFile != null && this.myBuiltinsFile.getModificationStamp() != this.myModStamp) {
                this.myTypeCache.clear();
                this.myModStamp = this.myBuiltinsFile.getModificationStamp();
            }
            val = this.myTypeCache.get(name);
        }
        if (val == null) {
            PyClass cls = this.getClass(name);
            if (cls != null) {
                val = new PyClassTypeImpl(cls, false);
                val.assertValid(name);
                Map<String, PyClassTypeImpl> map2 = this.myTypeCache;
                synchronized (map2) {
                    this.myTypeCache.put(name, val);
                }
            }
        } else {
            val.assertValid(name);
        }
        return val;
    }

    @Nullable
    public PyClassType getObjectType() {
        return this.getObjectType("object");
    }

    @Nullable
    public PyClassType getListType() {
        return this.getObjectType("list");
    }

    @Nullable
    public PyClassType getDictType() {
        return this.getObjectType("dict");
    }

    @Nullable
    public PyClassType getSetType() {
        return this.getObjectType("set");
    }

    @Nullable
    public PyClassType getTupleType() {
        return this.getObjectType("tuple");
    }

    @Nullable
    public PyClassType getIntType() {
        return this.getObjectType("int");
    }

    @Nullable
    public PyClassType getFloatType() {
        return this.getObjectType("float");
    }

    @Nullable
    public PyClassType getComplexType() {
        return this.getObjectType("complex");
    }

    @Nullable
    public PyClassType getStrType() {
        return this.getObjectType("str");
    }

    @Nullable
    public PyClassType getBytesType(LanguageLevel level) {
        if (level.isPy3K()) {
            return this.getObjectType("bytes");
        }
        return this.getObjectType("str");
    }

    @Nullable
    public PyClassType getUnicodeType(LanguageLevel level) {
        if (level.isPy3K()) {
            return this.getObjectType("str");
        }
        return this.getObjectType("unicode");
    }

    @Nullable
    public PyType getStringType(LanguageLevel level) {
        if (level.isPy3K()) {
            return this.getObjectType("str");
        }
        return this.getStrOrUnicodeType();
    }

    @Nullable
    public PyType getByteStringType(@NotNull LanguageLevel level) {
        if (level == null) {
            PyBuiltinCache.$$$reportNull$$$0(12);
        }
        if (level.isPy3K()) {
            return this.getObjectType("bytes");
        }
        return this.getStrOrUnicodeType();
    }

    @Nullable
    public PyType getStrOrUnicodeType() {
        return this.getStrOrUnicodeType(false);
    }

    @Nullable
    public PyType getStrOrUnicodeType(boolean definition) {
        PyClassLikeType str = this.getObjectType("str");
        PyClassLikeType unicode = this.getObjectType("unicode");
        if (str != null && str.isDefinition() ^ definition) {
            PyClassLikeType pyClassLikeType = str = definition ? (PyClassLikeType)str.toClass() : (PyClassLikeType)str.toInstance();
        }
        if (unicode != null && unicode.isDefinition() ^ definition) {
            unicode = definition ? (PyClassLikeType)unicode.toClass() : (PyClassLikeType)unicode.toInstance();
        }
        return PyUnionType.union(str, unicode);
    }

    @Nullable
    public PyClassType getBoolType() {
        return this.getObjectType("bool");
    }

    @Nullable
    public PyClassType getClassMethodType() {
        return this.getObjectType("classmethod");
    }

    @Nullable
    public PyClassType getStaticMethodType() {
        return this.getObjectType("staticmethod");
    }

    @Nullable
    public PyClassType getTypeType() {
        return this.getObjectType("type");
    }

    public boolean isBuiltin(@Nullable PsiElement target) {
        if (target == null) {
            return false;
        }
        PyPsiUtils.assertValid(target);
        if (!target.isValid()) {
            return false;
        }
        PsiFile the_file = target.getContainingFile();
        if (!(the_file instanceof PyFile)) {
            return false;
        }
        return the_file == this.myBuiltinsFile || the_file == this.myExceptionsFile;
    }

    public static boolean isInBuiltins(@NotNull PyExpression expression) {
        PsiElement resolved;
        PyBuiltinCache cache;
        if (expression == null) {
            PyBuiltinCache.$$$reportNull$$$0(13);
        }
        if (expression instanceof PyQualifiedExpression && ((PyQualifiedExpression)expression).isQualified()) {
            return false;
        }
        String name = expression.getName();
        PsiReference reference = expression.getReference();
        return reference != null && name != null && (cache = PyBuiltinCache.getInstance(expression)).getByName(name) != null && (resolved = reference.resolve()) != null && cache.isBuiltin(resolved);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyBuiltinCache";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyBuiltinCache";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findSdkForNonModuleFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinsForSdk";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinsFileName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionsForSdk";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSkeletonFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createLiteralCollectionType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getByteStringType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isInBuiltins";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

