/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ObjectUtilsRt;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.RefHashMap;
import com.intellij.util.containers.RefValueHashMapUtil;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

abstract class RefHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private final MyMap myMap;
    private final ReferenceQueue<K> myReferenceQueue;
    private final HardKey myHardKeyInstance;
    @NotNull
    private final HashingStrategy<? super K> myStrategy;
    private Set<Map.Entry<K, V>> entrySet;

    RefHashMap(int initialCapacity, float loadFactor, @NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            RefHashMap.$$$reportNull$$$0(0);
        }
        this.myReferenceQueue = new ReferenceQueue();
        this.myHardKeyInstance = new HardKey();
        this.myStrategy = strategy;
        this.myMap = new MyMap(initialCapacity, loadFactor);
    }

    private RefHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, HashingStrategy.canonical());
    }

    RefHashMap(int initialCapacity) {
        this(initialCapacity, 0.8f);
    }

    RefHashMap(@NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            RefHashMap.$$$reportNull$$$0(1);
        }
        this(4, 0.8f, hashingStrategy);
    }

    static <K> boolean keysEqual(K k1, K k2, @NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            RefHashMap.$$$reportNull$$$0(2);
        }
        return k1 == k2 || strategy.equals(k1, k2);
    }

    @NotNull
    protected abstract <T> Key<T> createKey(@NotNull T var1, @NotNull HashingStrategy<? super T> var2, @NotNull ReferenceQueue<? super T> var3);

    boolean processQueue() {
        Key wk;
        boolean processed = false;
        while ((wk = (Key)((Object)this.myReferenceQueue.poll())) != null) {
            this.removeKey(wk);
            processed = true;
        }
        return processed;
    }

    V removeKey(@NotNull Key<K> key) {
        if (key == null) {
            RefHashMap.$$$reportNull$$$0(3);
        }
        return (V)this.myMap.remove(key);
    }

    @NotNull
    Key<K> createKey(@NotNull K key) {
        if (key == null) {
            RefHashMap.$$$reportNull$$$0(4);
        }
        Key<? super K> key2 = this.createKey(key, this.myStrategy, this.myReferenceQueue);
        if (key2 == null) {
            RefHashMap.$$$reportNull$$$0(5);
        }
        return key2;
    }

    V putKey(@NotNull Key<K> weakKey, V value) {
        if (weakKey == null) {
            RefHashMap.$$$reportNull$$$0(6);
        }
        return (V)this.myMap.put(weakKey, value);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty() || this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(@NotNull Object key) {
        if (key == null) {
            RefHashMap.$$$reportNull$$$0(7);
        }
        this.myHardKeyInstance.set(key);
        try {
            boolean bl = this.myMap.containsKey(this.myHardKeyInstance);
            return bl;
        }
        finally {
            this.myHardKeyInstance.clear();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        throw RefValueHashMapUtil.pointlessContainsValue();
    }

    @Override
    public V get(@NotNull Object key) {
        if (key == null) {
            RefHashMap.$$$reportNull$$$0(8);
        }
        this.myHardKeyInstance.set(key);
        try {
            Object object = this.myMap.get(this.myHardKeyInstance);
            return (V)object;
        }
        finally {
            this.myHardKeyInstance.clear();
        }
    }

    @Override
    public V put(@NotNull K key, V value) {
        if (key == null) {
            RefHashMap.$$$reportNull$$$0(9);
        }
        this.processQueue();
        return this.putKey(this.createKey(key), value);
    }

    @Override
    public V remove(@NotNull Object key) {
        if (key == null) {
            RefHashMap.$$$reportNull$$$0(10);
        }
        this.processQueue();
        this.myHardKeyInstance.set(key);
        try {
            Object object = this.myMap.remove(this.myHardKeyInstance);
            return (V)object;
        }
        finally {
            this.myHardKeyInstance.clear();
        }
    }

    @Override
    public void clear() {
        this.processQueue();
        this.myMap.clear();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        if (es == null) {
            this.entrySet = es = new EntrySet(this, null);
        }
        EntrySet entrySet = es;
        if (entrySet == null) {
            RefHashMap.$$$reportNull$$$0(11);
        }
        return entrySet;
    }

    static /* synthetic */ MyMap access$500(RefHashMap x0) {
        return x0.myMap;
    }

    static /* synthetic */ HardKey access$800(RefHashMap x0) {
        return x0.myHardKeyInstance;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/RefHashMap";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weakKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/RefHashMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createKey";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "keysEqual";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeKey";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createKey";
                break;
            }
            case 5: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putKey";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class HardKey
    implements Key<K> {
        private K myObject;
        private int myHash;

        private HardKey() {
        }

        @Override
        public K get() {
            return this.myObject;
        }

        private void set(@NotNull K object) {
            if (object == null) {
                HardKey.$$$reportNull$$$0(0);
            }
            this.myObject = object;
            this.myHash = RefHashMap.this.myStrategy.hashCode(object);
        }

        private void clear() {
            this.myObject = null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Object t = this.myObject;
            Object u = ((Key)o).get();
            return RefHashMap.keysEqual(t, u, RefHashMap.this.myStrategy);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/containers/RefHashMap$HardKey", "set"));
        }
    }

    private class MyMap
    extends Object2ObjectOpenHashMap<Key<K>, V> {
        private MyMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor);
        }

        protected void rehash(int newN) {
            assert (newN != 0);
            Object[] key = this.key;
            Object[] value = this.value;
            int mask = newN - 1;
            Key[] newKey = new Key[newN + 1];
            Object[] newValue = new Object[newN + 1];
            int keysToProcess = this.size;
            for (int i = this.n; i >= 0 && keysToProcess > 0; --i) {
                Key k = (Key)key[i];
                if (k == null) continue;
                --keysToProcess;
                Object referent = k.get();
                if (referent == null) {
                    --this.size;
                    continue;
                }
                int pos = HashCommon.mix((int)k.hashCode()) & mask;
                if (newKey[pos] != null) {
                    while (newKey[pos = pos + 1 & mask] != null) {
                    }
                }
                newKey[pos] = k;
                newValue[pos] = value[i];
                ObjectUtilsRt.reachabilityFence(referent);
            }
            newValue[newN] = value[this.n];
            this.n = newN;
            this.mask = mask;
            this.maxFill = HashCommon.maxFill((int)this.n, (float)this.f);
            this.key = newKey;
            this.value = newValue;
        }
    }

    @FunctionalInterface
    static interface Key<T> {
        public T get();

        public int hashCode();

        public boolean equals(Object var1);
    }
}

