/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TokenSet {
    public static final TokenSet EMPTY = new TokenSet(Short.MAX_VALUE, 0, null);
    public static final TokenSet ANY = TokenSet.forAllMatching(IElementType.TRUE);
    public static final TokenSet WHITE_SPACE = TokenSet.doCreate(TokenType.WHITE_SPACE);
    private final short myShift;
    private final short myMax;
    private final long[] myWords;
    @Nullable
    private final IElementType.Predicate myOrCondition;
    private volatile IElementType[] myTypes;

    private TokenSet(short shift, short max, @Nullable IElementType.Predicate orCondition) {
        this.myShift = shift;
        this.myMax = max;
        int size = (max >> 6) + 1 - shift;
        this.myWords = size > 0 ? new long[size] : ArrayUtil.EMPTY_LONG_ARRAY;
        this.myOrCondition = orCondition;
    }

    private boolean get(int index) {
        int wordIndex = (index >> 6) - this.myShift;
        return wordIndex >= 0 && wordIndex < this.myWords.length && (this.myWords[wordIndex] & 1L << index) != 0L;
    }

    @Contract(value="null -> false")
    public boolean contains(@Nullable IElementType t) {
        if (t == null) {
            return false;
        }
        short i = t.getIndex();
        return 0 <= i && i <= this.myMax && this.get(i) || this.myOrCondition != null && this.myOrCondition.matches(t);
    }

    public IElementType @NotNull [] getTypes() {
        if (this.myOrCondition != null) {
            IElementType[] iElementTypeArray = IElementType.enumerate(this::contains);
            if (iElementTypeArray == null) {
                TokenSet.$$$reportNull$$$0(0);
            }
            return iElementTypeArray;
        }
        IElementType[] types = this.myTypes;
        if (types == null) {
            if (this.myWords.length == 0) {
                types = IElementType.EMPTY_ARRAY;
            } else {
                ArrayList<IElementType> list = new ArrayList<IElementType>();
                for (short i = (short)Math.max(1, this.myShift << 6); i <= this.myMax; i = (short)(i + 1)) {
                    IElementType type;
                    if (!this.get(i) || (type = IElementType.find(i)) == null) continue;
                    list.add(type);
                }
                types = list.toArray(IElementType.EMPTY_ARRAY);
            }
            this.myTypes = types;
        }
        if (types == null) {
            TokenSet.$$$reportNull$$$0(1);
        }
        return types;
    }

    public String toString() {
        return Arrays.toString(this.getTypes());
    }

    @NotNull
    public static TokenSet create(IElementType ... types) {
        if (types == null) {
            TokenSet.$$$reportNull$$$0(2);
        }
        if (types.length == 0) {
            TokenSet tokenSet = EMPTY;
            if (tokenSet == null) {
                TokenSet.$$$reportNull$$$0(3);
            }
            return tokenSet;
        }
        if (types.length == 1 && types[0] == TokenType.WHITE_SPACE) {
            TokenSet tokenSet = WHITE_SPACE;
            if (tokenSet == null) {
                TokenSet.$$$reportNull$$$0(4);
            }
            return tokenSet;
        }
        return TokenSet.doCreate(types);
    }

    @NotNull
    private static TokenSet doCreate(IElementType ... types) {
        if (types == null) {
            TokenSet.$$$reportNull$$$0(5);
        }
        short min = Short.MAX_VALUE;
        short max = 0;
        for (IElementType type : types) {
            if (type == null) continue;
            short index = type.getIndex();
            assert (index >= 0) : "Unregistered elements are not allowed here: " + ObjectUtils.objectInfo(type);
            if (min > index) {
                min = index;
            }
            if (max >= index) continue;
            max = index;
        }
        short shift = (short)(min >> 6);
        TokenSet set = new TokenSet(shift, max, null);
        for (IElementType type : types) {
            int wordIndex;
            if (type == null) continue;
            short index = type.getIndex();
            int n = wordIndex = (index >> 6) - shift;
            set.myWords[n] = set.myWords[n] | 1L << index;
        }
        TokenSet tokenSet = set;
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(6);
        }
        return tokenSet;
    }

    public static TokenSet forAllMatching(@NotNull IElementType.Predicate condition) {
        if (condition == null) {
            TokenSet.$$$reportNull$$$0(7);
        }
        return new TokenSet(Short.MAX_VALUE, 0, condition);
    }

    @NotNull
    public static TokenSet orSet(TokenSet ... sets) {
        if (sets == null) {
            TokenSet.$$$reportNull$$$0(8);
        }
        if (sets.length == 0) {
            TokenSet tokenSet = EMPTY;
            if (tokenSet == null) {
                TokenSet.$$$reportNull$$$0(9);
            }
            return tokenSet;
        }
        ArrayList<IElementType.Predicate> orConditions = new ArrayList<IElementType.Predicate>();
        ContainerUtil.addIfNotNull(orConditions, sets[0].myOrCondition);
        short shift = sets[0].myShift;
        short max = sets[0].myMax;
        for (int i = 1; i < sets.length; ++i) {
            if (shift > sets[i].myShift) {
                shift = sets[i].myShift;
            }
            if (max < sets[i].myMax) {
                max = sets[i].myMax;
            }
            ContainerUtil.addIfNotNull(orConditions, sets[i].myOrCondition);
        }
        OrPredicate disjunction = orConditions.isEmpty() ? null : (orConditions.size() == 1 ? (IElementType.Predicate)orConditions.get(0) : new OrPredicate(orConditions));
        TokenSet newSet = new TokenSet(shift, max, disjunction);
        for (TokenSet set : sets) {
            int shiftDiff = set.myShift - newSet.myShift;
            for (int i = 0; i < set.myWords.length; ++i) {
                int n = i + shiftDiff;
                newSet.myWords[n] = newSet.myWords[n] | set.myWords[i];
            }
        }
        TokenSet tokenSet = newSet;
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(10);
        }
        return tokenSet;
    }

    @NotNull
    public static TokenSet andSet(@NotNull TokenSet a, @NotNull TokenSet b) {
        if (a == null) {
            TokenSet.$$$reportNull$$$0(11);
        }
        if (b == null) {
            TokenSet.$$$reportNull$$$0(12);
        }
        ArrayList orConditions = new ArrayList();
        ContainerUtil.addIfNotNull(orConditions, a.myOrCondition);
        ContainerUtil.addIfNotNull(orConditions, b.myOrCondition);
        IElementType.Predicate conjunction = orConditions.isEmpty() ? null : (orConditions.size() == 1 ? (IElementType.Predicate)orConditions.get(0) : t -> Objects.requireNonNull(a.myOrCondition).matches(t) && Objects.requireNonNull(b.myOrCondition).matches(t));
        TokenSet newSet = new TokenSet((short)Math.min(a.myShift, b.myShift), (short)Math.max(a.myMax, b.myMax), conjunction);
        for (int i = 0; i < newSet.myWords.length; ++i) {
            int ai = newSet.myShift - a.myShift + i;
            int bi = newSet.myShift - b.myShift + i;
            newSet.myWords[i] = (0 <= ai && ai < a.myWords.length ? a.myWords[ai] : 0L) & (0 <= bi && bi < b.myWords.length ? b.myWords[bi] : 0L);
        }
        TokenSet tokenSet = newSet;
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(13);
        }
        return tokenSet;
    }

    @NotNull
    public static TokenSet andNot(@NotNull TokenSet a, @NotNull TokenSet b) {
        if (a == null) {
            TokenSet.$$$reportNull$$$0(14);
        }
        if (b == null) {
            TokenSet.$$$reportNull$$$0(15);
        }
        IElementType.Predicate difference = a.myOrCondition == null ? null : e -> !b.contains(e) && a.myOrCondition.matches(e);
        TokenSet newSet = new TokenSet((short)Math.min(a.myShift, b.myShift), (short)Math.max(a.myMax, b.myMax), difference);
        for (int i = 0; i < newSet.myWords.length; ++i) {
            int ai = newSet.myShift - a.myShift + i;
            int bi = newSet.myShift - b.myShift + i;
            newSet.myWords[i] = (0 <= ai && ai < a.myWords.length ? a.myWords[ai] : 0L) & ((0 <= bi && bi < b.myWords.length ? b.myWords[bi] : 0L) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        TokenSet tokenSet = newSet;
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(16);
        }
        return tokenSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/tree/TokenSet";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sets";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/tree/TokenSet";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreate";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "orSet";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "andSet";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "andNot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doCreate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forAllMatching";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "orSet";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "andSet";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "andNot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OrPredicate
    implements IElementType.Predicate {
        private final IElementType.Predicate[] myComponents;

        OrPredicate(List<IElementType.Predicate> components) {
            this.myComponents = (IElementType.Predicate[])components.stream().flatMap(p -> p instanceof OrPredicate ? Arrays.stream(((OrPredicate)p).myComponents) : Stream.of(p)).distinct().toArray(IElementType.Predicate[]::new);
        }

        @Override
        public boolean matches(@NotNull IElementType t) {
            if (t == null) {
                OrPredicate.$$$reportNull$$$0(0);
            }
            for (IElementType.Predicate component : this.myComponents) {
                if (!component.matches(t)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/psi/tree/TokenSet$OrPredicate", "matches"));
        }
    }
}

