/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.InputStream;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openrewrite.Checksum;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.BuildTool;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.maven.utilities.MavenWrapper;
import org.openrewrite.properties.PropertiesIsoVisitor;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.search.FindProperties;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.text.PlainText;

public class UpdateMavenWrapper
extends ScanningRecipe<MavenWrapperState> {
    private static final String DISTRIBUTION_URL_KEY = "distributionUrl";
    private static final String DISTRIBUTION_SHA_256_SUM_KEY = "distributionSha256Sum";
    private static final String WRAPPER_URL_KEY = "wrapperUrl";
    private static final String WRAPPER_SHA_256_SUM_KEY = "wrapperSha256Sum";
    @Option(displayName="New wrapper version", description="An exact version number or node-style semver selector used to select the wrapper version number.", example="3.x", required=false)
    @Nullable
    private final String wrapperVersion;
    @Option(displayName="Wrapper Distribution type", description="The distribution of the Maven wrapper to use.\n\n* \"bin\" uses a `maven-wrapper.jar` compiled binary.\n* \"only-script\" uses a lite version of `mvnw`/`mvnw.cmd` using wget/curl or powershell. (required wrapper 3.2.0 or newer)\n* \"script\" downloads `maven-wrapper.jar` or `MavenWrapperDownloader.java` to then download a full distribution.\n* \"source\" uses `MavenWrapperDownloader.java` source file.\n\nDefaults to \"bin\".", valid={"bin", "only-script", "script", "source"}, required=false)
    @Nullable
    private final String wrapperDistribution;
    @Option(displayName="New distribution version", description="An exact version number or node-style semver selector used to select the Maven version number.", example="3.x", required=false)
    @Nullable
    private final String distributionVersion;
    @Option(displayName="Repository URL", description="The URL of the repository to download the Maven wrapper and distribution from. Supports repositories with a Maven layout. Defaults to `https://repo.maven.apache.org/maven2`.", example="https://repo.maven.apache.org/maven2", required=false)
    @Nullable
    private final String repositoryUrl;
    @Option(displayName="Add if missing", description="Add a Maven wrapper, if it's missing. Defaults to `true`.", required=false)
    @Nullable
    private final Boolean addIfMissing;
    @Nullable
    private transient MavenWrapper mavenWrapper;

    public String getDisplayName() {
        return "Update Maven wrapper";
    }

    public String getDescription() {
        return "Update the version of Maven used in an existing Maven wrapper.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.wrapperVersion != null) {
            validated = validated.and(Semver.validate((String)this.wrapperVersion, null));
        }
        if (this.distributionVersion != null) {
            validated = validated.and(Semver.validate((String)this.distributionVersion, null));
        }
        return validated;
    }

    private MavenWrapper getMavenWrapper(ExecutionContext ctx) {
        if (this.mavenWrapper == null) {
            this.mavenWrapper = MavenWrapper.create(this.wrapperVersion, this.wrapperDistribution, this.distributionVersion, this.repositoryUrl, ctx);
        }
        return this.mavenWrapper;
    }

    public MavenWrapperState getInitialValue(ExecutionContext ctx) {
        return new MavenWrapperState();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final MavenWrapperState acc) {
        return Preconditions.or((TreeVisitor[])new TreeVisitor[]{new PropertiesVisitor<ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                if (!super.isAcceptable(sourceFile, (Object)ctx)) {
                    return false;
                }
                if (PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)MavenWrapper.WRAPPER_PROPERTIES_LOCATION)) {
                    acc.addMavenWrapperProperties = false;
                } else if (!PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/.mvn/wrapper/maven-wrapper.properties")) {
                    return false;
                }
                Optional maybeBuildTool = sourceFile.getMarkers().findFirst(BuildTool.class);
                if (!maybeBuildTool.isPresent()) {
                    return false;
                }
                BuildTool buildTool = (BuildTool)maybeBuildTool.get();
                if (buildTool.getType() != BuildTool.Type.Maven) {
                    return false;
                }
                MavenWrapper mavenWrapper = UpdateMavenWrapper.this.getMavenWrapper(ctx);
                VersionComparator versionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)(StringUtils.isBlank((String)UpdateMavenWrapper.this.distributionVersion) ? "latest.release" : UpdateMavenWrapper.this.distributionVersion), null).getValue());
                int compare = versionComparator.compare(null, buildTool.getVersion(), mavenWrapper.getDistributionVersion());
                if (compare < 0) {
                    acc.needsWrapperUpdate = true;
                    acc.updatedMarker = buildTool.withVersion(mavenWrapper.getDistributionVersion());
                    return true;
                }
                return compare == 0;
            }

            public Properties visitFile(Properties.File file, ExecutionContext executionContext) {
                Properties p = super.visitFile(file, (Object)executionContext);
                if (FindProperties.find((Properties)p, (String)UpdateMavenWrapper.DISTRIBUTION_SHA_256_SUM_KEY, null).isEmpty() || FindProperties.find((Properties)p, (String)UpdateMavenWrapper.WRAPPER_SHA_256_SUM_KEY, null).isEmpty()) {
                    acc.needsWrapperUpdate = true;
                }
                return p;
            }

            public Properties visitEntry(Properties.Entry entry, ExecutionContext ctx) {
                MavenWrapper mavenWrapper = UpdateMavenWrapper.this.getMavenWrapper(ctx);
                if (UpdateMavenWrapper.DISTRIBUTION_URL_KEY.equals(entry.getKey())) {
                    String currentDistributionUrl = entry.getValue().getText();
                    if (!mavenWrapper.getPropertiesFormattedDistributionUrl().equals(currentDistributionUrl)) {
                        acc.needsWrapperUpdate = true;
                    }
                } else if (UpdateMavenWrapper.WRAPPER_URL_KEY.equals(entry.getKey())) {
                    String currentWrapperUrl = entry.getValue().getText();
                    if (!mavenWrapper.getPropertiesFormattedWrapperUrl().equals(currentWrapperUrl)) {
                        acc.needsWrapperUpdate = true;
                    }
                }
                return entry;
            }
        }, new TreeVisitor<Tree, ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                if (!super.isAcceptable(sourceFile, (Object)ctx)) {
                    return false;
                }
                MavenWrapper mavenWrapper = UpdateMavenWrapper.this.getMavenWrapper(ctx);
                if (sourceFile instanceof Quark || sourceFile instanceof Remote) {
                    if (PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)MavenWrapper.WRAPPER_JAR_LOCATION)) {
                        acc.addMavenWrapperJar = false;
                        if (mavenWrapper.getWrapperDistributionType() != MavenWrapper.DistributionType.Bin) {
                            acc.needsWrapperUpdate = true;
                        }
                        return true;
                    }
                    if (PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)MavenWrapper.WRAPPER_DOWNLOADER_LOCATION)) {
                        acc.addMavenWrapperDownloader = false;
                        if (mavenWrapper.getWrapperDistributionType() != MavenWrapper.DistributionType.Source) {
                            acc.needsWrapperUpdate = true;
                        }
                        return true;
                    }
                }
                if (sourceFile instanceof PlainText) {
                    if (PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)MavenWrapper.WRAPPER_BATCH_LOCATION)) {
                        acc.addMavenBatchScript = false;
                        return true;
                    }
                    if (PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)MavenWrapper.WRAPPER_SCRIPT_LOCATION)) {
                        acc.addMavenShellScript = false;
                        return true;
                    }
                }
                return false;
            }
        }});
    }

    public Collection<SourceFile> generate(MavenWrapperState acc, ExecutionContext ctx) {
        if (Boolean.FALSE.equals(this.addIfMissing)) {
            return Collections.emptyList();
        }
        MavenWrapper mavenWrapper = this.getMavenWrapper(ctx);
        if (mavenWrapper.getWrapperDistributionType() == MavenWrapper.DistributionType.Bin ? !acc.addMavenWrapperJar && !acc.addMavenWrapperProperties && !acc.addMavenBatchScript && !acc.addMavenShellScript : (mavenWrapper.getWrapperDistributionType() == MavenWrapper.DistributionType.OnlyScript ? !acc.addMavenWrapperProperties && !acc.addMavenBatchScript && !acc.addMavenShellScript : !acc.addMavenWrapperDownloader && !acc.addMavenWrapperProperties && !acc.addMavenBatchScript && !acc.addMavenShellScript)) {
            return Collections.emptyList();
        }
        ArrayList<SourceFile> mavenWrapperFiles = new ArrayList<SourceFile>();
        ZonedDateTime now = ZonedDateTime.now();
        if (acc.addMavenWrapperProperties) {
            String mavenWrapperPropertiesText = "# Licensed to the Apache Software Foundation (ASF) under one\n# or more contributor license agreements.  See the NOTICE file\n# distributed with this work for additional information\n# regarding copyright ownership.  The ASF licenses this file\n# to you under the Apache License, Version 2.0 (the\n# \"License\"); you may not use this file except in compliance\n# with the License.  You may obtain a copy of the License at\n# \n#   http://www.apache.org/licenses/LICENSE-2.0\n# \n# Unless required by applicable law or agreed to in writing,\n# software distributed under the License is distributed on an\n# \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n# KIND, either express or implied.  See the License for the\n# specific language governing permissions and limitations\n# under the License.\ndistributionUrl=" + mavenWrapper.getPropertiesFormattedDistributionUrl() + "\n" + DISTRIBUTION_SHA_256_SUM_KEY + "=" + mavenWrapper.getDistributionChecksum().getHexValue();
            if (mavenWrapper.getWrapperDistributionType() != MavenWrapper.DistributionType.OnlyScript) {
                mavenWrapperPropertiesText = mavenWrapperPropertiesText + "\nwrapperUrl=" + mavenWrapper.getPropertiesFormattedWrapperUrl() + "\n" + WRAPPER_SHA_256_SUM_KEY + "=" + mavenWrapper.getWrapperChecksum().getHexValue();
            }
            Properties.File mavenWrapperProperties = (Properties.File)((SourceFile)new PropertiesParser().parse(new String[]{mavenWrapperPropertiesText}).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not parse as properties"))).withSourcePath(MavenWrapper.WRAPPER_PROPERTIES_LOCATION);
            mavenWrapperFiles.add((SourceFile)mavenWrapperProperties);
        }
        FileAttributes wrapperScriptAttributes = new FileAttributes(now, now, now, true, true, true, 1L);
        if (acc.addMavenShellScript) {
            String mvnwText = this.unixScript(mavenWrapper, ctx);
            PlainText mvnw = PlainText.builder().text(mvnwText).sourcePath(MavenWrapper.WRAPPER_SCRIPT_LOCATION).fileAttributes(wrapperScriptAttributes).build();
            mavenWrapperFiles.add((SourceFile)mvnw);
        }
        if (acc.addMavenBatchScript) {
            String mvnwCmdText = this.batchScript(mavenWrapper, ctx);
            PlainText mvnwCmd = PlainText.builder().text(mvnwCmdText).sourcePath(MavenWrapper.WRAPPER_BATCH_LOCATION).fileAttributes(wrapperScriptAttributes).build();
            mavenWrapperFiles.add((SourceFile)mvnwCmd);
        }
        if (mavenWrapper.getWrapperDistributionType() == MavenWrapper.DistributionType.Bin && acc.addMavenWrapperJar) {
            mavenWrapperFiles.add((SourceFile)mavenWrapper.wrapperJar());
        } else if (mavenWrapper.getWrapperDistributionType() == MavenWrapper.DistributionType.Source && acc.addMavenWrapperDownloader) {
            mavenWrapperFiles.add((SourceFile)mavenWrapper.wrapperDownloader());
        }
        return mavenWrapperFiles;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final MavenWrapperState acc) {
        if (!acc.needsWrapperUpdate) {
            return TreeVisitor.noop();
        }
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile sourceFile = (SourceFile)tree;
                if (acc.updatedMarker != null) {
                    sourceFile = sourceFile.getMarkers().findFirst(BuildTool.class).map(buildTool -> (SourceFile)tree.withMarkers(tree.getMarkers().setByType((Marker)acc2.updatedMarker))).orElse(sourceFile);
                }
                MavenWrapper mavenWrapper = UpdateMavenWrapper.this.getMavenWrapper(ctx);
                if (sourceFile instanceof PlainText && PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/mvnw")) {
                    PlainText mvnw;
                    String mvnwText = UpdateMavenWrapper.this.unixScript(mavenWrapper, ctx);
                    if (!mvnwText.equals((mvnw = (PlainText)UpdateMavenWrapper.setExecutable(sourceFile)).getText())) {
                        mvnw = mvnw.withText(mvnwText);
                    }
                    return mvnw;
                }
                if (sourceFile instanceof PlainText && PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/mvnw.cmd")) {
                    PlainText mvnwCmd;
                    String mvnwCmdText = UpdateMavenWrapper.this.batchScript(mavenWrapper, ctx);
                    if (!mvnwCmdText.equals((mvnwCmd = (PlainText)UpdateMavenWrapper.setExecutable(sourceFile)).getText())) {
                        mvnwCmd = mvnwCmd.withText(mvnwCmdText);
                    }
                    return mvnwCmd;
                }
                if (sourceFile instanceof Properties.File && PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/.mvn/wrapper/maven-wrapper.properties")) {
                    return new WrapperPropertiesVisitor(mavenWrapper).visitNonNull((Tree)sourceFile, ctx);
                }
                if (mavenWrapper.getWrapperDistributionType() == MavenWrapper.DistributionType.Bin) {
                    if ((sourceFile instanceof Quark || sourceFile instanceof Remote) && PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/.mvn/wrapper/maven-wrapper.jar")) {
                        return mavenWrapper.wrapperJar().withId(sourceFile.getId()).withMarkers(sourceFile.getMarkers());
                    }
                    if (PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/.mvn/wrapper/MavenWrapperDownloader.java")) {
                        return null;
                    }
                } else if (mavenWrapper.getWrapperDistributionType() == MavenWrapper.DistributionType.Source) {
                    if ((sourceFile instanceof Quark || sourceFile instanceof Remote) && PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/.mvn/wrapper/MavenWrapperDownloader.java")) {
                        return mavenWrapper.wrapperDownloader().withId(sourceFile.getId()).withMarkers(sourceFile.getMarkers());
                    }
                    if (PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/.mvn/wrapper/maven-wrapper.jar")) {
                        return null;
                    }
                } else if (PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/.mvn/wrapper/maven-wrapper.jar") || PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/.mvn/wrapper/MavenWrapperDownloader.java")) {
                    return null;
                }
                return sourceFile;
            }
        };
    }

    private static <T extends SourceFile> T setExecutable(T sourceFile) {
        FileAttributes attributes = sourceFile.getFileAttributes();
        if (attributes == null) {
            ZonedDateTime now = ZonedDateTime.now();
            return (T)sourceFile.withFileAttributes(new FileAttributes(now, now, now, true, true, true, 1L));
        }
        if (!attributes.isExecutable()) {
            return (T)sourceFile.withFileAttributes(attributes.withExecutable(true));
        }
        return sourceFile;
    }

    private String unixScript(MavenWrapper mavenWrapper, ExecutionContext ctx) {
        return StringUtils.readFully((InputStream)mavenWrapper.mvnw().getInputStream(ctx));
    }

    private String batchScript(MavenWrapper mavenWrapper, ExecutionContext ctx) {
        return StringUtils.readFully((InputStream)mavenWrapper.mvnwCmd().getInputStream(ctx));
    }

    public UpdateMavenWrapper(@Nullable String wrapperVersion, @Nullable String wrapperDistribution, @Nullable String distributionVersion, @Nullable String repositoryUrl, @Nullable Boolean addIfMissing) {
        this.wrapperVersion = wrapperVersion;
        this.wrapperDistribution = wrapperDistribution;
        this.distributionVersion = distributionVersion;
        this.repositoryUrl = repositoryUrl;
        this.addIfMissing = addIfMissing;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateMavenWrapper)) {
            return false;
        }
        UpdateMavenWrapper other = (UpdateMavenWrapper)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$addIfMissing = this.getAddIfMissing();
        Boolean other$addIfMissing = other.getAddIfMissing();
        if (this$addIfMissing == null ? other$addIfMissing != null : !((Object)this$addIfMissing).equals(other$addIfMissing)) {
            return false;
        }
        String this$wrapperVersion = this.getWrapperVersion();
        String other$wrapperVersion = other.getWrapperVersion();
        if (this$wrapperVersion == null ? other$wrapperVersion != null : !this$wrapperVersion.equals(other$wrapperVersion)) {
            return false;
        }
        String this$wrapperDistribution = this.getWrapperDistribution();
        String other$wrapperDistribution = other.getWrapperDistribution();
        if (this$wrapperDistribution == null ? other$wrapperDistribution != null : !this$wrapperDistribution.equals(other$wrapperDistribution)) {
            return false;
        }
        String this$distributionVersion = this.getDistributionVersion();
        String other$distributionVersion = other.getDistributionVersion();
        if (this$distributionVersion == null ? other$distributionVersion != null : !this$distributionVersion.equals(other$distributionVersion)) {
            return false;
        }
        String this$repositoryUrl = this.getRepositoryUrl();
        String other$repositoryUrl = other.getRepositoryUrl();
        return !(this$repositoryUrl == null ? other$repositoryUrl != null : !this$repositoryUrl.equals(other$repositoryUrl));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpdateMavenWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $addIfMissing = this.getAddIfMissing();
        result = result * 59 + ($addIfMissing == null ? 43 : ((Object)$addIfMissing).hashCode());
        String $wrapperVersion = this.getWrapperVersion();
        result = result * 59 + ($wrapperVersion == null ? 43 : $wrapperVersion.hashCode());
        String $wrapperDistribution = this.getWrapperDistribution();
        result = result * 59 + ($wrapperDistribution == null ? 43 : $wrapperDistribution.hashCode());
        String $distributionVersion = this.getDistributionVersion();
        result = result * 59 + ($distributionVersion == null ? 43 : $distributionVersion.hashCode());
        String $repositoryUrl = this.getRepositoryUrl();
        result = result * 59 + ($repositoryUrl == null ? 43 : $repositoryUrl.hashCode());
        return result;
    }

    @Nullable
    public String getWrapperVersion() {
        return this.wrapperVersion;
    }

    @Nullable
    public String getWrapperDistribution() {
        return this.wrapperDistribution;
    }

    @Nullable
    public String getDistributionVersion() {
        return this.distributionVersion;
    }

    @Nullable
    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    @Nullable
    public Boolean getAddIfMissing() {
        return this.addIfMissing;
    }

    static class MavenWrapperState {
        boolean needsWrapperUpdate = false;
        @Nullable
        BuildTool updatedMarker;
        boolean addMavenWrapperProperties = true;
        boolean addMavenWrapperDownloader = true;
        boolean addMavenWrapperJar = true;
        boolean addMavenShellScript = true;
        boolean addMavenBatchScript = true;

        MavenWrapperState() {
        }
    }

    private static class WrapperPropertiesVisitor
    extends PropertiesIsoVisitor<ExecutionContext> {
        MavenWrapper mavenWrapper;

        public Properties.File visitFile(Properties.File file, ExecutionContext executionContext) {
            Properties.File p = super.visitFile(file, (Object)executionContext);
            Checksum mavenDistributionChecksum = this.mavenWrapper.getDistributionChecksum();
            if (FindProperties.find((Properties)p, (String)UpdateMavenWrapper.DISTRIBUTION_SHA_256_SUM_KEY, null).isEmpty() && mavenDistributionChecksum != null) {
                Properties.Value propertyValue = new Properties.Value(Tree.randomId(), "", Markers.EMPTY, mavenDistributionChecksum.getHexValue());
                Properties.Entry entry = new Properties.Entry(Tree.randomId(), "\n", Markers.EMPTY, UpdateMavenWrapper.DISTRIBUTION_SHA_256_SUM_KEY, "", Properties.Entry.Delimiter.EQUALS, propertyValue);
                p = p.withContent(ListUtils.concat((List)p.getContent(), (Object)entry));
            }
            if (this.mavenWrapper.getWrapperDistributionType() != MavenWrapper.DistributionType.OnlyScript) {
                Checksum wrapperJarChecksum = this.mavenWrapper.getWrapperChecksum();
                if (FindProperties.find((Properties)p, (String)UpdateMavenWrapper.WRAPPER_SHA_256_SUM_KEY, null).isEmpty() && wrapperJarChecksum != null) {
                    Properties.Value propertyValue = new Properties.Value(Tree.randomId(), "", Markers.EMPTY, wrapperJarChecksum.getHexValue());
                    Properties.Entry entry = new Properties.Entry(Tree.randomId(), "\n", Markers.EMPTY, UpdateMavenWrapper.WRAPPER_SHA_256_SUM_KEY, "", Properties.Entry.Delimiter.EQUALS, propertyValue);
                    p = p.withContent(ListUtils.concat((List)p.getContent(), (Object)entry));
                }
            }
            return p;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Properties.Entry visitEntry(Properties.Entry entry, ExecutionContext executionContext) {
            if (UpdateMavenWrapper.DISTRIBUTION_URL_KEY.equals(entry.getKey())) {
                Properties.Value value = entry.getValue();
                if (this.mavenWrapper.getPropertiesFormattedDistributionUrl().equals(value.getText())) return entry;
                return entry.withValue(value.withText(this.mavenWrapper.getPropertiesFormattedDistributionUrl()));
            }
            if (UpdateMavenWrapper.DISTRIBUTION_SHA_256_SUM_KEY.equals(entry.getKey())) {
                Properties.Value value = entry.getValue();
                Checksum mavenDistributionChecksum = this.mavenWrapper.getDistributionChecksum();
                if (mavenDistributionChecksum == null || mavenDistributionChecksum.getHexValue().equals(value.getText())) return entry;
                return entry.withValue(value.withText(mavenDistributionChecksum.getHexValue()));
            }
            if (UpdateMavenWrapper.WRAPPER_URL_KEY.equals(entry.getKey())) {
                if (this.mavenWrapper.getWrapperDistributionType() == MavenWrapper.DistributionType.OnlyScript) return null;
                Properties.Value value = entry.getValue();
                if (this.mavenWrapper.getPropertiesFormattedWrapperUrl().equals(value.getText())) return entry;
                return entry.withValue(value.withText(this.mavenWrapper.getPropertiesFormattedWrapperUrl()));
            }
            if (!UpdateMavenWrapper.WRAPPER_SHA_256_SUM_KEY.equals(entry.getKey())) return entry;
            if (this.mavenWrapper.getWrapperDistributionType() == MavenWrapper.DistributionType.OnlyScript) return null;
            Properties.Value value = entry.getValue();
            Checksum wrapperJarChecksum = this.mavenWrapper.getWrapperChecksum();
            if (wrapperJarChecksum == null || wrapperJarChecksum.getHexValue().equals(value.getText())) return entry;
            return entry.withValue(value.withText(wrapperJarChecksum.getHexValue()));
        }

        public WrapperPropertiesVisitor(MavenWrapper mavenWrapper) {
            this.mavenWrapper = mavenWrapper;
        }
    }
}

