/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.objdetect;

import org.opencv.core.Mat;
import org.opencv.core.Size;

public class FaceDetectorYN {
    protected final long nativeObj;

    protected FaceDetectorYN(long addr) {
        this.nativeObj = addr;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static FaceDetectorYN __fromPtr__(long addr) {
        return new FaceDetectorYN(addr);
    }

    public void setInputSize(Size input_size) {
        FaceDetectorYN.setInputSize_0(this.nativeObj, input_size.width, input_size.height);
    }

    public Size getInputSize() {
        return new Size(FaceDetectorYN.getInputSize_0(this.nativeObj));
    }

    public void setScoreThreshold(float score_threshold) {
        FaceDetectorYN.setScoreThreshold_0(this.nativeObj, score_threshold);
    }

    public float getScoreThreshold() {
        return FaceDetectorYN.getScoreThreshold_0(this.nativeObj);
    }

    public void setNMSThreshold(float nms_threshold) {
        FaceDetectorYN.setNMSThreshold_0(this.nativeObj, nms_threshold);
    }

    public float getNMSThreshold() {
        return FaceDetectorYN.getNMSThreshold_0(this.nativeObj);
    }

    public void setTopK(int top_k) {
        FaceDetectorYN.setTopK_0(this.nativeObj, top_k);
    }

    public int getTopK() {
        return FaceDetectorYN.getTopK_0(this.nativeObj);
    }

    public int detect(Mat image, Mat faces) {
        return FaceDetectorYN.detect_0(this.nativeObj, image.nativeObj, faces.nativeObj);
    }

    public static FaceDetectorYN create(String model, String config, Size input_size, float score_threshold, float nms_threshold, int top_k, int backend_id, int target_id) {
        return FaceDetectorYN.__fromPtr__(FaceDetectorYN.create_0(model, config, input_size.width, input_size.height, score_threshold, nms_threshold, top_k, backend_id, target_id));
    }

    public static FaceDetectorYN create(String model, String config, Size input_size, float score_threshold, float nms_threshold, int top_k, int backend_id) {
        return FaceDetectorYN.__fromPtr__(FaceDetectorYN.create_1(model, config, input_size.width, input_size.height, score_threshold, nms_threshold, top_k, backend_id));
    }

    public static FaceDetectorYN create(String model, String config, Size input_size, float score_threshold, float nms_threshold, int top_k) {
        return FaceDetectorYN.__fromPtr__(FaceDetectorYN.create_2(model, config, input_size.width, input_size.height, score_threshold, nms_threshold, top_k));
    }

    public static FaceDetectorYN create(String model, String config, Size input_size, float score_threshold, float nms_threshold) {
        return FaceDetectorYN.__fromPtr__(FaceDetectorYN.create_3(model, config, input_size.width, input_size.height, score_threshold, nms_threshold));
    }

    public static FaceDetectorYN create(String model, String config, Size input_size, float score_threshold) {
        return FaceDetectorYN.__fromPtr__(FaceDetectorYN.create_4(model, config, input_size.width, input_size.height, score_threshold));
    }

    public static FaceDetectorYN create(String model, String config, Size input_size) {
        return FaceDetectorYN.__fromPtr__(FaceDetectorYN.create_5(model, config, input_size.width, input_size.height));
    }

    protected void finalize() throws Throwable {
        FaceDetectorYN.delete(this.nativeObj);
    }

    private static native void setInputSize_0(long var0, double var2, double var4);

    private static native double[] getInputSize_0(long var0);

    private static native void setScoreThreshold_0(long var0, float var2);

    private static native float getScoreThreshold_0(long var0);

    private static native void setNMSThreshold_0(long var0, float var2);

    private static native float getNMSThreshold_0(long var0);

    private static native void setTopK_0(long var0, int var2);

    private static native int getTopK_0(long var0);

    private static native int detect_0(long var0, long var2, long var4);

    private static native long create_0(String var0, String var1, double var2, double var4, float var6, float var7, int var8, int var9, int var10);

    private static native long create_1(String var0, String var1, double var2, double var4, float var6, float var7, int var8, int var9);

    private static native long create_2(String var0, String var1, double var2, double var4, float var6, float var7, int var8);

    private static native long create_3(String var0, String var1, double var2, double var4, float var6, float var7);

    private static native long create_4(String var0, String var1, double var2, double var4, float var6);

    private static native long create_5(String var0, String var1, double var2, double var4);

    private static native void delete(long var0);
}

