/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.reader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.dom4j.DocumentException;
import org.ofdrw.core.annotation.Annotations;
import org.ofdrw.core.annotation.pageannot.AnnPage;
import org.ofdrw.core.annotation.pageannot.PageAnnot;
import org.ofdrw.core.basicStructure.doc.Document;
import org.ofdrw.core.basicStructure.ofd.DocBody;
import org.ofdrw.core.basicStructure.pageObj.CT_TemplatePage;
import org.ofdrw.core.basicStructure.pageObj.Page;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.signatures.Signature;
import org.ofdrw.core.signatures.sig.SignedInfo;
import org.ofdrw.gm.ses.parse.SESVersion;
import org.ofdrw.gm.ses.parse.SESVersionHolder;
import org.ofdrw.gm.ses.parse.VersionParser;
import org.ofdrw.gm.ses.v1.SES_Signature;
import org.ofdrw.gm.ses.v4.TBS_Sign;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.ResourceManage;
import org.ofdrw.reader.model.AnnotionEntity;
import org.ofdrw.reader.model.OFDDocumentVo;
import org.ofdrw.reader.model.OfdPageVo;
import org.ofdrw.reader.model.StampAnnotVo;

@Deprecated
public class DLOFDReader
extends OFDReader {
    private ST_Loc docRoot;
    private Document document;
    private ST_Box documentBox;
    private OFDDocumentVo ofdDocumentVo;
    private ResourceManage resMgt;

    public DLOFDReader(Path ofdFile) throws IOException {
        super(ofdFile);
        this.initReader();
    }

    public DLOFDReader(String ofdFileLoc) throws IOException {
        super(Paths.get(ofdFileLoc, new String[0]));
        this.initReader();
    }

    public DLOFDReader(InputStream stream) throws IOException {
        super(stream);
        this.initReader();
    }

    public DLOFDReader(String unzippedPathRoot, boolean deleteOnClose) {
        super(unzippedPathRoot, deleteOnClose);
        this.initReader();
    }

    private void initReader() {
        try {
            this.resMgt = new ResourceManage(this);
            this.getResourceLocator().save();
            DocBody docBody = this.getOFDDir().getOfd().getDocBody();
            this.docRoot = docBody.getDocRoot();
            this.document = this.getResourceLocator().get(this.docRoot, Document::new);
            this.getPageBox();
            this.ofdDocumentVo = new OFDDocumentVo(this.docRoot.parent(), this.documentBox.getWidth(), this.documentBox.getHeight(), this.getOFDPageVO(), this.getStampAnnot(), this.getAnnotaions());
        }
        catch (FileNotFoundException | DocumentException var15) {
            throw new RuntimeException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + var15.getMessage(), var15);
        }
        finally {
            this.getResourceLocator().restore();
        }
    }

    public OFDDocumentVo getOFDDocumentVo() {
        return this.ofdDocumentVo;
    }

    private void getPageBox() {
        this.documentBox = null;
        try {
            this.documentBox = this.document.getCommonData().getPageArea().getPhysicalBox();
            if (this.documentBox == null) {
                this.documentBox = this.document.getCommonData().getPageArea().getApplicationBox();
            }
            if (this.documentBox == null) {
                this.documentBox = this.document.getCommonData().getPageArea().getContentBox();
            }
            if (this.documentBox == null) {
                new ST_Box(0.0, 0.0, 210.0, 140.0);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage(), e);
        }
    }

    private Page getTemplateInfo(String templateId) {
        Page obj;
        try {
            this.getResourceLocator().save();
            this.getResourceLocator().cd(this.docRoot.parent());
            List ct_templatePages = this.document.getCommonData().getTemplatePages();
            int index = -1;
            for (int i = 0; i < ct_templatePages.size(); ++i) {
                if (!((CT_TemplatePage)ct_templatePages.get(i)).getObjID().toString().equals(templateId)) continue;
                index = i;
                break;
            }
            if (index < 0) {
                throw new NumberFormatException("\u4e0d\u5b58\u5728\u8be5\u6a21\u677fid:" + templateId);
            }
            ST_Loc templateLoc = ((CT_TemplatePage)ct_templatePages.get(index)).getBaseLoc();
            obj = this.getResourceLocator().get(templateLoc, Page::new);
        }
        catch (FileNotFoundException | DocumentException var15) {
            throw new RuntimeException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + var15.getMessage(), var15);
        }
        finally {
            this.getResourceLocator().restore();
        }
        return obj;
    }

    public List<OfdPageVo> getOFDPageVO() {
        ArrayList<OfdPageVo> pageVoList = new ArrayList<OfdPageVo>();
        try {
            int pageSize = this.document.getPages().getSize();
            for (int i = 0; i < pageSize; ++i) {
                OfdPageVo ofdPageVo;
                Page page = this.getPage(i + 1);
                page.setObjID(((org.ofdrw.core.basicStructure.pageTree.Page)this.document.getPages().getPages().get(i)).getID());
                if (!Objects.isNull(page.getTemplate())) {
                    String templateId = page.getTemplate().getTemplateID().toString();
                    Page tmplPage = this.getTemplateInfo(templateId);
                    ofdPageVo = new OfdPageVo(page, tmplPage);
                } else {
                    ofdPageVo = new OfdPageVo(page, null);
                }
                pageVoList.add(ofdPageVo);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage(), e);
        }
        finally {
            this.getResourceLocator().restore();
        }
        return pageVoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StampAnnotVo> getStampAnnot() {
        ArrayList<StampAnnotVo> stampAnnotVoList = new ArrayList<StampAnnotVo>();
        try {
            if (this.hasSignature()) {
                this.getResourceLocator().save();
                this.getResourceLocator().cd(this.docRoot.parent());
                for (int i = 0; i < this.getDefaultSignatures().getSignatures().size(); ++i) {
                    TBS_Sign toSign;
                    org.ofdrw.gm.ses.v4.SES_Signature sesSignature;
                    StampAnnotVo stampAnnotVo = new StampAnnotVo();
                    Signature signatures = (Signature)this.getDefaultSignatures().getSignatures().get(i);
                    ST_Loc signatureBaseLoc = signatures.getBaseLoc();
                    if (signatureBaseLoc.toString().indexOf("Signs") == -1) {
                        signatureBaseLoc = new ST_Loc("Signs/" + signatureBaseLoc.toString());
                    }
                    org.ofdrw.core.signatures.sig.Signature signature = this.getResourceLocator().get(signatureBaseLoc, org.ofdrw.core.signatures.sig.Signature::new);
                    SignedInfo signedInfo = signature.getSignedInfo();
                    stampAnnotVo.setStampAnnots(signedInfo.getStampAnnots());
                    ST_Loc signedValueStLoc = signature.getSignedValue();
                    String srcPath = signedValueStLoc.toString();
                    byte[] bytes = FileUtils.readFileToByteArray((File)new File(this.getOFDDir().getFile(srcPath).toAbsolutePath().toString()));
                    SESVersionHolder v = VersionParser.parseSES_SignatureVersion((Object)bytes);
                    String type = null;
                    byte[] sealBytes = new byte[]{};
                    if (v.getVersion() == SESVersion.v4) {
                        sesSignature = org.ofdrw.gm.ses.v4.SES_Signature.getInstance((Object)bytes);
                        toSign = sesSignature.getToSign();
                        type = toSign.getEseal().geteSealInfo().getPicture().getType().getString();
                        sealBytes = toSign.getEseal().geteSealInfo().getPicture().getData().getOctets();
                    } else if (v.getVersion() == SESVersion.v1) {
                        sesSignature = SES_Signature.getInstance((Object)bytes);
                        toSign = sesSignature.getToSign();
                        type = toSign.getEseal().getEsealInfo().getPicture().getType().getString();
                        sealBytes = toSign.getEseal().getEsealInfo().getPicture().getData().getOctets();
                    }
                    if (type == null) continue;
                    stampAnnotVo.setType(type);
                    stampAnnotVo.setImgByte(sealBytes);
                    stampAnnotVoList.add(stampAnnotVo);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.getResourceLocator().restore();
        }
        return stampAnnotVoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AnnotionEntity> getAnnotaions() {
        ArrayList<AnnotionEntity> annotaionList = new ArrayList<AnnotionEntity>();
        try {
            Annotations annotations = this.getAnnotations();
            if (annotations == null) {
                ArrayList<AnnotionEntity> arrayList = annotaionList;
                return arrayList;
            }
            List annPages = annotations.getPages();
            this.getResourceLocator().save();
            this.getResourceLocator().cd(this.docRoot.parent());
            for (AnnPage page : annPages) {
                ST_Loc antLoc = page.getFileLoc();
                if (antLoc.toString().contains(this.docRoot.parent())) {
                    antLoc = ST_Loc.getInstance((String)antLoc.toString().replace(this.docRoot.parent() + "/", "").replaceFirst("/", ""));
                }
                if (!antLoc.toString().contains(this.document.getAnnotations().parent())) {
                    antLoc = ST_Loc.getInstance((String)(this.document.getAnnotations().parent() + "/" + antLoc));
                }
                try {
                    PageAnnot pageAnnot = this.getResourceLocator().get(antLoc, PageAnnot::new);
                    annotaionList.add(new AnnotionEntity(page.getPageID().toString(), pageAnnot.getAnnots()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.getResourceLocator().restore();
        }
        return annotaionList;
    }

    @Override
    public ResourceManage getResMgt() {
        return this.resMgt;
    }
}

