/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.engine;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ofdrw.layout.PageLayout;
import org.ofdrw.layout.Rectangle;
import org.ofdrw.layout.VirtualPage;
import org.ofdrw.layout.element.AFloat;
import org.ofdrw.layout.element.Div;
import org.ofdrw.layout.element.Position;
import org.ofdrw.layout.engine.Segment;

public class StreamingLayoutAnalyzer {
    private Rectangle pageWorkArea;
    private PageLayout layout;
    private LinkedList<VirtualPage> vPageList;
    private Rectangle remainArea;
    private VirtualPage vPage;

    public StreamingLayoutAnalyzer(PageLayout layout) {
        this.pageWorkArea = layout.getWorkerArea();
        this.layout = layout;
        this.vPageList = new LinkedList();
    }

    public List<VirtualPage> analyze(List<Segment> segmentSequence) {
        if (segmentSequence == null || segmentSequence.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Segment> seq = new LinkedList<Segment>(segmentSequence);
        if (this.vPageList.isEmpty()) {
            this.addNewPage();
        }
        while (!seq.isEmpty()) {
            Segment segment = seq.pop();
            if (this.remainArea.getHeight() == 0.0) {
                this.addNewPage();
            }
            if (segment.isRemainAreaFiller()) {
                this.remainArea.setHeight(0.0);
                continue;
            }
            if (segment.getHeight() <= this.remainArea.getHeight()) {
                Rectangle area = this.remainArea.reduce(segment.getHeight());
                this.elementPositioning(segment, area);
                continue;
            }
            if (!segment.isBlockable()) {
                if (segment.getHeight() > this.pageWorkArea.getHeight()) continue;
                this.addNewPage();
                seq.push(segment);
                continue;
            }
            Segment[] blocks = this.segmentBlocking(segment, this.remainArea.clone());
            if (blocks == null || blocks.length <= 0) continue;
            for (int i = blocks.length - 1; i >= 0; --i) {
                seq.push(blocks[i]);
            }
        }
        return this.vPageList;
    }

    private Segment[] segmentBlocking(Segment segment, Rectangle area) {
        Segment sgm1 = new Segment(segment.getWidth());
        Segment sgmNext = new Segment(segment.getWidth());
        for (Map.Entry<Div, Rectangle> item : segment) {
            Div div = item.getKey();
            Rectangle rec = item.getValue();
            double availableHeight = area.getHeight();
            if (rec.getHeight() <= availableHeight) {
                sgm1.tryAdd(div);
                sgmNext.tryAdd(Div.placeholder(rec, div.getFloat()));
                continue;
            }
            if (div.isIntegrity().booleanValue()) {
                sgm1.tryAdd(Div.placeholder(rec.getWidth(), availableHeight, div.getFloat()));
                sgmNext.tryAdd(div);
                continue;
            }
            Div[] split = div.split(availableHeight);
            sgm1.tryAdd(split[0]);
            sgmNext.tryAdd(split[1]);
        }
        return new Segment[]{sgm1, sgmNext};
    }

    private void elementPositioning(Segment segment, Rectangle area) {
        Rectangle box;
        Div itemDiv;
        if (segment.isCenterFloat()) {
            double totalWidth = segment.getSizeList().stream().mapToDouble(Rectangle::getWidth).sum();
            double offsetX = area.getX() + (area.getWidth() - totalWidth) / 2.0;
            for (Map.Entry<Div, Rectangle> item : segment) {
                itemDiv = item.getKey();
                box = item.getValue();
                itemDiv.setX(offsetX);
                offsetX += box.getWidth();
            }
        } else {
            double startX = area.getX();
            double endX = startX + area.getWidth();
            for (Map.Entry<Div, Rectangle> item : segment) {
                itemDiv = item.getKey();
                box = item.getValue();
                AFloat aFloat = itemDiv.getFloat();
                if (aFloat == AFloat.left) {
                    itemDiv.setX(startX);
                    startX += box.getWidth();
                    continue;
                }
                if (aFloat != AFloat.right) continue;
                itemDiv.setX(endX - box.getWidth());
                endX -= box.getWidth();
            }
        }
        for (Map.Entry<Div, Rectangle> item : segment) {
            Div itemDiv2 = item.getKey();
            if (itemDiv2.isPlaceholder()) continue;
            itemDiv2.setY(area.getY());
            if (itemDiv2.getPosition() == Position.Relative) {
                Double x = itemDiv2.getX();
                Double y = itemDiv2.getY();
                ((Div)itemDiv2.setX(x + itemDiv2.getLeft() - itemDiv2.getRight())).setY(y + itemDiv2.getTop());
            }
            itemDiv2.setPosition(Position.Absolute);
            this.vPage.addUnsafe(itemDiv2);
        }
    }

    private void addNewPage() {
        this.remainArea = this.pageWorkArea.clone();
        this.vPage = new VirtualPage(this.layout);
        this.vPageList.add(this.vPage);
    }
}

