/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.edit;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.ofdrw.core.attachment.CT_Attachment;

public class Attachment {
    private Path file;
    private CT_Attachment atmObj;

    private Attachment() {
    }

    public Attachment(String name, Path file) {
        if (file == null || Files.notExists(file, new LinkOption[0])) {
            throw new IllegalArgumentException("\u9644\u4ef6\u6587\u4ef6(file)\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728");
        }
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("\u9644\u4ef6\u540d\u79f0(name)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.file = file;
        this.atmObj = new CT_Attachment();
        this.setName(name);
    }

    public Attachment setName(String attachmentName) {
        this.atmObj.setAttachmentName(attachmentName);
        return this;
    }

    public String getName() {
        return this.atmObj.getAttachmentName();
    }

    public Attachment setFormat(String format) {
        this.atmObj.setFormat(format);
        return this;
    }

    public String getFormat() {
        return this.atmObj.getFormat();
    }

    @Deprecated
    public Attachment setCreationDate(LocalDate creationDate) {
        this.atmObj.setCreationDate(creationDate.atStartOfDay());
        return this;
    }

    public Attachment setCreationDate(LocalDateTime creationDate) {
        this.atmObj.setCreationDate(creationDate);
        return this;
    }

    @Deprecated
    public LocalDate getCreationDate() {
        return this.atmObj.getCreationDateTime().toLocalDate();
    }

    public LocalDateTime getCreationDateTime() {
        return this.atmObj.getCreationDateTime();
    }

    @Deprecated
    public Attachment setModDate(LocalDate modDate) {
        this.atmObj.setModDate(modDate.atStartOfDay());
        return this;
    }

    public Attachment setModDateTime(LocalDateTime modDate) {
        this.atmObj.setModDate(modDate);
        return this;
    }

    @Deprecated
    public LocalDate getModDate() {
        return this.atmObj.getModDateTime().toLocalDate();
    }

    public LocalDateTime getModDateTime() {
        return this.atmObj.getCreationDateTime();
    }

    public Attachment setVisible(Boolean visible) {
        this.atmObj.setVisible(visible);
        return this;
    }

    public Boolean getVisible() {
        return this.atmObj.getVisible();
    }

    public Attachment setUsage(String usage) {
        this.atmObj.setUsage(usage);
        return this;
    }

    public String getUsage() {
        return this.atmObj.getUsage();
    }

    public Path getFile() {
        return this.file;
    }

    public Attachment setFile(Path file) {
        this.file = file;
        return this;
    }

    public CT_Attachment getAttachment() {
        return this.atmObj;
    }
}

