/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.gm.sm2strut;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.Certificate;
import org.ofdrw.gm.sm2strut.ContentInfo;
import org.ofdrw.gm.sm2strut.IssuerAndSerialNumber;

public final class SignedData
extends ASN1Object {
    public static final ASN1Integer VERSION_1 = new ASN1Integer(1L);
    private ASN1Integer version = VERSION_1;
    private ASN1Set digestAlgorithms;
    private ContentInfo contentInfo;
    private ASN1Set certificates;
    private ASN1Set crls;
    private ASN1Set signerInfos;

    public SignedData(ASN1Set digestAlgorithms, ContentInfo contentInfo, ASN1Set certificates, ASN1Set signerInfos) {
        this.digestAlgorithms = digestAlgorithms;
        this.contentInfo = contentInfo;
        this.certificates = certificates;
        this.signerInfos = signerInfos;
    }

    public SignedData(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.version = ASN1Integer.getInstance(e.nextElement());
        this.digestAlgorithms = (ASN1Set)e.nextElement();
        this.contentInfo = ContentInfo.getInstance(e.nextElement());
        while (e.hasMoreElements()) {
            ASN1Primitive o = (ASN1Primitive)e.nextElement();
            if (o instanceof ASN1TaggedObject) {
                ASN1TaggedObject tagged = (ASN1TaggedObject)o;
                switch (tagged.getTagNo()) {
                    case 0: {
                        this.certificates = ASN1Set.getInstance((ASN1TaggedObject)tagged, (boolean)false);
                        break;
                    }
                    case 1: {
                        this.crls = ASN1Set.getInstance((ASN1TaggedObject)tagged, (boolean)false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("\u65e0\u6cd5\u63a5 \u6807\u7b7e\u53c2\u6570 " + tagged.getTagNo());
                    }
                }
                continue;
            }
            this.signerInfos = (ASN1Set)o;
        }
    }

    public static SignedData getInstance(Object o) {
        if (o instanceof SignedData) {
            return (SignedData)((Object)o);
        }
        if (o != null) {
            return new SignedData(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public SignedData setVersion(ASN1Integer version) {
        this.version = version;
        return this;
    }

    public ASN1Set getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    public SignedData setDigestAlgorithms(ASN1Set digestAlgorithms) {
        this.digestAlgorithms = digestAlgorithms;
        return this;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public SignedData setContentInfo(ContentInfo contentInfo) {
        this.contentInfo = contentInfo;
        return this;
    }

    public ASN1Set getCertificates() {
        return this.certificates;
    }

    public SignedData setCertificates(ASN1Set certificates) {
        this.certificates = certificates;
        return this;
    }

    public ASN1Set getCrls() {
        return this.crls;
    }

    public SignedData setCrls(ASN1Set crls) {
        this.crls = crls;
        return this;
    }

    public ASN1Set getSignerInfos() {
        return this.signerInfos;
    }

    public SignedData setSignerInfos(ASN1Set signerInfos) {
        this.signerInfos = signerInfos;
        return this;
    }

    public Certificate getSignCert(IssuerAndSerialNumber iaSn) {
        if (iaSn == null) {
            return null;
        }
        for (ASN1Encodable item : this.certificates) {
            Certificate c = Certificate.getInstance((Object)item);
            boolean snEq = c.getSerialNumber().equals((ASN1Primitive)iaSn.getCertSerialNumber());
            boolean dnEq = c.getIssuer().equals((Object)iaSn.getName());
            if (!snEq || !dnEq) continue;
            return c;
        }
        return null;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(6);
        v.add((ASN1Encodable)this.version);
        v.add((ASN1Encodable)this.digestAlgorithms);
        v.add((ASN1Encodable)this.contentInfo);
        if (this.certificates != null) {
            v.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.certificates));
        }
        if (this.crls != null) {
            v.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)this.crls));
        }
        v.add((ASN1Encodable)this.signerInfos);
        return new DERSequence(v);
    }
}

