/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.ofdrw.converter.point.PathPoint;
import org.ofdrw.converter.point.TextCodePoint;
import org.ofdrw.converter.utils.CommonUtil;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.graph.pathObj.AbbreviatedData;
import org.ofdrw.core.graph.pathObj.OptVal;
import org.ofdrw.core.text.CT_CGTransform;
import org.ofdrw.core.text.TextCode;
import org.ofdrw.reader.DeltaTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointUtil {
    private static final Logger logger = LoggerFactory.getLogger(PointUtil.class);

    public static List<PathPoint> convertPathAbbreviatedDatatoPoint(String abbreviatedData) {
        LinkedList optValArr = AbbreviatedData.parse((String)abbreviatedData);
        ArrayList<PathPoint> pointList = new ArrayList<PathPoint>();
        for (OptVal optVal : optValArr) {
            double[] array = optVal.expectValues();
            switch (optVal.opt) {
                case "M": {
                    pointList.add(new PathPoint("M", (float)array[0], (float)array[1], 0.0f, 0.0f, 0.0f, 0.0f));
                    break;
                }
                case "L": {
                    pointList.add(new PathPoint("L", (float)array[0], (float)array[1], 0.0f, 0.0f, 0.0f, 0.0f));
                    break;
                }
                case "C": {
                    pointList.add(new PathPoint("C", 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f));
                    break;
                }
                case "S": {
                    pointList.add(new PathPoint("S", (float)array[0], (float)array[1], 0.0f, 0.0f, 0.0f, 0.0f));
                    break;
                }
                case "B": {
                    pointList.add(new PathPoint("B", (float)array[0], (float)array[1], (float)array[2], (float)array[3], (float)array[4], (float)array[5]));
                    break;
                }
                case "Q": {
                    pointList.add(new PathPoint("Q", (float)array[0], (float)array[1], (float)array[2], (float)array[3], 0.0f, 0.0f));
                    break;
                }
                case "A": {
                    pointList.add(new PathPoint("A", (float)array[0], (float)array[1], (float)array[2], (float)array[3], (float)array[4], (float)array[5], (float)array[6]));
                }
            }
        }
        return pointList;
    }

    public static List<PathPoint> calPathPoint(List<PathPoint> abbreviatedPoint) {
        ArrayList<PathPoint> pointList = new ArrayList<PathPoint>();
        for (PathPoint point : abbreviatedPoint) {
            if (point.type.equals("M") || point.type.equals("L") || point.type.equals("C") || point.type.equals("S")) {
                double x = 0.0;
                double y = 0.0;
                x = point.x1;
                y = point.y1;
                point.x1 = (float)CommonUtil.converterDpi(x);
                point.y1 = (float)CommonUtil.converterDpi(y);
                pointList.add(point);
                continue;
            }
            if (!point.type.equals("B")) continue;
            double x1 = point.x1;
            double y1 = point.y1;
            double x2 = point.x2;
            double y2 = point.y2;
            double x3 = point.x3;
            double y3 = point.y3;
            PathPoint realPoint = new PathPoint("B", (float)CommonUtil.converterDpi(x1), (float)CommonUtil.converterDpi(y1), (float)CommonUtil.converterDpi(x2), (float)CommonUtil.converterDpi(y2), (float)CommonUtil.converterDpi(x3), (float)CommonUtil.converterDpi(y3));
            pointList.add(realPoint);
        }
        return pointList;
    }

    public static List<TextCodePoint> calTextPoint(List<TextCode> textCodes) {
        double x = 0.0;
        double y = 0.0;
        ArrayList<TextCodePoint> textCodePointList = new ArrayList<TextCodePoint>();
        for (TextCode textCode : textCodes) {
            x = textCode.getX();
            y = textCode.getY();
            Double[] deltaXList = null;
            Double[] deltaYList = null;
            if (textCode.getDeltaX() != null && textCode.getDeltaX().getArray().size() > 0) {
                deltaXList = textCode.getDeltaX().toDouble();
            }
            if (textCode.getDeltaY() != null && textCode.getDeltaY().getArray().size() > 0) {
                deltaYList = textCode.getDeltaY().toDouble();
            }
            for (int i = 0; i < textCode.getText().length(); ++i) {
                if (i > 0 && Objects.nonNull(deltaXList)) {
                    x += deltaXList[i - 1].doubleValue();
                }
                if (i > 0 && Objects.nonNull(deltaYList)) {
                    y += deltaYList[i - 1].doubleValue();
                }
                String text = textCode.getText().substring(i, i + 1);
                TextCodePoint textCodePoint = new TextCodePoint(CommonUtil.converterDpi(x), CommonUtil.converterDpi(y), text);
                textCodePointList.add(textCodePoint);
            }
        }
        return textCodePointList;
    }

    public static double[] adjustPos(double width, double height, double x, double y, ST_Box boundary) {
        if (boundary == null) {
            return new double[]{x, y};
        }
        double realX = boundary.getTopLeftX() + x;
        double realY = boundary.getTopLeftY() + y;
        return new double[]{realX, realY};
    }

    public static double[] ctmCalPoint(double x, double y, Double[] ctm) {
        double ctmX = x * ctm[0] + y * ctm[2] + 1.0 * ctm[4];
        double ctmY = x * ctm[1] + y * ctm[3] + 1.0 * ctm[5];
        return new double[]{ctmX, ctmY};
    }

    public static List<PathPoint> calPdfPathPoint(double width, double height, ST_Box boundary, List<PathPoint> abbreviatedPoint, boolean hasCtm, ST_Array ctm, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM, boolean fixOriginToPdf) {
        return PointUtil.calPdfPathPoint(width, height, boundary, abbreviatedPoint, hasCtm, ctm, compositeObjectBoundary, compositeObjectCTM, fixOriginToPdf, 1.0);
    }

    public static List<PathPoint> calPdfPathPoint(double width, double height, ST_Box boundary, List<PathPoint> abbreviatedPoint, boolean hasCtm, ST_Array ctm, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM, boolean fixOriginToPdf, double scale) {
        ArrayList<PathPoint> pointList = new ArrayList<PathPoint>();
        for (PathPoint point : abbreviatedPoint) {
            double y1;
            double x1;
            if (point.type.equals("M") || point.type.equals("L") || point.type.equals("C") || point.type.equals("S")) {
                double x = 0.0;
                double y = 0.0;
                x = point.x1;
                y = point.y1;
                if (hasCtm) {
                    double[] newPoint = PointUtil.ctmCalPoint(x, y, ctm.toDouble());
                    x = newPoint[0];
                    y = newPoint[1];
                }
                double[] realPos = PointUtil.adjustPos(width, height, x * scale, y * scale, boundary);
                point.x1 = (float)CommonUtil.converterDpi(realPos[0]);
                point.y1 = (float)CommonUtil.converterDpi(fixOriginToPdf ? height - realPos[1] : realPos[1]);
                if (compositeObjectBoundary != null) {
                    if (compositeObjectCTM != null) {
                        realPos = PointUtil.ctmCalPoint(realPos[0], realPos[1], compositeObjectCTM.toDouble());
                    }
                    realPos = PointUtil.adjustPos(width, height, realPos[0], realPos[1], compositeObjectBoundary);
                    point.x1 = (float)CommonUtil.converterDpi(realPos[0]);
                    point.y1 = (float)CommonUtil.converterDpi(fixOriginToPdf ? height - realPos[1] : realPos[1]);
                }
                pointList.add(point);
                continue;
            }
            if (point.type.equals("B")) {
                x1 = point.x1;
                y1 = point.y1;
                double x2 = point.x2;
                double y2 = point.y2;
                double x3 = point.x3;
                double y3 = point.y3;
                if (hasCtm) {
                    double[] newPoint = PointUtil.ctmCalPoint(x1, y1, ctm.toDouble());
                    x1 = newPoint[0];
                    y1 = newPoint[1];
                    newPoint = PointUtil.ctmCalPoint(x2, y2, ctm.toDouble());
                    x2 = newPoint[0];
                    y2 = newPoint[1];
                    newPoint = PointUtil.ctmCalPoint(x3, y3, ctm.toDouble());
                    x3 = newPoint[0];
                    y3 = newPoint[1];
                }
                double[] realPos = PointUtil.adjustPos(width, height, x1 * scale, y1 * scale, boundary);
                x1 = realPos[0];
                y1 = realPos[1];
                realPos = PointUtil.adjustPos(width, height, x2 * scale, y2 * scale, boundary);
                x2 = realPos[0];
                y2 = realPos[1];
                realPos = PointUtil.adjustPos(width, height, x3 * scale, y3 * scale, boundary);
                x3 = realPos[0];
                y3 = realPos[1];
                PathPoint realPoint = new PathPoint("B", (float)CommonUtil.converterDpi(x1), (float)CommonUtil.converterDpi(fixOriginToPdf ? height - y1 : y1), (float)CommonUtil.converterDpi(x2), (float)CommonUtil.converterDpi(fixOriginToPdf ? height - y2 : y2), (float)CommonUtil.converterDpi(x3), (float)CommonUtil.converterDpi(fixOriginToPdf ? height - y3 : y3));
                pointList.add(realPoint);
                continue;
            }
            if (point.type.equals("Q")) {
                x1 = point.x1;
                y1 = point.y1;
                double x2 = point.x2;
                double y2 = point.y2;
                if (hasCtm) {
                    double[] newPoint = PointUtil.ctmCalPoint(x1, y1, ctm.toDouble());
                    x1 = newPoint[0];
                    y1 = newPoint[1];
                    newPoint = PointUtil.ctmCalPoint(x2, y2, ctm.toDouble());
                    x2 = newPoint[0];
                    y2 = newPoint[1];
                }
                double[] realPos = PointUtil.adjustPos(width, height, x1 * scale, y1 * scale, boundary);
                x1 = realPos[0];
                y1 = realPos[1];
                realPos = PointUtil.adjustPos(width, height, x2 * scale, y2 * scale, boundary);
                x2 = realPos[0];
                y2 = realPos[1];
                PathPoint realPoint = new PathPoint("Q", (float)CommonUtil.converterDpi(x1), (float)CommonUtil.converterDpi(fixOriginToPdf ? height - y1 : y1), (float)CommonUtil.converterDpi(x2), (float)CommonUtil.converterDpi(fixOriginToPdf ? height - y2 : y2), 0.0f, 0.0f);
                pointList.add(realPoint);
                continue;
            }
            if (!point.type.equals("A")) continue;
            double rx = point.rx;
            double ry = point.ry;
            float rotation = point.rotation;
            float arc = point.arc;
            float sweep = point.sweep;
            double x = point.x;
            double y = point.y;
            if (hasCtm) {
                double[] newPoint = PointUtil.ctmCalPoint(x, y, ctm.toDouble());
                x = newPoint[0];
                y = newPoint[1];
            }
            double[] realPos = PointUtil.adjustPos(width, height, x * scale, y * scale, boundary);
            x = realPos[0];
            y = realPos[1];
            PathPoint realPoint = new PathPoint("A", (float)CommonUtil.converterDpi(rx), (float)CommonUtil.converterDpi(ry), rotation, arc, sweep, (float)CommonUtil.converterDpi(x), (float)CommonUtil.converterDpi(fixOriginToPdf ? height - y : y));
            pointList.add(realPoint);
        }
        return pointList;
    }

    public static List<TextCodePoint> calPdfTextCoordinate(double width, double height, ST_Box boundary, float fontSize, List<TextCode> textCodes, boolean hasCtm, ST_Array ctm, boolean fixOriginToPdf, double scale) {
        double x = 0.0;
        double y = 0.0;
        ArrayList<TextCodePoint> textCodePointList = new ArrayList<TextCodePoint>();
        for (TextCode textCode : textCodes) {
            x = textCode.getX() == null ? 0.0 : textCode.getX();
            double d = y = textCode.getY() == null ? 0.0 : textCode.getY();
            if (hasCtm) {
                double[] newPoint = PointUtil.ctmCalPoint(x, y, ctm.toDouble());
                x = newPoint[0];
                y = newPoint[1];
            }
            List deltaXList = null;
            List deltaYList = null;
            String textStr = textCode.getText();
            if (textCode.getDeltaX() != null && textCode.getDeltaX().getArray().size() > 0) {
                deltaXList = DeltaTool.getDelta((ST_Array)textCode.getDeltaX(), (int)textStr.length());
            }
            if (textCode.getDeltaY() != null && textCode.getDeltaY().getArray().size() > 0) {
                deltaYList = DeltaTool.getDelta((ST_Array)textCode.getDeltaY(), (int)textStr.length());
            }
            textStr = textStr.replaceAll("&lt;", "<");
            textStr = textStr.replaceAll("&gt;", ">");
            textStr = textStr.replaceAll("&amp;", "&");
            textStr = textStr.replaceAll("\n", "");
            textStr = textStr.replaceAll("&nbsp;", " ");
            textStr = textStr.replaceAll("&quot;", "\"");
            textStr = textStr.replaceAll("&copy;", "");
            textStr = textStr.replaceAll("&apos;", "'");
            for (int i = 0; i < textStr.length(); ++i) {
                double[] newPoint;
                double angel;
                double f;
                double e;
                double d2;
                double c;
                double b;
                double a;
                Double[] ctms;
                float decent = 0.0f;
                if (i > 0 && Objects.nonNull(deltaXList)) {
                    if (hasCtm) {
                        ctms = ctm.toDouble();
                        a = ctms[0];
                        b = ctms[1];
                        c = ctms[2];
                        d2 = ctms[3];
                        e = ctms[4];
                        f = ctms[5];
                        angel = Math.atan2(-b, d2);
                        if (angel == 0.0) {
                            newPoint = PointUtil.ctmCalPoint(((Float)deltaXList.get(i - 1)).floatValue(), 0.0, ctm.toDouble());
                            x += newPoint[0];
                        } else {
                            x += (double)((Float)deltaXList.get(i - 1)).floatValue();
                        }
                    } else {
                        x += (double)((Float)deltaXList.get(i - 1)).floatValue();
                    }
                }
                if (i > 0 && Objects.nonNull(deltaYList)) {
                    if (hasCtm) {
                        ctms = ctm.toDouble();
                        a = ctms[0];
                        b = ctms[1];
                        c = ctms[2];
                        d2 = ctms[3];
                        e = ctms[4];
                        f = ctms[5];
                        angel = Math.atan2(-b, d2);
                        if (angel == 0.0) {
                            newPoint = PointUtil.ctmCalPoint(0.0, ((Float)deltaYList.get(i - 1)).floatValue(), ctm.toDouble());
                            y += newPoint[1];
                        } else {
                            y += (double)((Float)deltaYList.get(i - 1)).floatValue();
                        }
                    } else {
                        y += (double)((Float)deltaYList.get(i - 1)).floatValue();
                    }
                }
                double[] realPos = PointUtil.adjustPos(width, height, x * scale, y * scale, boundary);
                String text = textStr.substring(i, i + 1);
                TextCodePoint textCodePoint = new TextCodePoint(CommonUtil.converterDpi(realPos[0]), CommonUtil.converterDpi(fixOriginToPdf ? height - realPos[1] : realPos[1]), text);
                textCodePointList.add(textCodePoint);
            }
        }
        return textCodePointList;
    }

    public static List<TextCodePoint> calPdfTextCoordinate(double width, double height, ST_Box boundary, float fontSize, List<TextCode> textCodes, List<CT_CGTransform> cgTransforms, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM, boolean hasCtm, ST_Array ctm, boolean fixOriginToPdf) {
        return PointUtil.calPdfTextCoordinate(width, height, boundary, fontSize, textCodes, cgTransforms, compositeObjectBoundary, compositeObjectCTM, hasCtm, ctm, fixOriginToPdf, 1.0);
    }

    public static List<TextCodePoint> calPdfTextCoordinate(double width, double height, ST_Box boundary, float fontSize, List<TextCode> textCodes, List<CT_CGTransform> cgTransforms, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM, boolean hasCtm, ST_Array ctm, boolean fixOriginToPdf, double scale) {
        double x = 0.0;
        double y = 0.0;
        ArrayList<TextCodePoint> textCodePointList = new ArrayList<TextCodePoint>();
        for (TextCode textCode : textCodes) {
            x = textCode.getX() == null ? 0.0 : textCode.getX();
            double d = y = textCode.getY() == null ? 0.0 : textCode.getY();
            if (hasCtm) {
                double[] newPoint = PointUtil.ctmCalPoint(x, y, ctm.toDouble());
                x = newPoint[0];
                y = newPoint[1];
            }
            List deltaXList = null;
            List deltaYList = null;
            String textStr = textCode.getText();
            if (textCode.getDeltaX() != null && textCode.getDeltaX().getArray().size() > 0) {
                deltaXList = textCode.getDeltaX().getArray();
            }
            if (textCode.getDeltaY() != null && textCode.getDeltaY().getArray().size() > 0) {
                deltaYList = textCode.getDeltaY().getArray();
            }
            textStr = textStr.replaceAll("&lt;", "<");
            textStr = textStr.replaceAll("&gt;", ">");
            textStr = textStr.replaceAll("&amp;", "&");
            textStr = textStr.replaceAll("\n", "");
            textStr = textStr.replaceAll("&nbsp;", " ");
            textStr = textStr.replaceAll("&quot;", "\"");
            textStr = textStr.replaceAll("&copy;", "");
            textStr = textStr.replaceAll("&apos;", "'");
            int skipCount = 0;
            for (int i = 0; i < textStr.length(); ++i) {
                double[] newPoint;
                double angel;
                double f;
                double e;
                double d2;
                double c;
                double b;
                double a;
                String text = textStr.substring(i, i + 1);
                boolean skipPosition = false;
                if (i > 0 && Objects.nonNull(deltaXList)) {
                    double dx;
                    int index;
                    for (CT_CGTransform cgTransform : cgTransforms) {
                        int pos = cgTransform.getCodePosition();
                        int codeCount = cgTransform.getCodeCount();
                        if (i <= pos || i >= pos + codeCount) continue;
                        if (cgTransform.getGlyphs().size() >= codeCount) break;
                        skipPosition = true;
                        ++skipCount;
                        break;
                    }
                    if ((index = i - 1) >= deltaXList.size()) {
                        index = deltaXList.size() - 1;
                    }
                    if ((dx = Double.parseDouble((String)deltaXList.get(index))) != 0.0) {
                        if (hasCtm) {
                            Double[] ctms = ctm.toDouble();
                            a = ctms[0];
                            b = ctms[1];
                            c = ctms[2];
                            d2 = ctms[3];
                            e = ctms[4];
                            f = ctms[5];
                            angel = Math.atan2(-b, d2);
                            if (angel == 0.0) {
                                newPoint = PointUtil.ctmCalPoint(dx, 0.0, ctm.toDouble());
                                dx = newPoint[0];
                            } else if (a == 0.0 && d2 == 0.0) {
                                dx *= (double)fontSize;
                            }
                        } else if (skipPosition) {
                            deltaXList.add(i - 1, "0");
                        }
                    }
                    x += !skipPosition ? dx : 0.0;
                }
                if (i > 0 && Objects.nonNull(deltaYList)) {
                    double dy;
                    int index = i - 1;
                    if (i - 1 >= deltaYList.size()) {
                        index = deltaYList.size() - 1;
                    }
                    if ((dy = Double.parseDouble((String)deltaYList.get(index))) != 0.0 && hasCtm) {
                        Double[] ctms = ctm.toDouble();
                        a = ctms[0];
                        b = ctms[1];
                        c = ctms[2];
                        d2 = ctms[3];
                        e = ctms[4];
                        f = ctms[5];
                        angel = Math.atan2(-b, d2);
                        if (angel == 0.0) {
                            newPoint = PointUtil.ctmCalPoint(0.0, dy, ctm.toDouble());
                            dy = newPoint[1];
                        } else if (a == 0.0 && d2 == 0.0) {
                            dy *= (double)fontSize;
                        }
                    }
                    y += dy;
                }
                double[] realPos = PointUtil.adjustPos(width, height, x * scale, y * scale, boundary);
                if (compositeObjectCTM != null) {
                    realPos = PointUtil.ctmCalPoint(realPos[0], realPos[1], compositeObjectCTM.toDouble());
                }
                if (skipPosition) {
                    text = "";
                }
                TextCodePoint textCodePoint = new TextCodePoint(CommonUtil.converterDpi(realPos[0]), CommonUtil.converterDpi(fixOriginToPdf ? height - realPos[1] : realPos[1]), text);
                textCodePointList.add(textCodePoint);
            }
        }
        if (textCodePointList.size() > 0) {
            for (CT_CGTransform cgTransform : cgTransforms) {
                int pos = cgTransform.getCodePosition();
                int glyphCount = cgTransform.getGlyphCount();
                int codeCount = cgTransform.getCodeCount();
                for (int i = pos; i < glyphCount + pos; ++i) {
                    if (textCodePointList.size() <= i) {
                        String glyphs = ((TextCodePoint)textCodePointList.get(textCodePointList.size() - 1)).getGlyph() + " " + (String)cgTransform.getGlyphs().getArray().get(i - pos);
                        ((TextCodePoint)textCodePointList.get(textCodePointList.size() - 1)).setGlyph(glyphs);
                        continue;
                    }
                    ((TextCodePoint)textCodePointList.get(i)).setGlyph((String)cgTransform.getGlyphs().getArray().get(i - pos));
                }
            }
        }
        return textCodePointList;
    }
}

