/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.io.font.ItextTrueTypeFont;
import com.itextpdf.io.font.TrueTypeFont;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class ItextFontUtil {
    private ItextFontUtil() {
    }

    public static FontProgram loadFontProgram(String fontFile) throws IOException {
        if (fontFile == null || fontFile.isEmpty()) {
            throw new IllegalArgumentException("\u5b57\u4f53\u8def\u5f84\u4e3a\u7a7a");
        }
        Object fontProgram = null;
        String fileName = fontFile.toLowerCase();
        try {
            byte[] fontRaw = Files.readAllBytes(Paths.get(fontFile, new String[0]));
            fontProgram = fileName.endsWith(".ttc") ? FontProgramFactory.createFont((byte[])fontRaw, (int)0, (boolean)false) : (fileName.endsWith(".ttf") || fileName.endsWith(".otf") ? ItextFontUtil.loadFont(fontRaw) : FontProgramFactory.createFont((byte[])fontRaw));
            return fontProgram;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static TrueTypeFont loadFont(byte[] fontRaw) throws IOException {
        try {
            return new TrueTypeFont(fontRaw);
        }
        catch (Exception e1) {
            try {
                return new ItextTrueTypeFont(fontRaw);
            }
            catch (IOException e2) {
                throw e2;
            }
            catch (Exception e2) {
                throw new IOException(e2);
            }
        }
    }
}

