/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.noear.weed.utils.AssertUtils;
import org.noear.weed.utils.StringUtils;

class JavaStringCompiler {
    static JavaStringCompiler _instance;
    private final Map<String, ByteJavaFileObject> javaFileMap = new ConcurrentHashMap<String, ByteJavaFileObject>();
    private final JavaCompiler javaCompiler;
    private JavaFileManager javaFileManager;
    private StringClassLoader javaClassLoader;
    private final DiagnosticCollector<JavaFileObject> diagnosticsCollector = new DiagnosticCollector();

    public static JavaStringCompiler instance() {
        if (_instance == null) {
            _instance = new JavaStringCompiler();
        }
        return _instance;
    }

    public JavaStringCompiler() {
        this.javaCompiler = ToolProvider.getSystemJavaCompiler();
        AssertUtils.notNull(this.javaCompiler, "ToolProvider.getSystemJavaCompiler() failed to execute!");
        StandardJavaFileManager standardFileManager = this.javaCompiler.getStandardFileManager(this.diagnosticsCollector, null, null);
        this.javaFileManager = new StringJavaFileManage(standardFileManager);
        this.javaClassLoader = new StringClassLoader();
    }

    public boolean compiler(List<String> codes) {
        long startTime = System.currentTimeMillis();
        ArrayList<StringJavaFileObject> files = new ArrayList<StringJavaFileObject>();
        for (String code : codes) {
            files.add(new StringJavaFileObject(JavaStringCompiler.getFullClassName(code), code));
        }
        boolean is_ok = this.javaCompiler.getTask(null, this.javaFileManager, this.diagnosticsCollector, null, null, files).call();
        System.out.println(" compiler time::" + (System.currentTimeMillis() - startTime) + "ms");
        return is_ok;
    }

    public String getCompilerMessage() {
        StringBuilder sb = StringUtils.borrowBuilder();
        for (Diagnostic<JavaFileObject> diagnostic : this.diagnosticsCollector.getDiagnostics()) {
            sb.append(diagnostic.toString()).append("\r\n");
        }
        return StringUtils.releaseBuilder(sb);
    }

    public static String getFullClassName(String sourceCode) {
        String className = "";
        Pattern pattern = Pattern.compile("package\\s+(.*?);");
        Matcher matcher = pattern.matcher(sourceCode);
        if (matcher.find()) {
            className = matcher.group(1).trim() + ".";
        }
        if ((matcher = (pattern = Pattern.compile("class\\s+(.*?)\\{")).matcher(sourceCode)).find()) {
            className = className + matcher.group(1).trim();
        }
        return className;
    }

    public void loadClassAll(boolean instantiation) {
        this.javaFileMap.forEach((k, v) -> {
            try {
                Class<?> cls = this.javaClassLoader.findClass((String)k);
                if (instantiation && cls != null) {
                    cls.newInstance();
                }
                System.out.println("String class loaded::" + k);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        });
    }

    private class StringClassLoader
    extends ClassLoader {
        private StringClassLoader() {
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            ByteJavaFileObject fileObject = (ByteJavaFileObject)JavaStringCompiler.this.javaFileMap.get(name);
            if (fileObject != null) {
                byte[] bytes = fileObject.getCompiledBytes();
                return this.defineClass(name, bytes, 0, bytes.length);
            }
            try {
                return ClassLoader.getSystemClassLoader().loadClass(name);
            }
            catch (Exception e) {
                return super.findClass(name);
            }
        }
    }

    private class StringJavaFileManage
    extends ForwardingJavaFileManager {
        StringJavaFileManage(JavaFileManager fileManager) {
            super(fileManager);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            ByteJavaFileObject javaFileObject = new ByteJavaFileObject(className, kind);
            JavaStringCompiler.this.javaFileMap.put(className, javaFileObject);
            return javaFileObject;
        }
    }

    private class ByteJavaFileObject
    extends SimpleJavaFileObject {
        private ByteArrayOutputStream outPutStream;

        public ByteJavaFileObject(String className, JavaFileObject.Kind kind) {
            super(URI.create("string:///" + className.replaceAll("\\.", "/") + JavaFileObject.Kind.SOURCE.extension), kind);
        }

        @Override
        public OutputStream openOutputStream() {
            this.outPutStream = new ByteArrayOutputStream();
            return this.outPutStream;
        }

        public byte[] getCompiledBytes() {
            return this.outPutStream.toByteArray();
        }
    }

    private class StringJavaFileObject
    extends SimpleJavaFileObject {
        private String contents;

        public StringJavaFileObject(String className, String contents) {
            super(URI.create("string:///" + className.replaceAll("\\.", "/") + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.contents = contents;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.contents;
        }
    }
}

