/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.wrap;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.noear.weed.DataItem;
import org.noear.weed.WeedConfig;
import org.noear.weed.annotation.Table;
import org.noear.weed.ext.Act2;
import org.noear.weed.wrap.FieldWrap;

public class ClassWrap {
    private static Map<Class<?>, ClassWrap> _cache = new ConcurrentHashMap();
    public final Class<?> clazz;
    public final List<FieldWrap> fieldWraps;
    public final String tableName;
    private final Map<String, FieldWrap> _fieldWrapMap = new HashMap<String, FieldWrap>();

    public static ClassWrap get(Class<?> clz) {
        ClassWrap clzWrap = _cache.get(clz);
        if (clzWrap == null) {
            clzWrap = new ClassWrap(clz);
            _cache.put(clz, clzWrap);
        }
        return clzWrap;
    }

    protected ClassWrap(Class<?> clz) {
        this.clazz = clz;
        this.fieldWraps = new ArrayList<FieldWrap>();
        ClassWrap.scanAllFields(clz, this._fieldWrapMap::containsKey, (k, fw) -> {
            this.fieldWraps.add((FieldWrap)fw);
            this._fieldWrapMap.put(k.toLowerCase(), (FieldWrap)fw);
        });
        Table ann = clz.getAnnotation(Table.class);
        this.tableName = ann != null ? ann.value() : WeedConfig.namingStrategy.classToTableName(clz);
    }

    private static void scanAllFields(Class<?> clz, Predicate<String> checker, BiConsumer<String, FieldWrap> consumer) {
        if (clz == null) {
            return;
        }
        for (Field f : clz.getDeclaredFields()) {
            int mod = f.getModifiers();
            if (Modifier.isStatic(mod) || checker.test(f.getName())) continue;
            f.setAccessible(true);
            consumer.accept(f.getName(), new FieldWrap(clz, f));
        }
        Class<?> sup = clz.getSuperclass();
        if (sup != Object.class) {
            ClassWrap.scanAllFields(sup, checker, consumer);
        }
    }

    public FieldWrap getFieldWrap(String name) {
        return this._fieldWrapMap.get(name.toLowerCase());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassWrap classWrap = (ClassWrap)o;
        return Objects.equals(this.clazz, classWrap.clazz);
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    public <T> T toEntity(DataItem data) {
        try {
            Object item = this.clazz.newInstance();
            for (FieldWrap fw : this.fieldWraps) {
                if (!data.exists(fw.name)) continue;
                fw.setValue(item, data.get(fw.name));
            }
            return (T)item;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void fromEntity(Object obj, Act2<String, Object> setter) {
        try {
            for (FieldWrap fw : this.fieldWraps) {
                if (fw.exclude) continue;
                setter.run(fw.name, fw.getValue(obj));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

