/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.dialect;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.noear.weed.DbContext;
import org.noear.weed.GetHandler;
import org.noear.weed.IDataItem;
import org.noear.weed.SQLBuilder;
import org.noear.weed.ext.Fun1;
import org.noear.weed.utils.StringUtils;

public interface DbDialect {
    default public Object preChange(Object val) throws SQLException {
        return val;
    }

    default public String preReview(String code) {
        return code;
    }

    default public ResultSet getTables(DatabaseMetaData md, String catalog, String schema) throws SQLException {
        return md.getTables(catalog, schema, null, new String[]{"TABLE", "VIEW"});
    }

    default public boolean supportsVariablePaging() {
        return false;
    }

    default public boolean excludeFormat(String str) {
        return str.startsWith("`") || str.indexOf(".") > 0;
    }

    default public String schemaFormat(String name) {
        return name;
    }

    default public String tableFormat(String name) {
        return "`" + name + "`";
    }

    default public String columnFormat(String name) {
        return "`" + name + "`";
    }

    default public void selectPage(DbContext ctx, String table1, SQLBuilder sqlB, StringBuilder orderBy, int start, int size) {
        sqlB.insert(0, (Object)"SELECT ");
        if (orderBy != null) {
            sqlB.append(orderBy);
        }
        if (this.supportsVariablePaging()) {
            sqlB.append(" LIMIT ?,?");
            sqlB.paramS.add(start);
            sqlB.paramS.add(size);
        } else {
            sqlB.append(" LIMIT ").append(start).append(",").append(size);
        }
    }

    default public void selectTop(DbContext ctx, String table1, SQLBuilder sqlB, StringBuilder orderBy, int size) {
        sqlB.insert(0, (Object)"SELECT ");
        if (orderBy != null) {
            sqlB.append(orderBy);
        }
        if (this.supportsVariablePaging()) {
            sqlB.append(" LIMIT ?");
            sqlB.paramS.add(size);
        } else {
            sqlB.append(" LIMIT ").append(size);
        }
    }

    default public <T extends GetHandler> boolean insertList(DbContext ctx, String table1, SQLBuilder sqlB, Fun1<Boolean, String> isSqlExpr, IDataItem cols, Collection<T> valuesList) {
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuilder sb = StringUtils.borrowBuilder();
        sb.append(" INSERT INTO ").append(table1).append(" (");
        for (String key : cols.keys()) {
            sb.append(ctx.formater().formatColumn(key)).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(") ");
        sb.append("VALUES");
        int sb_len = sb.length();
        for (GetHandler item : valuesList) {
            sb.append("(");
            for (String key : cols.keys()) {
                Object val = item.get(key);
                if (val == null) {
                    sb.append("null,");
                    continue;
                }
                if (val instanceof String) {
                    String val2 = (String)val;
                    if (isSqlExpr.run(val2).booleanValue()) {
                        sb.append(val2.substring(1)).append(",");
                        continue;
                    }
                    sb.append("?,");
                    args.add(val);
                    continue;
                }
                sb.append("?,");
                args.add(val);
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("),");
        }
        if (sb_len == sb.length()) {
            return false;
        }
        sb.deleteCharAt(sb.length() - 1);
        sqlB.append(StringUtils.releaseBuilder(sb), args.toArray());
        return true;
    }
}

