/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.noear.weed.Command;
import org.noear.weed.DataItem;
import org.noear.weed.DataList;
import org.noear.weed.DbTran;
import org.noear.weed.IBinder;
import org.noear.weed.Variate;
import org.noear.weed.WeedConfig;

class SQLer {
    private ResultSet rset;
    private PreparedStatement stmt;
    private Connection conn;

    SQLer() {
    }

    private void tryClose() {
        try {
            if (this.rset != null) {
                this.rset.close();
                this.rset = null;
            }
        }
        catch (Exception ex) {
            WeedConfig.runExceptionEvent(null, ex);
        }
        try {
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
        }
        catch (Exception ex) {
            WeedConfig.runExceptionEvent(null, ex);
        }
        try {
            if (this.conn != null) {
                if (this.conn.getAutoCommit()) {
                    this.conn.close();
                }
                this.conn = null;
            }
        }
        catch (Exception ex) {
            WeedConfig.runExceptionEvent(null, ex);
        }
    }

    private Object getObject(Command cmd, String key) throws SQLException {
        return cmd.context.dbDialect().preChange(this.rset.getObject(key));
    }

    private Object getObject(Command cmd, int idx) throws SQLException {
        return cmd.context.dbDialect().preChange(this.rset.getObject(idx));
    }

    public Variate getVariate(Command cmd) throws SQLException {
        if (cmd.context.isCompilationMode) {
            return null;
        }
        try {
            this.rset = this.query(cmd);
            if (this.rset != null && this.rset.next()) {
                Variate variate = new Variate(null, this.getObject(cmd, 1));
                return variate;
            }
            Variate variate = null;
            return variate;
        }
        catch (SQLException ex) {
            WeedConfig.runExceptionEvent(cmd, ex);
            throw ex;
        }
        finally {
            this.tryClose();
        }
    }

    public <T extends IBinder> T getItem(Command cmd, T model) throws SQLException {
        if (cmd.context.isCompilationMode) {
            return null;
        }
        try {
            this.rset = this.query(cmd);
            if (this.rset != null && this.rset.next()) {
                model.bind(key -> {
                    try {
                        return new Variate(key, this.getObject(cmd, key));
                    }
                    catch (SQLException ex) {
                        WeedConfig.runExceptionEvent(cmd, ex);
                        return new Variate(key, null);
                    }
                });
                T t = model;
                return t;
            }
            T t = null;
            return t;
        }
        catch (SQLException ex) {
            WeedConfig.runExceptionEvent(cmd, ex);
            throw ex;
        }
        finally {
            this.tryClose();
        }
    }

    public <T extends IBinder> List<T> getList(Command cmd, T model) throws SQLException {
        if (cmd.context.isCompilationMode) {
            return null;
        }
        try {
            ArrayList<IBinder> arrayList;
            ArrayList<IBinder> list = new ArrayList<IBinder>();
            this.rset = this.query(cmd);
            while (this.rset != null && this.rset.next()) {
                IBinder item = model.clone();
                if (WeedConfig.isDebug && !model.getClass().isInstance(item)) {
                    throw new SQLException(model.getClass() + " clone error(" + item.getClass() + ")");
                }
                item.bind(key -> {
                    try {
                        return new Variate(key, this.getObject(cmd, key));
                    }
                    catch (SQLException ex) {
                        WeedConfig.runExceptionEvent(cmd, ex);
                        return new Variate(key, null);
                    }
                });
                list.add(item);
            }
            if (list.size() > 0) {
                arrayList = list;
                return arrayList;
            }
            arrayList = null;
            return arrayList;
        }
        catch (SQLException ex) {
            WeedConfig.runExceptionEvent(cmd, ex);
            throw ex;
        }
        finally {
            this.tryClose();
        }
    }

    public DataItem getRow(Command cmd) throws SQLException {
        if (cmd.context.isCompilationMode) {
            return null;
        }
        try {
            DataItem row = new DataItem();
            this.rset = this.query(cmd);
            ResultSetMetaData meta = this.rset.getMetaData();
            if (this.rset != null && this.rset.next()) {
                int len = meta.getColumnCount();
                for (int i = 1; i <= len; ++i) {
                    row.set(meta.getColumnLabel(i), this.getObject(cmd, i));
                }
            }
            if (row.count() > 0) {
                DataItem dataItem = row;
                return dataItem;
            }
            DataItem dataItem = null;
            return dataItem;
        }
        catch (SQLException ex) {
            WeedConfig.runExceptionEvent(cmd, ex);
            throw ex;
        }
        finally {
            this.tryClose();
        }
    }

    public DataList getTable(Command cmd) throws SQLException {
        if (cmd.context.isCompilationMode) {
            return null;
        }
        try {
            DataList dataList;
            DataList table = new DataList();
            this.rset = this.query(cmd);
            ResultSetMetaData meta = this.rset.getMetaData();
            while (this.rset != null && this.rset.next()) {
                DataItem row = new DataItem();
                int len = meta.getColumnCount();
                for (int i = 1; i <= len; ++i) {
                    row.set(meta.getColumnLabel(i), this.getObject(cmd, i));
                }
                table.addRow(row);
            }
            if (table.getRowCount() > 0) {
                dataList = table;
                return dataList;
            }
            dataList = null;
            return dataList;
        }
        catch (SQLException ex) {
            WeedConfig.runExceptionEvent(cmd, ex);
            throw ex;
        }
        finally {
            this.tryClose();
        }
    }

    public int execute(Command cmd, DbTran tran) throws SQLException {
        if (cmd.context.isCompilationMode) {
            return 0;
        }
        try {
            if (!this.buildCMD(cmd, false)) {
                int n = -1;
                return n;
            }
            int rst = this.stmt.executeUpdate();
            WeedConfig.runExecuteAftEvent(cmd);
            int n = rst;
            return n;
        }
        catch (SQLException ex) {
            WeedConfig.runExceptionEvent(cmd, ex);
            throw ex;
        }
        finally {
            this.tryClose();
        }
    }

    public long insert(Command cmd, DbTran tran) throws SQLException {
        if (cmd.context.isCompilationMode) {
            return 0L;
        }
        try {
            Object tmp22;
            if (!this.buildCMD(cmd, true)) {
                long l = -1L;
                return l;
            }
            this.stmt.executeUpdate();
            try {
                this.rset = this.stmt.getGeneratedKeys();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            WeedConfig.runExecuteAftEvent(cmd);
            if (this.rset != null && this.rset.next() && (tmp22 = this.getObject(cmd, 1)) instanceof Number) {
                long l = ((Number)tmp22).longValue();
                return l;
            }
            long tmp22 = 0L;
            return tmp22;
        }
        catch (SQLException ex) {
            WeedConfig.runExceptionEvent(cmd, ex);
            throw ex;
        }
        finally {
            this.tryClose();
        }
    }

    private ResultSet query(Command cmd) throws SQLException {
        if (!this.buildCMD(cmd, false)) {
            return null;
        }
        ResultSet rst = this.stmt.executeQuery();
        WeedConfig.runExecuteAftEvent(cmd);
        return rst;
    }

    private boolean buildCMD(Command cmd, boolean isInsert) throws SQLException {
        if (!WeedConfig.runExecuteBefEvent(cmd)) {
            return false;
        }
        this.conn = cmd.tran == null ? cmd.context.getConnection() : cmd.tran.getConnection(cmd.context);
        this.stmt = cmd.text.indexOf("{call") >= 0 ? this.conn.prepareCall(cmd.fullText()) : (isInsert ? this.conn.prepareStatement(cmd.fullText(), 1) : this.conn.prepareStatement(cmd.fullText()));
        WeedConfig.runExecuteStmEvent(cmd, this.stmt);
        int idx = 1;
        for (Variate v : cmd.paramS) {
            if (v.getValue() == null) {
                this.stmt.setNull(idx, 12);
            } else {
                this.stmt.setObject(idx, v.getValue());
            }
            ++idx;
        }
        return true;
    }
}

