/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed;

import java.util.HashMap;
import java.util.Map;
import org.noear.weed.IRender;
import org.noear.weed.IStarter;
import org.noear.weed.utils.IOUtils;

public class SQLRenderManager
implements IRender {
    private static SQLRenderManager _global;
    private final Map<String, IRender> _mapping = new HashMap<String, IRender>();
    private IRender _def;

    public static SQLRenderManager global() {
        if (_global == null) {
            _global = new SQLRenderManager();
            _global.init();
        }
        return _global;
    }

    public void mapping(String suffix, IRender render) {
        this._def = render;
        this._mapping.put(suffix, render);
        System.out.println("Weed3:: sql render: " + suffix + "=" + render.getClass().getSimpleName());
    }

    public void init() {
        String packname = "org.noear.weed.render";
        IStarter tmp = (IStarter)IOUtils.loadEntity(packname + ".freemarker.StarterImp");
        if (tmp != null) {
            tmp.start();
        }
        if ((tmp = (IStarter)IOUtils.loadEntity(packname + ".beetl.StarterImp")) != null) {
            tmp.start();
        }
        if ((tmp = (IStarter)IOUtils.loadEntity(packname + ".enjoy.StarterImp")) != null) {
            tmp.start();
        }
        if ((tmp = (IStarter)IOUtils.loadEntity(packname + ".velocity.StarterImp")) != null) {
            tmp.start();
        }
    }

    @Override
    public String render(String path, Map<String, Object> args) throws Throwable {
        if (this._def == null) {
            throw new RuntimeException("Weed3:Missing sql render");
        }
        for (Map.Entry<String, IRender> kv : this._mapping.entrySet()) {
            if (!path.endsWith(kv.getKey())) continue;
            return kv.getValue().render(path, args);
        }
        return this._def.render(path, args);
    }
}

