/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.noear.weed.DbTran;
import org.noear.weed.WeedConfig;
import org.noear.weed.ext.Act1Ex;

public class DbTranQueue {
    private List<DbTran> queue = new ArrayList<DbTran>();
    public Object result;
    private boolean _isSucceed = false;

    public boolean isSucceed() {
        return this._isSucceed;
    }

    protected void add(DbTran tran) {
        this.queue.add(tran);
    }

    private void commit() throws SQLException {
        for (DbTran tran : this.queue) {
            tran.commit(true);
        }
    }

    protected void rollback(boolean isQueue) throws SQLException {
        this.doRollback();
        if (!isQueue) {
            this.close();
        }
    }

    private void doRollback() {
        int len = this.queue.size();
        for (int i = len - 1; i > -1; --i) {
            DbTran tran = this.queue.get(i);
            try {
                tran.rollback(true);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void close() throws SQLException {
        for (DbTran tran : this.queue) {
            try {
                tran.close(true);
            }
            catch (Throwable ex) {
                WeedConfig.runExceptionEvent(null, ex);
            }
        }
    }

    public DbTranQueue execute(Act1Ex<DbTranQueue, Throwable> handler) throws SQLException {
        try {
            handler.run(this);
            this.commit();
            this._isSucceed = true;
        }
        catch (Throwable ex) {
            this._isSucceed = false;
            this.rollback(true);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            throw new RuntimeException(ex);
        }
        finally {
            this.close();
        }
        return this;
    }

    public void complete() throws SQLException {
        try {
            this.commit();
            this._isSucceed = true;
        }
        catch (Throwable ex) {
            this._isSucceed = false;
            this.rollback(true);
            throw ex;
        }
        finally {
            this.close();
        }
    }
}

