/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.noear.weed.DbContext;
import org.noear.weed.DbTranQueue;
import org.noear.weed.DbTranUtil;
import org.noear.weed.ext.Act1Ex;

public class DbTran {
    private final Map<DataSource, Connection> conMap = new HashMap<DataSource, Connection>();
    private DbTranQueue queue;
    private Act1Ex<DbTran, Throwable> _handler = null;
    private DbContext _context = null;
    public Object result;
    private boolean _isSucceed = false;

    public boolean isSucceed() {
        return this._isSucceed;
    }

    public DbContext db() {
        return this._context;
    }

    public Connection getConnection(DbContext db) throws SQLException {
        return this.getConnection(db.dataSource());
    }

    public Connection getConnection(DataSource ds) throws SQLException {
        if (this.conMap.containsKey(ds)) {
            return this.conMap.get(ds);
        }
        Connection con = ds.getConnection();
        con.setAutoCommit(false);
        this.conMap.putIfAbsent(ds, con);
        return con;
    }

    public DbTran join(DbTranQueue queue) {
        if (queue != null) {
            this.queue = queue;
            queue.add(this);
        }
        return this;
    }

    public DbTran(DbContext context) {
        this._context = context;
    }

    public DbTran execute(Act1Ex<DbTran, Throwable> handler) throws SQLException {
        DbTran tranTmp = DbTranUtil.current();
        try {
            DbTranUtil.currentSet(this);
            handler.run(this);
            this.commit(false);
            this._isSucceed = true;
        }
        catch (Throwable ex) {
            this._isSucceed = false;
            if (this.queue == null) {
                this.rollback(false);
            } else {
                this.queue.rollback(false);
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            throw new RuntimeException(ex);
        }
        finally {
            DbTranUtil.currentRemove();
            this.close(false);
            if (tranTmp != null) {
                DbTranUtil.currentSet(tranTmp);
            }
        }
        return this;
    }

    public DbTran execute() throws Throwable {
        return this.execute(this._handler);
    }

    public DbTran action(Act1Ex<DbTran, Throwable> handler) {
        this._handler = handler;
        return this;
    }

    protected void rollback(boolean isQueue) throws SQLException {
        if (this.queue == null || isQueue) {
            for (Map.Entry<DataSource, Connection> kv : this.conMap.entrySet()) {
                kv.getValue().rollback();
            }
        }
    }

    protected void commit(boolean isQueue) throws SQLException {
        if (this.queue == null || isQueue) {
            for (Map.Entry<DataSource, Connection> kv : this.conMap.entrySet()) {
                kv.getValue().commit();
            }
        }
    }

    protected void close(boolean isQueue) throws SQLException {
        if (this.queue == null || isQueue) {
            for (Map.Entry<DataSource, Connection> kv : this.conMap.entrySet()) {
                kv.getValue().setAutoCommit(true);
                kv.getValue().close();
            }
        }
    }
}

