/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.noear.weed.DataItem;
import org.noear.weed.DbContext;
import org.noear.weed.DbQuery;
import org.noear.weed.DbTran;
import org.noear.weed.GetHandler;
import org.noear.weed.IDataItem;
import org.noear.weed.IQuery;
import org.noear.weed.SQLBuilder;
import org.noear.weed.SelectQ;
import org.noear.weed.WeedConfig;
import org.noear.weed.WhereBase;
import org.noear.weed.cache.CacheUsing;
import org.noear.weed.cache.ICacheController;
import org.noear.weed.cache.ICacheService;
import org.noear.weed.ext.Act1;
import org.noear.weed.ext.Act2;
import org.noear.weed.utils.StringUtils;

public class DbTableQueryBase<T extends DbTableQueryBase>
extends WhereBase<T>
implements ICacheController<DbTableQueryBase> {
    String _table_raw;
    String _table;
    SQLBuilder _builder_bef;
    int _isLog = 0;
    protected int limit_start;
    protected int limit_size;
    protected int limit_top = 0;
    String _hint = null;
    protected DbTran _tran = null;
    private boolean _usingNull = WeedConfig.isUsingValueNull;
    private boolean _usingExpression = WeedConfig.isUsingValueExpression;
    protected CacheUsing _cache = null;

    public DbTableQueryBase(DbContext context) {
        super(context);
        this._builder_bef = new SQLBuilder();
    }

    public T log(boolean isLog) {
        this._isLog = isLog ? 1 : -1;
        return (T)this;
    }

    @Deprecated
    public T expre(Act1<T> action) {
        action.run(this);
        return (T)this;
    }

    public T build(Act1<T> builder) {
        builder.run(this);
        return (T)this;
    }

    protected T table(String table) {
        if (table.startsWith("#")) {
            this._table_raw = this._table = table.substring(1);
        } else {
            this._table_raw = table;
            this._table = table.indexOf(46) > 0 ? table : (WeedConfig.isUsingSchemaPrefix && this._context.schema() != null ? this.fmtObject(this._context.schema() + "." + table) : this.fmtObject(table));
        }
        return (T)this;
    }

    public T with(String name, String code, Object ... args) {
        if (this._builder_bef.length() < 6) {
            this._builder_bef.append(" WITH ");
        } else {
            this._builder_bef.append(",");
        }
        this._builder_bef.append(this.fmtColumn(name)).append(" AS (").append(code, args).append(") ");
        return (T)this;
    }

    public T with(String name, SelectQ select) {
        if (this._builder_bef.length() < 6) {
            this._builder_bef.append(" WITH ");
        } else {
            this._builder_bef.append(",");
        }
        this._builder_bef.append(this.fmtColumn(name)).append(" AS (").append(select).append(") ");
        return (T)this;
    }

    public T from(String table) {
        this._builder.append(" FROM ").append(this.fmtObject(table));
        return (T)this;
    }

    private T join(String style, String table) {
        if (table.startsWith("#")) {
            this._builder.append(style).append(table.substring(1));
        } else if (WeedConfig.isUsingSchemaPrefix && this._context.schema() != null) {
            this._builder.append(style).append(this.fmtObject(this._context.schema() + "." + table));
        } else {
            this._builder.append(style).append(this.fmtObject(table));
        }
        return (T)this;
    }

    public T innerJoin(String table) {
        return this.join(" INNER JOIN ", table);
    }

    public T leftJoin(String table) {
        return this.join(" LEFT JOIN ", table);
    }

    public T rightJoin(String table) {
        return this.join(" RIGHT JOIN ", table);
    }

    public T append(String code, Object ... args) {
        this._builder.append(code, args);
        return (T)this;
    }

    public T on(String code) {
        this._builder.append(" ON ").append(code);
        return (T)this;
    }

    public T onEq(String column1, String column2) {
        this._builder.append(" ON ").append(this.fmtColumn(column1)).append("=").append(this.fmtColumn(column2));
        return (T)this;
    }

    public long insert(Act1<IDataItem> dataBuilder) throws SQLException {
        DataItem item = new DataItem();
        dataBuilder.run(item);
        return this.insert(item);
    }

    public long insert(IDataItem data) throws SQLException {
        if (data == null || data.count() == 0) {
            return 0L;
        }
        ArrayList args = new ArrayList();
        StringBuilder sb = StringUtils.borrowBuilder();
        sb.append(" INSERT INTO ").append(this._table).append(" (");
        data.forEach((key, value) -> {
            if (value == null && !this._usingNull) {
                return;
            }
            sb.append(this.fmtColumn((String)key)).append(",");
        });
        sb.deleteCharAt(sb.length() - 1);
        sb.append(") ");
        sb.append("VALUES");
        sb.append("(");
        data.forEach((key, value) -> {
            if (value == null) {
                if (this._usingNull) {
                    sb.append("null,");
                }
            } else if (value instanceof String) {
                String val2 = (String)value;
                if (this.isSqlExpr(val2)) {
                    sb.append(val2.substring(1)).append(",");
                } else {
                    sb.append("?,");
                    args.add(value);
                }
            } else {
                sb.append("?,");
                args.add(value);
            }
        });
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        this._builder.clear();
        this._builder.append(StringUtils.releaseBuilder(sb), args.toArray());
        return this.compile().insert();
    }

    public long insertBy(IDataItem data, String conditionFields) throws SQLException {
        String[] ff = conditionFields.split(",");
        if (ff.length == 0) {
            throw new RuntimeException("Please enter constraints");
        }
        this.where("1=1", new Object[0]);
        for (String f : ff) {
            this.andEq(f, data.get(f));
        }
        if (this.exists()) {
            return 0L;
        }
        return this.insert(data);
    }

    public boolean insertList(List<DataItem> valuesList) throws SQLException {
        if (valuesList == null) {
            return false;
        }
        return this.insertList(valuesList.get(0), valuesList);
    }

    public <T> boolean insertList(Collection<T> valuesList, Act2<T, DataItem> dataBuilder) throws SQLException {
        ArrayList<DataItem> list2 = new ArrayList<DataItem>();
        for (T values : valuesList) {
            DataItem item = new DataItem();
            dataBuilder.run(values, item);
            list2.add(item);
        }
        if (list2.size() > 0) {
            return this.insertList((IDataItem)list2.get(0), list2);
        }
        return false;
    }

    protected <T extends GetHandler> boolean insertList(IDataItem cols, Collection<T> valuesList) throws SQLException {
        if (valuesList == null || valuesList.size() == 0) {
            return false;
        }
        if (cols == null || cols.count() == 0) {
            return false;
        }
        this._context.dbDialect().insertList(this._context, this._table, this._builder, this::isSqlExpr, cols, valuesList);
        return this.compile().execute() > 0;
    }

    @Deprecated
    public void updateExt(IDataItem data, String conditionFields) throws SQLException {
        this.upsertBy(data, conditionFields);
    }

    @Deprecated
    public long upsert(IDataItem data, String conditionFields) throws SQLException {
        return this.upsertBy(data, conditionFields);
    }

    public long upsertBy(IDataItem data, String conditionFields) throws SQLException {
        String[] ff = conditionFields.split(",");
        if (ff.length == 0) {
            throw new RuntimeException("Please enter constraints");
        }
        this.where("1=1", new Object[0]);
        for (String f : ff) {
            this.andEq(f, data.get(f));
        }
        if (this.exists()) {
            for (String f : ff) {
                data.remove(f);
            }
            return this.update(data);
        }
        return this.insert(data);
    }

    public int update(Act1<IDataItem> dataBuilder) throws SQLException {
        DataItem item = new DataItem();
        dataBuilder.run(item);
        return this.update(item);
    }

    public int update(IDataItem data) throws SQLException {
        if (data == null || data.count() == 0) {
            return 0;
        }
        ArrayList args = new ArrayList();
        StringBuilder sb = StringUtils.borrowBuilder();
        sb.append("UPDATE ").append(this._table).append(" SET ");
        data.forEach((key, value) -> {
            if (value == null) {
                if (this._usingNull) {
                    sb.append(this.fmtColumn((String)key)).append("=null,");
                }
                return;
            }
            if (value instanceof String) {
                String val2 = (String)value;
                if (this.isSqlExpr(val2)) {
                    sb.append(this.fmtColumn((String)key)).append("=").append(val2.substring(1)).append(",");
                } else {
                    sb.append(this.fmtColumn((String)key)).append("=?,");
                    args.add(value);
                }
            } else {
                sb.append(this.fmtColumn((String)key)).append("=?,");
                args.add(value);
            }
        });
        sb.deleteCharAt(sb.length() - 1);
        this._builder.backup();
        this._builder.insert(StringUtils.releaseBuilder(sb), args.toArray());
        if (WeedConfig.isUpdateMustConditional && this._builder.indexOf(" WHERE ") < 0) {
            throw new RuntimeException("Lack of update condition!!!");
        }
        int rst = this.compile().execute();
        this._builder.restore();
        return rst;
    }

    public int delete() throws SQLException {
        StringBuilder sb = StringUtils.borrowBuilder();
        sb.append("DELETE ");
        if (this._builder.indexOf(" FROM ") < 0) {
            sb.append(" FROM ").append(this._table);
        } else {
            sb.append(this._table);
        }
        this._builder.insert(StringUtils.releaseBuilder(sb), new Object[0]);
        if (WeedConfig.isDeleteMustConditional && this._builder.indexOf(" WHERE ") < 0) {
            throw new RuntimeException("Lack of delete condition!!!");
        }
        return this.compile().execute();
    }

    public T limit(int start, int size) {
        this.limit_start = start;
        this.limit_size = size;
        return (T)this;
    }

    public T limit(int size) {
        this.limit_top = size;
        return (T)this;
    }

    public T paging(int start, int size) {
        this.limit_start = start;
        this.limit_size = size;
        return (T)this;
    }

    public T top(int size) {
        this.limit_top = size;
        return (T)this;
    }

    public boolean exists() throws SQLException {
        int bak = this.limit_top;
        this.limit(1);
        this.select_do(" 1 ", false);
        this.limit(bak);
        DbQuery rst = this.compile();
        if (this._cache != null) {
            rst.cache(this._cache);
        }
        this._builder.restore();
        return rst.getValue() != null;
    }

    public T hint(String hint) {
        this._hint = hint;
        return (T)this;
    }

    public long count() throws SQLException {
        return this.count("COUNT(*)");
    }

    public long count(String code) throws SQLException {
        return this.select(code).getVariate().longValue(0L);
    }

    public IQuery select(String columns) {
        this.select_do(columns, true);
        DbQuery rst = this.compile();
        if (this._cache != null) {
            rst.cache(this._cache);
        }
        this._builder.restore();
        return rst;
    }

    public SelectQ selectQ(String columns) {
        this.select_do(columns, true);
        return new SelectQ(this._builder);
    }

    private void select_do(String columns, boolean doFormat) {
        this._builder.backup();
        StringBuilder sb = new StringBuilder(this._builder.builder.length() + 100);
        sb.append(" ");
        if (doFormat) {
            sb.append(this.fmtMutColumns(columns)).append(" FROM ").append(this._table);
        } else {
            sb.append(columns).append(" FROM ").append(this._table);
        }
        sb.append((CharSequence)this._builder.builder);
        this._builder.builder = sb;
        if (this.limit_top > 0) {
            this._context.dbDialect().selectTop(this._context, this._table_raw, this._builder, this._orderBy, this.limit_top);
        } else if (this.limit_size > 0) {
            this._context.dbDialect().selectPage(this._context, this._table_raw, this._builder, this._orderBy, this.limit_start, this.limit_size);
        } else {
            this._builder.insert(0, (Object)"SELECT ");
            if (this._orderBy != null) {
                this._builder.append(this._orderBy);
            }
        }
        if (this._hint != null) {
            sb.append(this._hint);
            this._builder.insert(0, (Object)this._hint);
        }
        if (this._builder_bef.length() > 0) {
            this._builder.insert(this._builder_bef);
        }
    }

    public T tran(DbTran transaction) {
        this._tran = transaction;
        return (T)this;
    }

    public T tran() {
        this._tran = this._context.tran();
        return (T)this;
    }

    private DbQuery compile() {
        DbQuery temp = new DbQuery(this._context).sql(this._builder);
        this._builder.clear();
        if (this._tran != null) {
            temp.tran(this._tran);
        }
        return (DbQuery)temp.onCommandBuilt(cmd -> {
            cmd.isLog = this._isLog;
            cmd.tag = this._table;
        });
    }

    public T usingNull(boolean isUsing) {
        this._usingNull = isUsing;
        return (T)this;
    }

    public T usingExpr(boolean isUsing) {
        this._usingExpression = isUsing;
        return (T)this;
    }

    private boolean isSqlExpr(String txt) {
        if (!this._usingExpression) {
            return false;
        }
        return txt.startsWith("$") && txt.indexOf(" ") < 0 && txt.length() < 100;
    }

    @Override
    public T caching(ICacheService service) {
        this._cache = new CacheUsing(service);
        return (T)this;
    }

    @Override
    public T usingCache(boolean isCache) {
        this._cache.usingCache(isCache);
        return (T)this;
    }

    @Override
    public T usingCache(int seconds) {
        this._cache.usingCache(seconds);
        return (T)this;
    }

    @Override
    public T cacheTag(String tag) {
        this._cache.cacheTag(tag);
        return (T)this;
    }
}

