/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed;

import java.sql.SQLException;
import java.util.Map;
import org.noear.weed.Command;
import org.noear.weed.DbContext;
import org.noear.weed.DbProcedure;
import org.noear.weed.Variate;
import org.noear.weed.WeedConfig;
import org.noear.weed.utils.StringUtils;

public class DbStoredProcedure
extends DbProcedure {
    public DbStoredProcedure(DbContext context) {
        super(context);
    }

    protected DbStoredProcedure call(String storedProcedure) {
        this.commandText = storedProcedure;
        this.paramS.clear();
        this._weedKey = null;
        return this;
    }

    @Override
    public DbProcedure set(String param, Object value) {
        this.doSet(param, value);
        return this;
    }

    @Override
    public DbProcedure setMap(Map<String, Object> map) {
        throw new RuntimeException("DbStoredProcedure not support setMap");
    }

    @Override
    public DbProcedure setEntity(Object obj) {
        throw new RuntimeException("DbStoredProcedure not support setEntity");
    }

    @Override
    protected String getCommandID() {
        this.tryLazyload();
        return this.commandText;
    }

    @Override
    protected Command getCommand() {
        this.tryLazyload();
        Command cmd = new Command(this.context, this._tran);
        cmd.key = this.getCommandID();
        cmd.paramS = this.paramS;
        StringBuilder sb = StringUtils.borrowBuilder();
        sb.append("{call ");
        if (WeedConfig.isUsingSchemaPrefix && this.context.schema() != null) {
            sb.append(this.context.schema()).append(".");
        }
        sb.append(this.commandText.trim());
        if (this.paramS.size() > 0) {
            sb.append('(');
            for (Variate p : this.paramS) {
                sb.append("?,");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(')');
        }
        sb.append('}');
        cmd.text = StringUtils.releaseBuilder(sb);
        this.runCommandBuiltEvent(cmd);
        return cmd;
    }

    @Override
    public int execute() throws SQLException {
        this.tryLazyload();
        return super.execute();
    }
}

