/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.noear.weed.WeedConfig;
import org.noear.weed.dialect.DbDb2Dialect;
import org.noear.weed.dialect.DbDialect;
import org.noear.weed.dialect.DbH2Dialect;
import org.noear.weed.dialect.DbMySQLDialect;
import org.noear.weed.dialect.DbOracleDialect;
import org.noear.weed.dialect.DbPostgreSQLDialect;
import org.noear.weed.dialect.DbSQLServerDialect;
import org.noear.weed.dialect.DbSQLiteDialect;
import org.noear.weed.wrap.ColumnWrap;
import org.noear.weed.wrap.DbType;
import org.noear.weed.wrap.TableWrap;

class DbContextMetaData {
    protected String _schema;
    protected String _catalog;
    private transient Map<String, TableWrap> _tables = new HashMap<String, TableWrap>();
    private transient DbType _dbType = DbType.Unknown;
    private transient DbDialect _dbDialect;
    private transient DataSource __dataSource;

    DbContextMetaData() {
    }

    public DataSource dataSource() {
        return this.__dataSource;
    }

    protected void dataSourceDoSet(DataSource ds) {
        this.__dataSource = ds;
    }

    public Connection getConnection() throws SQLException {
        return WeedConfig.connectionFactory.getConnection(this.dataSource());
    }

    public DbType dbType() {
        this.initMetaData();
        return this._dbType;
    }

    public DbDialect dbDialect() {
        this.initMetaData();
        return this._dbDialect;
    }

    public void dbDialectSet(DbDialect adapter) {
        this.initMetaData();
        this._dbDialect = adapter;
    }

    public Collection<TableWrap> dbTables() {
        this.initMetaData();
        return this._tables.values();
    }

    public TableWrap dbTable(String tableName) {
        this.initMetaData();
        for (Map.Entry<String, TableWrap> kv : this._tables.entrySet()) {
            if (!tableName.equalsIgnoreCase(kv.getKey())) continue;
            return kv.getValue();
        }
        return null;
    }

    public String dbTablePk1(String tableName) {
        TableWrap tw = this.dbTable(tableName);
        return tw == null ? null : tw.getPk1();
    }

    public void refreshMeta() {
        this.initMetaDataDo();
    }

    private void initMetaData() {
        if (this._dbDialect != null) {
            return;
        }
        this.initMetaDataDo();
    }

    private synchronized void initMetaDataDo() {
        if (this._schema != null) {
            System.out.println("Weed3::" + this._schema);
        }
        System.out.println("Weed3::Init metadata");
        Connection conn = null;
        try {
            System.out.println("Weed3::Start testing database connectivity...");
            conn = this.getConnection();
            DatabaseMetaData md = conn.getMetaData();
            System.out.println("Weed3::The connection is successful");
            if (this._dbDialect == null) {
                this.setDatabaseType(md.getDatabaseProductName());
                this.setSchema(conn);
            }
            this.setTables(md);
        }
        catch (Throwable ex) {
            System.out.println("Weed3::The connection error");
            ex.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void setDatabaseType(String driverName) {
        if (driverName != null) {
            String pn = driverName.toLowerCase().replace(" ", "");
            if (pn.indexOf("mysql") >= 0) {
                this._dbType = DbType.MySQL;
                this._dbDialect = new DbMySQLDialect();
            } else if (pn.indexOf("mariadb") >= 0) {
                this._dbType = DbType.MariaDB;
                this._dbDialect = new DbMySQLDialect();
            } else if (pn.indexOf("sqlserver") >= 0) {
                this._dbType = DbType.SQLServer;
                this._dbDialect = new DbSQLServerDialect();
            } else if (pn.indexOf("oracle") >= 0) {
                this._dbType = DbType.Oracle;
                this._dbDialect = new DbOracleDialect();
            } else if (pn.indexOf("postgresql") >= 0) {
                this._dbType = DbType.PostgreSQL;
                this._dbDialect = new DbPostgreSQLDialect();
            } else if (pn.indexOf("db2") >= 0) {
                this._dbType = DbType.DB2;
                this._dbDialect = new DbDb2Dialect();
            } else if (pn.indexOf("sqlite") >= 0) {
                this._dbType = DbType.SQLite;
                this._dbDialect = new DbSQLiteDialect();
            } else if (pn.indexOf("h2") >= 0) {
                this._dbType = DbType.H2;
                this._dbDialect = new DbH2Dialect();
            } else {
                this._dbDialect = new DbMySQLDialect();
            }
        } else {
            this._dbType = DbType.MySQL;
            this._dbDialect = new DbMySQLDialect();
        }
    }

    private void setSchema(Connection conn) throws SQLException {
        try {
            this._catalog = conn.getCatalog();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (this._schema != null) {
            return;
        }
        try {
            this._schema = conn.getSchema();
        }
        catch (Throwable e) {
            switch (this._dbType) {
                case PostgreSQL: {
                    this._schema = "public";
                    break;
                }
                case H2: {
                    this._schema = "PUBLIC";
                    break;
                }
                case SQLServer: {
                    this._schema = "dbo";
                }
                case Oracle: {
                    this._schema = conn.getMetaData().getUserName();
                }
            }
        }
    }

    private void setTables(DatabaseMetaData md) throws SQLException {
        TableWrap tWrap;
        ResultSet rs = null;
        rs = this.dbDialect().getTables(md, this._catalog, this._schema);
        while (rs.next()) {
            String name = rs.getString("TABLE_NAME");
            String remarks = rs.getString("REMARKS");
            tWrap = new TableWrap(name, remarks);
            this._tables.put(name, tWrap);
        }
        rs.close();
        for (String key : this._tables.keySet()) {
            tWrap = this._tables.get(key);
            rs = md.getColumns(this._catalog, this._schema, key, "%");
            while (rs.next()) {
                int digit = 0;
                Object o = rs.getObject("DECIMAL_DIGITS");
                if (o != null) {
                    digit = ((Number)o).intValue();
                }
                ColumnWrap cw = new ColumnWrap(rs.getString("COLUMN_NAME"), rs.getInt("DATA_TYPE"), rs.getInt("COLUMN_SIZE"), digit, rs.getString("REMARKS"));
                tWrap.addColumn(cw);
            }
            rs.close();
            rs = md.getPrimaryKeys(this._catalog, this._schema, key);
            while (rs.next()) {
                String idName = rs.getString("COLUMN_NAME");
                tWrap.addPk(idName);
            }
            rs.close();
        }
    }
}

