/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.noear.weed.Command;
import org.noear.weed.DataItem;
import org.noear.weed.DataList;
import org.noear.weed.DbContext;
import org.noear.weed.DbTran;
import org.noear.weed.DbTranQueue;
import org.noear.weed.IBinder;
import org.noear.weed.IQuery;
import org.noear.weed.IWeedKey;
import org.noear.weed.SQLer;
import org.noear.weed.VarHolder;
import org.noear.weed.Variate;
import org.noear.weed.WeedConfig;
import org.noear.weed.cache.CacheUsing;
import org.noear.weed.cache.ICacheService;
import org.noear.weed.ext.Act1;
import org.noear.weed.ext.Act2;
import org.noear.weed.utils.StringUtils;

public abstract class DbAccess<T extends DbAccess>
implements IWeedKey,
IQuery,
Serializable {
    public String commandText = null;
    public DbContext context;
    public List<Variate> paramS = new ArrayList<Variate>();
    private Act1<Command> onCommandExpr = null;
    protected String _weedKey;
    private int _isLog;
    protected DbTran _tran = null;
    protected CacheUsing _cache = null;

    protected abstract Command getCommand() throws SQLException;

    protected abstract String getCommandID();

    public T onCommandBuilt(Act1<Command> expr) {
        this.onCommandExpr = expr;
        return (T)this;
    }

    protected void runCommandBuiltEvent(Command cmd) {
        cmd.isLog = this._isLog;
        if (this.onCommandExpr != null) {
            this.onCommandExpr.run(cmd);
        }
        WeedConfig.runCommandBuiltEvent(cmd);
    }

    public DbAccess(DbContext context) {
        this.context = context;
    }

    @Override
    public String getWeedKey() {
        return this.buildWeedKey(this.paramS);
    }

    protected String buildWeedKey(Collection<Variate> args) {
        if (this._weedKey == null) {
            StringBuilder sb = StringUtils.borrowBuilder();
            sb.append(this.getCommandID()).append(":");
            for (Variate p : args) {
                sb.append("_").append(p.getValue());
            }
            this._weedKey = StringUtils.releaseBuilder(sb);
        }
        return this._weedKey;
    }

    protected Variate doGet(String paramName) {
        for (Variate p1 : this.paramS) {
            if (!paramName.equals(p1._name)) continue;
            return p1;
        }
        return null;
    }

    protected Variate doGet(int index) {
        return this.paramS.get(index);
    }

    protected void doSet(String param, Object value) {
        this.paramS.add(new Variate(param, value));
    }

    protected void doSet(Variate value) {
        this.paramS.add(value);
    }

    public T log(boolean isLog) {
        this._isLog = isLog ? 1 : -1;
        return (T)this;
    }

    public long insert() throws SQLException {
        return new SQLer().insert(this.getCommand(), this._tran);
    }

    public int update() throws SQLException {
        return this.execute();
    }

    public int delete() throws SQLException {
        return this.execute();
    }

    public int execute() throws SQLException {
        return new SQLer().execute(this.getCommand(), this._tran);
    }

    @Override
    public long getCount() throws SQLException {
        return this.getValue(0L);
    }

    @Override
    public Object getValue() throws SQLException {
        return this.getVariate(null).getValue();
    }

    @Override
    public <T> T getValue(T def) throws SQLException {
        return this.getVariate(null).value(def);
    }

    @Override
    public Variate getVariate() throws SQLException {
        return this.getVariate(null);
    }

    @Override
    public Variate getVariate(Act2<CacheUsing, Variate> cacheCondition) throws SQLException {
        Variate rst;
        if (this._cache == null) {
            rst = new SQLer().getVariate(this.getCommand());
        } else {
            this._cache.usingCache(cacheCondition);
            rst = this._cache.getEx(this.getWeedKey(), () -> new SQLer().getVariate(this.getCommand()));
        }
        if (rst == null) {
            return new Variate();
        }
        return rst;
    }

    @Override
    public <T extends IBinder> T getItem(T model) throws SQLException {
        return this.getDataItem().toItem(model);
    }

    @Override
    public <T extends IBinder> T getItem(T model, Act2<CacheUsing, T> cacheCondition) throws SQLException {
        if (cacheCondition == null) {
            return this.getItem(model);
        }
        VarHolder _tmp = new VarHolder();
        DataItem item = this.getDataItem((cu, di) -> {
            try {
                _tmp.value = di.toItem(model);
                cacheCondition.run((CacheUsing)cu, (Object)((IBinder)_tmp.value));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
        if (_tmp.value == null) {
            return item.toItem(model);
        }
        return (T)((IBinder)_tmp.value);
    }

    @Override
    public <T extends IBinder> List<T> getList(T model) throws SQLException {
        return this.getDataList().toList(model);
    }

    @Override
    public <T extends IBinder> List<T> getList(T model, Act2<CacheUsing, List<T>> cacheCondition) throws SQLException {
        if (cacheCondition == null) {
            return this.getList(model);
        }
        VarHolder _tmp = new VarHolder();
        DataList list = this.getDataList((cu, dl) -> {
            try {
                _tmp.value = dl.toList(model);
                cacheCondition.run((CacheUsing)cu, (List)_tmp.value);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
        if (_tmp == null) {
            return list.toList(model);
        }
        return (List)_tmp.value;
    }

    @Override
    public <T> List<T> getArray(String column) throws SQLException {
        return this.getDataList().toArray(column);
    }

    @Override
    public <T> List<T> getArray(int columnIndex) throws SQLException {
        return this.getDataList().toArray(columnIndex);
    }

    @Override
    public <T> List<T> getList(Class<T> cls) throws SQLException {
        return this.getDataList().toEntityList(cls);
    }

    @Override
    public <T> List<T> getList(Class<T> cls, Act2<CacheUsing, List<T>> cacheCondition) throws SQLException {
        if (cacheCondition == null) {
            return this.getList(cls);
        }
        VarHolder _tmp = new VarHolder();
        DataList list = this.getDataList((cu, dl) -> {
            try {
                _tmp.value = dl.toEntityList(cls);
                cacheCondition.run((CacheUsing)cu, (List)_tmp.value);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
        if (_tmp.value == null) {
            return list.toEntityList(cls);
        }
        return (List)_tmp.value;
    }

    @Override
    public <T> T getItem(Class<T> cls) throws SQLException {
        return this.getDataItem().toEntity(cls);
    }

    @Override
    public <T> T getItem(Class<T> cls, Act2<CacheUsing, T> cacheCondition) throws SQLException {
        if (cacheCondition == null) {
            return this.getItem(cls);
        }
        VarHolder _tmp = new VarHolder();
        DataItem item = this.getDataItem((cu, di) -> {
            try {
                _tmp.value = di.toEntity(cls);
                cacheCondition.run((CacheUsing)cu, _tmp.value);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
        if (_tmp.value == null) {
            return item.toEntity(cls);
        }
        return _tmp.value;
    }

    @Override
    public DataList getDataList() throws SQLException {
        return this.getDataList(null);
    }

    @Override
    public DataList getDataList(Act2<CacheUsing, DataList> cacheCondition) throws SQLException {
        DataList rst;
        if (this._cache == null) {
            rst = new SQLer().getTable(this.getCommand());
        } else {
            this._cache.usingCache(cacheCondition);
            rst = this._cache.getEx(this.getWeedKey(), () -> new SQLer().getTable(this.getCommand()));
        }
        if (rst == null) {
            return new DataList();
        }
        return rst;
    }

    @Override
    public List<Map<String, Object>> getMapList() throws SQLException {
        return this.getDataList().getMapList();
    }

    @Override
    public DataItem getDataItem() throws SQLException {
        return this.getDataItem(null);
    }

    @Override
    public DataItem getDataItem(Act2<CacheUsing, DataItem> cacheCondition) throws SQLException {
        DataItem rst;
        if (this._cache == null) {
            rst = new SQLer().getRow(this.getCommand());
        } else {
            this._cache.usingCache(cacheCondition);
            rst = this._cache.getEx(this.getWeedKey(), () -> new SQLer().getRow(this.getCommand()));
        }
        if (rst == null) {
            return new DataItem();
        }
        return rst;
    }

    @Override
    public Map<String, Object> getMap() throws SQLException {
        return this.getDataItem().getMap();
    }

    public T tran(DbTran transaction) {
        this._tran = transaction;
        return (T)this;
    }

    public DbTran tran(DbTranQueue queue) {
        this._tran = this.context.tran();
        this._tran.join(queue);
        this._tran.action(tt -> this.execute());
        return this._tran;
    }

    public DbTran tran() {
        this._tran = this.context.tran();
        this._tran.action(tt -> this.execute());
        return this._tran;
    }

    @Override
    public IQuery caching(ICacheService service) {
        this._cache = new CacheUsing(service);
        return this;
    }

    @Override
    public IQuery usingCache(boolean isCache) {
        this._cache.usingCache(isCache);
        return this;
    }

    @Override
    public IQuery usingCache(int seconds) {
        this._cache.usingCache(seconds);
        return this;
    }

    @Override
    public IQuery cacheTag(String tag) {
        this._cache.cacheTag(tag);
        return this;
    }

    protected T cache(CacheUsing cacheUsing) {
        this._cache = cacheUsing;
        return (T)this;
    }
}

