/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.noear.weed.GetHandler;
import org.noear.weed.IBinder;
import org.noear.weed.IDataItem;
import org.noear.weed.Variate;
import org.noear.weed.ext.Act2;
import org.noear.weed.ext.Fun2;
import org.noear.weed.ext.LinkedCaseInsensitiveMap;
import org.noear.weed.utils.EntityUtils;

public class DataItem
implements IDataItem,
Iterable<Map.Entry<String, Object>> {
    Map<String, Object> _data = new LinkedCaseInsensitiveMap<Object>();
    private boolean _isUsingDbNull = false;

    public DataItem() {
    }

    public DataItem(Boolean isUsingDbNull) {
        this._isUsingDbNull = isUsingDbNull;
    }

    @Override
    public int count() {
        return this._data.size();
    }

    @Override
    public void clear() {
        this._data.clear();
    }

    @Override
    public boolean exists(String name) {
        if (name == null) {
            return false;
        }
        return this._data.containsKey(name);
    }

    @Override
    public Set<String> keys() {
        return this._data.keySet();
    }

    @Override
    public DataItem set(String name, Object value) {
        this._data.put(name, value);
        return this;
    }

    @Override
    public DataItem setIf(boolean condition, String name, Object value) {
        if (condition) {
            this.set(name, value);
        }
        return this;
    }

    @Override
    public DataItem setDf(String name, Object value, Object def) {
        if (value == null) {
            this.set(name, def);
        } else {
            this.set(name, value);
        }
        return this;
    }

    @Override
    public Object get(int index) {
        for (String key : this._data.keySet()) {
            if (index == 0) {
                return this.get(key);
            }
            --index;
        }
        return null;
    }

    @Override
    public Object get(String name) {
        return this._data.get(name);
    }

    @Override
    public Variate getVariate(String name) {
        if (this._data.containsKey(name)) {
            return new Variate(name, this.get(name));
        }
        return new Variate(name, null);
    }

    @Override
    public void remove(String name) {
        this._data.remove(name);
    }

    @Override
    public <T extends IBinder> T toItem(T item) {
        item.bind(key -> this.getVariate(key));
        return item;
    }

    @Override
    public short getShort(String name) {
        return (Short)this.get(name);
    }

    @Override
    public int getInt(String name) {
        return ((Number)this.get(name)).intValue();
    }

    @Override
    public long getLong(String name) {
        return ((Number)this.get(name)).longValue();
    }

    @Override
    public double getDouble(String name) {
        return ((Number)this.get(name)).doubleValue();
    }

    @Override
    public float getFloat(String name) {
        return ((Number)this.get(name)).floatValue();
    }

    @Override
    public String getString(String name) {
        return (String)this.get(name);
    }

    @Override
    public boolean getBoolean(String name) {
        return (Boolean)this.get(name);
    }

    @Override
    public Date getDateTime(String name) {
        return (Date)this.get(name);
    }

    @Override
    public void forEach(Act2<String, Object> callback) {
        for (Map.Entry<String, Object> kv : this._data.entrySet()) {
            Object val = kv.getValue();
            if (val == null && this._isUsingDbNull) {
                callback.run(kv.getKey(), "$NULL");
                continue;
            }
            callback.run(kv.getKey(), val);
        }
    }

    public static IDataItem create(IDataItem schema, GetHandler source) {
        DataItem item = new DataItem();
        for (String key : schema.keys()) {
            Object val = source.get(key);
            if (val == null) continue;
            item.set(key, val);
        }
        return item;
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this._data.entrySet().iterator();
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<String, Object>> action) {
        Objects.requireNonNull(action);
        for (Map.Entry<String, Object> entry : this._data.entrySet()) {
            action.accept(entry);
        }
    }

    @Override
    public Spliterator<Map.Entry<String, Object>> spliterator() {
        return this._data.entrySet().spliterator();
    }

    public DataItem setMap(Map<String, Object> data) {
        return this.setMapIf(data, (k, v) -> v != null);
    }

    public DataItem setMapIf(Map<String, Object> data, Fun2<Boolean, String, Object> condition) {
        data.forEach((? super K k, ? super V v) -> {
            if (((Boolean)condition.run((String)k, v)).booleanValue()) {
                this.set((String)k, v);
            }
        });
        return this;
    }

    public DataItem setEntity(Object obj) {
        return this.setEntityIf(obj, (k, v) -> v != null);
    }

    public DataItem setEntityIf(Object obj, Fun2<Boolean, String, Object> condition) {
        EntityUtils.fromEntity(obj, (k, v) -> {
            if (((Boolean)condition.run((String)k, v)).booleanValue()) {
                this.set((String)k, v);
            }
        });
        return this;
    }

    public Map<String, Object> getMap() {
        return this._data;
    }

    @Deprecated
    public void fromEntity(Object obj) {
        EntityUtils.fromEntity(obj, (k, v) -> this.set((String)k, v));
    }

    public <T> T toEntity(Class<T> cls) {
        return EntityUtils.toEntity(cls, this);
    }
}

