/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.weed.DbContext;
import org.noear.weed.DbTran;
import org.noear.weed.DbTranUtil;
import org.noear.weed.Variate;
import org.noear.weed.cache.ICacheServiceEx;
import org.noear.weed.ext.Act1;
import org.noear.weed.utils.StringUtils;

public class Command {
    public String tag;
    public int isLog;
    public String key;
    public String text;
    public List<Variate> paramS;
    public DbContext context;
    public ICacheServiceEx cache;
    public DbTran tran;
    public long timestart = 0L;
    public long timestop = 0L;
    private Map<String, Object> _paramMap;
    public Act1<Command> onExecuteAft = null;

    public Command(DbContext context, DbTran tran) {
        this.context = context;
        this.context.lastCommand = this;
        this.tran = tran;
        if (tran == null) {
            this.tran = DbTranUtil.current();
        }
    }

    public Map<String, Object> paramMap() {
        if (this._paramMap == null) {
            this._paramMap = new LinkedHashMap<String, Object>();
            int idx = 0;
            for (Variate v : this.paramS) {
                if (StringUtils.isEmpty(v._name)) {
                    this._paramMap.put("v" + idx, v.getValue());
                } else {
                    this._paramMap.put("v" + idx + "-" + v._name, v.getValue());
                }
                ++idx;
            }
        }
        return this._paramMap;
    }

    @Deprecated
    public String text2() {
        return this.toSqlString();
    }

    public String toSqlString() {
        StringBuilder sb = new StringBuilder();
        String[] ss = this.text.split("\\?");
        int len = ss.length;
        for (int i = 0; i < len; ++i) {
            sb.append(ss[i]);
            if (i >= len - 1) continue;
            Variate val = this.paramS.get(i);
            if (val.isNull()) {
                sb.append("NULL");
                continue;
            }
            if (val.getValue() instanceof String) {
                sb.append("'").append(val.getString()).append("'");
                continue;
            }
            if (val.getValue() instanceof Boolean) {
                sb.append(val.getBoolean());
                continue;
            }
            if (val.getValue() instanceof Date) {
                sb.append("'").append(val.getDate()).append("'");
                continue;
            }
            sb.append(val.getValue());
        }
        return sb.toString();
    }

    public long timespan() {
        return this.timestop - this.timestart;
    }

    public String fullText() {
        if (this.context.codeHint() == null) {
            return this.context.dbDialect().preReview(this.text);
        }
        return this.context.codeHint() + this.context.dbDialect().preReview(this.text);
    }
}

