/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.noear.weed.BaseEntityWrap;
import org.noear.weed.BaseMapper;
import org.noear.weed.DataItem;
import org.noear.weed.DbContext;
import org.noear.weed.DbTableQuery;
import org.noear.weed.MapperWhereQ;
import org.noear.weed.ext.Act1;
import org.noear.weed.utils.RunUtils;

public class BaseMapperWrap<T>
implements BaseMapper<T> {
    private DbContext _db;
    private BaseEntityWrap _table;
    private Class<?> _entityType;

    protected Class<?> entityType() {
        return this._entityType;
    }

    public BaseMapperWrap(DbContext db, Class<?> entityType) {
        this._db = db;
        this._entityType = entityType;
        this._table = BaseEntityWrap.get(this);
    }

    public BaseMapperWrap(DbContext db, BaseMapper<T> baseMapper) {
        this._db = db;
        this._table = BaseEntityWrap.get(baseMapper);
    }

    private DbContext db() {
        return this._db;
    }

    private String tableName() {
        return this._table.tableName;
    }

    private String pk() {
        return this._table.pkName;
    }

    private Class<?> entityClz() {
        return this._table.entityClz;
    }

    @Override
    public Long insert(T entity, boolean excludeNull) {
        DataItem data = new DataItem();
        if (excludeNull) {
            data.setEntityIf(entity, (k, v) -> v != null);
        } else {
            data.setEntity(entity);
        }
        return RunUtils.call(() -> this.getQr().insert(data));
    }

    @Override
    public void insertList(List<T> list) {
        ArrayList<DataItem> list2 = new ArrayList<DataItem>();
        for (T d : list) {
            list2.add(new DataItem().setEntity(d));
        }
        RunUtils.call(() -> this.getQr().insertList(list2));
    }

    @Override
    public Integer deleteById(Object id) {
        return RunUtils.call(() -> ((DbTableQuery)this.getQr().whereEq(this.pk(), id)).delete());
    }

    @Override
    public Integer deleteByIds(Iterable<Object> idList) {
        return RunUtils.call(() -> ((DbTableQuery)this.getQr().whereIn(this.pk(), idList)).delete());
    }

    @Override
    public Integer deleteByMap(Map<String, Object> columnMap) {
        return RunUtils.call(() -> ((DbTableQuery)this.getQr().whereMap(columnMap)).delete());
    }

    @Override
    public Integer delete(Act1<MapperWhereQ> c) {
        return RunUtils.call(() -> this.getQr(c).delete());
    }

    @Override
    public Integer updateById(T entity, boolean excludeNull) {
        DataItem data = new DataItem();
        if (excludeNull) {
            data.setEntityIf(entity, (k, v) -> v != null);
        } else {
            data.setEntity(entity);
        }
        Object id = data.get(this.pk());
        return RunUtils.call(() -> ((DbTableQuery)this.getQr().whereEq(this.pk(), id)).update(data));
    }

    @Override
    public Integer update(T entity, boolean excludeNull, Act1<MapperWhereQ> c) {
        DataItem data = new DataItem();
        if (excludeNull) {
            data.setEntityIf(entity, (k, v) -> v != null);
        } else {
            data.setEntity(entity);
        }
        return RunUtils.call(() -> this.getQr(c).update());
    }

    @Override
    public Long upsert(T entity, boolean excludeNull) {
        DataItem data = new DataItem();
        if (excludeNull) {
            data.setEntityIf(entity, (k, v) -> v != null);
        } else {
            data.setEntity(entity);
        }
        Object id = data.get(this.pk());
        if (id == null) {
            return RunUtils.call(() -> this.getQr().insert(data));
        }
        return RunUtils.call(() -> this.getQr().upsert(data, this.pk()));
    }

    @Override
    public Long upsertBy(T entity, boolean excludeNull, String conditionFields) {
        DataItem data = new DataItem();
        if (excludeNull) {
            data.setEntityIf(entity, (k, v) -> v != null);
        } else {
            data.setEntity(entity);
        }
        return RunUtils.call(() -> this.getQr().upsert(data, conditionFields));
    }

    @Override
    public boolean existsById(Object id) {
        return RunUtils.call(() -> ((DbTableQuery)this.getQr().whereEq(this.pk(), id)).exists());
    }

    @Override
    public boolean exists(Act1<MapperWhereQ> c) {
        return RunUtils.call(() -> this.getQr(c).exists());
    }

    @Override
    public T selectById(Object id) {
        Class<?> clz = this.entityClz();
        return (T)RunUtils.call(() -> ((DbTableQuery)((DbTableQuery)this.getQr().whereEq(this.pk(), id)).limit(1)).select("*").getItem(clz));
    }

    @Override
    public List<T> selectByIds(Iterable<Object> idList) {
        Class<?> clz = this.entityClz();
        return RunUtils.call(() -> ((DbTableQuery)this.getQr().whereIn(this.pk(), idList)).select("*").getList(clz));
    }

    @Override
    public List<T> selectByMap(Map<String, Object> columnMap) {
        Class<?> clz = this.entityClz();
        return RunUtils.call(() -> ((DbTableQuery)this.getQr().whereMap(columnMap)).select("*").getList(clz));
    }

    @Override
    public T selectItem(T entity) {
        Class<?> clz = this.entityClz();
        return (T)RunUtils.call(() -> ((DbTableQuery)((DbTableQuery)this.getQr().whereEntity(entity)).limit(1)).select("*").getItem(clz));
    }

    @Override
    public T selectItem(Act1<MapperWhereQ> c) {
        Class<?> clz = this.entityClz();
        return (T)RunUtils.call(() -> this.getQr(c).select("*").getItem(clz));
    }

    @Override
    public Object selectValue(String column, Act1<MapperWhereQ> c) {
        return RunUtils.call(() -> this.getQr(c).select(column).getValue());
    }

    @Override
    public Map<String, Object> selectMap(Act1<MapperWhereQ> c) {
        return RunUtils.call(() -> this.getQr(c).select("*").getMap());
    }

    @Override
    public Long selectCount(Act1<MapperWhereQ> c) {
        return RunUtils.call(() -> this.getQr(c).count());
    }

    @Override
    public List<T> selectList(Act1<MapperWhereQ> c) {
        Class<?> clz = this.entityClz();
        return RunUtils.call(() -> this.getQr(c).select("*").getList(clz));
    }

    @Override
    public List<Map<String, Object>> selectMapList(Act1<MapperWhereQ> c) {
        return RunUtils.call(() -> this.getQr(c).select("*").getMapList());
    }

    @Override
    public List<Object> selectArray(String column, Act1<MapperWhereQ> c) {
        return RunUtils.call(() -> this.getQr(c).select(column).getArray(column));
    }

    @Override
    public List<T> selectPage(int start, int size, Act1<MapperWhereQ> c) {
        Class<?> clz = this.entityClz();
        return RunUtils.call(() -> ((DbTableQuery)this.getQr(c).limit(start, size)).select("*").getList(clz));
    }

    @Override
    public List<Map<String, Object>> selectMapPage(int start, int size, Act1<MapperWhereQ> c) {
        return RunUtils.call(() -> ((DbTableQuery)this.getQr(c).limit(start, size)).select("*").getMapList());
    }

    @Override
    public List<T> selectTop(int size, Act1<MapperWhereQ> c) {
        Class<?> clz = this.entityClz();
        return RunUtils.call(() -> ((DbTableQuery)this.getQr(c).top(size)).select("*").getList(clz));
    }

    @Override
    public List<Map<String, Object>> selectMapTop(int size, Act1<MapperWhereQ> c) {
        return RunUtils.call(() -> ((DbTableQuery)this.getQr(c).top(size)).select("*").getMapList());
    }

    private DbTableQuery getQr() {
        return this.db().table(this.tableName());
    }

    private DbTableQuery getQr(Act1<MapperWhereQ> c) {
        DbTableQuery qr = this.db().table(this.tableName());
        if (c != null) {
            c.run(new MapperWhereQ(qr));
        }
        return qr;
    }
}

