/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class IgnoreCaseMap<V>
implements Map<String, V>,
Serializable,
Cloneable {
    private final LinkedHashMap<String, V> _m;
    private final HashMap<String, String> _k;
    private final Locale locale;

    public IgnoreCaseMap() {
        this(16, null);
    }

    public IgnoreCaseMap(int initialCapacity) {
        this(initialCapacity, null);
    }

    public IgnoreCaseMap(int initialCapacity, Locale locale) {
        this._m = new LinkedHashMap<String, V>(initialCapacity){

            @Override
            public boolean containsKey(Object key) {
                return IgnoreCaseMap.this.containsKey(key);
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, V> eldest) {
                boolean doRemove = IgnoreCaseMap.this.removeEldestEntry(eldest);
                if (doRemove) {
                    IgnoreCaseMap.this._k.remove(IgnoreCaseMap.this.convertKey(eldest.getKey()));
                }
                return doRemove;
            }
        };
        this._k = new HashMap(initialCapacity);
        this.locale = locale != null ? locale : Locale.getDefault();
    }

    private IgnoreCaseMap(IgnoreCaseMap<V> other) {
        this._m = (LinkedHashMap)other._m.clone();
        this._k = (HashMap)other._k.clone();
        this.locale = other.locale;
    }

    @Override
    public int size() {
        return this._m.size();
    }

    @Override
    public boolean isEmpty() {
        return this._m.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String && this._k.containsKey(this.convertKey((String)key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this._m.containsValue(value);
    }

    @Override
    public V get(Object key) {
        String key2;
        if (key instanceof String && (key2 = this._k.get(this.convertKey((String)key))) != null) {
            return this._m.get(key2);
        }
        return null;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        String key2;
        if (key instanceof String && (key2 = this._k.get(this.convertKey((String)key))) != null) {
            return this._m.getOrDefault(key2, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public V put(String key, V value) {
        String oldKey = this._k.put(this.convertKey(key), key);
        if (oldKey != null && !oldKey.equals(key)) {
            this._m.remove(oldKey);
        }
        return this._m.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map) {
        if (map.isEmpty()) {
            return;
        }
        map.forEach(this::put);
    }

    @Override
    public V remove(Object key) {
        String key2;
        if (key instanceof String && (key2 = this._k.remove(this.convertKey((String)key))) != null) {
            return this._m.remove(key2);
        }
        return null;
    }

    @Override
    public void clear() {
        this._k.clear();
        this._m.clear();
    }

    @Override
    public Set<String> keySet() {
        return this._m.keySet();
    }

    @Override
    public Collection<V> values() {
        return this._m.values();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this._m.entrySet();
    }

    public IgnoreCaseMap<V> clone() {
        return new IgnoreCaseMap<V>(this);
    }

    @Override
    public boolean equals(Object obj) {
        return this._m.equals(obj);
    }

    @Override
    public int hashCode() {
        return this._m.hashCode();
    }

    public String toString() {
        return this._m.toString();
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected String convertKey(String key) {
        return key.toLowerCase(this.getLocale());
    }

    protected boolean removeEldestEntry(Map.Entry<String, V> eldest) {
        return false;
    }
}

