/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.socketd;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.noear.solon.Solon;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.message.Listener;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.socketd.RequestManager;
import org.noear.solon.socketd.SocketContextHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterListener
implements Listener {
    static final Logger log = LoggerFactory.getLogger(RouterListener.class);

    public void onOpen(Session session) {
        RunUtil.parallel(() -> this.onOpen0(session));
    }

    private void onOpen0(Session session) {
        try {
            Listener sl = this.get(session);
            if (sl != null) {
                sl.onOpen(session);
            } else {
                if (!Solon.app().enableWebSocketMvc() && session.method() == MethodType.WEBSOCKET && session.listener() == null) {
                    session.close();
                    return;
                }
                if (!Solon.app().enableSocketMvc() && session.method() == MethodType.SOCKET && session.listener() == null) {
                    session.close();
                    return;
                }
            }
        }
        catch (Throwable e) {
            EventBus.publishTry((Object)e);
        }
    }

    public void onMessage(Session session, Message message) throws IOException {
        if (message == null) {
            return;
        }
        RunUtil.parallel(() -> this.onMessage0(session, message));
    }

    private void onMessage0(Session session, Message message) {
        block7: {
            try {
                CompletableFuture<Message> request;
                log.trace("Listener proxy receive: {}", (Object)message);
                Listener sl = this.get(session);
                if (sl != null) {
                    sl.onMessage(session, message);
                }
                if (session.listener() != null) {
                    session.listener().onMessage(session, message);
                }
                if (message.flag() == 11) {
                    return;
                }
                if (message.flag() == 13 && (request = RequestManager.get(message.key())) != null) {
                    RequestManager.remove(message.key());
                    request.complete(message);
                    return;
                }
                if (!message.getHandled()) {
                    SocketContextHandler.instance.handle(session, message);
                }
            }
            catch (Throwable e) {
                if (this.onError0(session, e)) break block7;
                EventBus.publishTry((Object)e);
            }
        }
    }

    public void onClose(Session session) {
        RunUtil.parallel(() -> this.onClose0(session));
    }

    private void onClose0(Session session) {
        try {
            Listener sl = this.get(session);
            if (sl != null) {
                sl.onClose(session);
            }
            if (session.listener() != null) {
                session.listener().onClose(session);
            }
        }
        catch (Throwable e) {
            EventBus.publishTry((Object)e);
        }
    }

    public void onError(Session session, Throwable error) {
        RunUtil.parallel(() -> this.onError0(session, error));
    }

    private boolean onError0(Session session, Throwable error) {
        try {
            boolean handled = false;
            Listener sl = this.get(session);
            if (sl != null) {
                handled = true;
                sl.onError(session, error);
            }
            if (session.listener() != null) {
                handled = true;
                session.listener().onError(session, error);
            }
            return handled;
        }
        catch (Throwable e) {
            EventBus.publishTry((Object)e);
            return true;
        }
    }

    private Listener get(Session s) {
        return Solon.app().router().matchOne(s);
    }
}

