/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.channel.socketd;

import java.util.Map;
import java.util.function.Supplier;
import org.noear.nami.Channel;
import org.noear.nami.ChannelBase;
import org.noear.nami.Context;
import org.noear.nami.Encoder;
import org.noear.nami.NamiManager;
import org.noear.nami.Result;
import org.noear.solon.Utils;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.socketd.annotation.Handshake;
import org.noear.solon.socketd.util.HeaderUtil;

public class SocketChannel
extends ChannelBase
implements Channel {
    public Supplier<Session> sessions;

    public SocketChannel(Supplier<Session> sessions) {
        this.sessions = sessions;
    }

    public Result call(Context ctx) throws Throwable {
        Message res;
        Encoder encoder;
        Handshake h;
        this.pretreatment(ctx);
        if (ctx.config.getDecoder() == null) {
            throw new IllegalArgumentException("There is no suitable decoder");
        }
        ctx.config.getDecoder().pretreatment(ctx);
        Message message = null;
        String message_key = Message.guid();
        int flag = 10;
        if (ctx.method != null && (h = ctx.method.getAnnotation(Handshake.class)) != null) {
            flag = 12;
            if (Utils.isNotEmpty((String)h.handshakeHeader())) {
                Map<String, String> headerMap = HeaderUtil.decodeHeaderMap(h.handshakeHeader());
                ctx.headers.putAll(headerMap);
            }
        }
        if ((encoder = ctx.config.getEncoder()) == null) {
            encoder = NamiManager.getEncoder((String)"application/json");
        }
        if (encoder == null) {
            throw new IllegalArgumentException("There is no suitable encoder");
        }
        ctx.headers.put("Content-Type", encoder.enctype());
        byte[] bytes = encoder.encode(ctx.body);
        message = new Message(flag, message_key, ctx.url, HeaderUtil.encodeHeaderMap(ctx.headers), bytes);
        Session session = this.sessions.get();
        if (ctx.config.getHeartbeat() > 0) {
            session.sendHeartbeatAuto(ctx.config.getHeartbeat());
        }
        if ((res = session.sendAndResponse(message, ctx.config.getTimeout())) == null) {
            return null;
        }
        Result result = new Result(200, res.body());
        if (Utils.isNotEmpty((String)res.header())) {
            Map<String, String> map = HeaderUtil.decodeHeaderMap(res.header());
            map.forEach((k, v) -> result.headerAdd(k, v));
        }
        return result;
    }
}

