/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.sessionstate.local;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class ScheduledStore {
    private int _defaultSeconds;
    private Map<String, Entity> _data = new ConcurrentHashMap<String, Entity>();
    private static ScheduledExecutorService _exec = Executors.newSingleThreadScheduledExecutor();

    public ScheduledStore(int seconds) {
        this._defaultSeconds = seconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String block, String key, Object obj) {
        String string = block.intern();
        synchronized (string) {
            Entity ent = this._data.get(block);
            if (ent == null) {
                ent = new Entity();
                this._data.put(block, ent);
            } else {
                ent.futureDel();
            }
            ent.map.put(key, obj);
            ent.future = _exec.schedule(() -> this._data.remove(block), (long)this._defaultSeconds, TimeUnit.SECONDS);
        }
    }

    public void delay(String block) {
        Entity ent = this._data.get(block);
        if (ent != null) {
            ent.futureDel();
            ent.future = _exec.schedule(() -> this._data.remove(block), (long)this._defaultSeconds, TimeUnit.SECONDS);
        }
    }

    public Object get(String block, String key) {
        Entity ent = this._data.get(block);
        if (ent != null) {
            return ent.map.get(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String block) {
        String string = block.intern();
        synchronized (string) {
            Entity ent = this._data.get(block);
            if (ent != null) {
                ent.futureDel();
                this._data.remove(block);
            }
        }
    }

    public void clear() {
        for (Entity ent : this._data.values()) {
            ent.futureDel();
        }
        this._data.clear();
    }

    private static class Entity {
        public Map<String, Object> map = new ConcurrentHashMap<String, Object>();
        public Future future;

        private Entity() {
        }

        protected void futureDel() {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
        }
    }
}

