/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.sessionstate.local;

import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.SessionStateDefault;
import org.noear.solon.extend.sessionstate.local.ScheduledStore;
import org.noear.solon.extend.sessionstate.local.XServerProp;

public class LocalSessionState
extends SessionStateDefault {
    private static int _expiry = 7200;
    private static String _domain = null;
    private static ScheduledStore _store;
    private Context ctx;

    protected LocalSessionState(Context ctx) {
        this.ctx = ctx;
    }

    public String cookieGet(String key) {
        return this.ctx.cookie(key);
    }

    public void cookieSet(String key, String val) {
        if (XServerProp.session_state_domain_auto && _domain != null && this.ctx.uri().getHost().indexOf(_domain) < 0) {
            this.ctx.cookieSet(key, val, null, _expiry);
            return;
        }
        this.ctx.cookieSet(key, val, _domain, _expiry);
    }

    public String sessionId() {
        String _sessionId = (String)this.ctx.attr("sessionId", null);
        if (_sessionId == null) {
            _sessionId = this.sessionId_get();
            this.ctx.attrSet("sessionId", (Object)_sessionId);
        }
        return _sessionId;
    }

    private String sessionId_get() {
        String skey = this.cookieGet("SOLONID");
        String smd5 = this.cookieGet(LocalSessionState.SESSIONID_MD5());
        if (!Utils.isEmpty((String)skey) && !Utils.isEmpty((String)smd5) && Utils.md5((String)(skey + "&L8e!@T0")).equals(smd5)) {
            return skey;
        }
        skey = Utils.guid();
        this.cookieSet("SOLONID", skey);
        this.cookieSet(LocalSessionState.SESSIONID_MD5(), Utils.md5((String)(skey + "&L8e!@T0")));
        return skey;
    }

    public Object sessionGet(String key) {
        return _store.get(this.sessionId(), key);
    }

    public void sessionSet(String key, Object val) {
        _store.put(this.sessionId(), key, val);
    }

    public void sessionClear() {
        _store.remove(this.sessionId());
    }

    public void sessionRefresh() {
        String skey = this.cookieGet("SOLONID");
        if (!Utils.isEmpty((String)skey)) {
            this.cookieSet("SOLONID", skey);
            this.cookieSet(LocalSessionState.SESSIONID_MD5(), Utils.md5((String)(skey + "&L8e!@T0")));
            _store.delay(this.sessionId());
        }
    }

    public boolean replaceable() {
        return false;
    }

    static {
        if (XServerProp.session_timeout > 0) {
            _expiry = XServerProp.session_timeout;
        }
        if (XServerProp.session_state_domain != null) {
            _domain = XServerProp.session_state_domain;
        }
        _store = new ScheduledStore(_expiry);
    }
}

