/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.noear.eggg.ClassEggg;
import org.noear.eggg.MethodEggg;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Addition;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.FactoryManager;
import org.noear.solon.core.handle.ActionDefault;
import org.noear.solon.core.handle.ActionLoader;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerAide;
import org.noear.solon.core.handle.HandlerSlots;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.MethodTypeUtil;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.util.Assert;
import org.noear.solon.core.util.PathUtil;
import org.noear.solon.core.util.ProxyBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionLoaderDefault
extends HandlerAide
implements ActionLoader {
    static final Logger log = LoggerFactory.getLogger(ActionLoaderDefault.class);
    protected final BeanWrap bw;
    protected final boolean bRemoting;
    protected Mapping bMapping;
    protected String bPath;
    protected String bVersion;
    protected String pathPrefix;
    protected Render render;
    protected boolean allowClassMapping = true;
    protected boolean allowMethodMapping = true;

    public ActionLoader withPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
        return this;
    }

    public ActionLoader withAllowClassMapping(boolean allow) {
        this.allowClassMapping = allow;
        return this;
    }

    public ActionLoader withAllowMethodMapping(boolean allow) {
        this.allowMethodMapping = allow;
        return this;
    }

    public ActionLoader withRender(Render render) {
        this.render = render;
        return this;
    }

    public ActionLoaderDefault(BeanWrap wrap, boolean remoting) {
        this.bw = wrap;
        this.bRemoting = remoting;
        if (wrap.raw() instanceof Render) {
            this.render = (Render)wrap.raw();
        }
    }

    public void load(HandlerSlots slots) {
        if (this.allowClassMapping) {
            this.bMapping = this.bw.clz().getAnnotation(Mapping.class);
        }
        if (this.bMapping == null) {
            this.bPath = "";
            this.bVersion = null;
        } else {
            this.bPath = Utils.annoAlias((String)this.bMapping.value(), (String)this.bMapping.path());
            this.bVersion = Utils.isNotEmpty((String)this.bMapping.version()) ? this.bMapping.version() : null;
        }
        if (Assert.isNotEmpty((String)this.pathPrefix)) {
            this.bPath = PathUtil.mergePath((String)this.pathPrefix, (String)this.bPath);
        }
        this.load(this.bRemoting, slots);
    }

    protected void load(boolean all, HandlerSlots slots) {
        if (Handler.class.isAssignableFrom(this.bw.clz())) {
            this.loadHandlerDo(slots);
        } else {
            this.loadActions(slots, all || this.bRemoting);
        }
    }

    protected void loadHandlerDo(HandlerSlots slots) {
        if (this.bMapping == null) {
            throw new IllegalStateException(this.bw.clz().getName() + " No @Mapping!");
        }
        Handler handler = (Handler)this.bw.raw();
        HashSet<MethodType> mtSet = FactoryManager.getGlobal().actionLoaderFactory().findMethodTypes(new HashSet(), t -> this.bw.annotationGet(t) != null);
        if (mtSet.size() == 0) {
            mtSet = new HashSet<MethodType>(Arrays.asList(this.bMapping.method()));
        }
        slots.add(this.bMapping, mtSet, this.bw.index(), handler);
    }

    protected void loadActions(HandlerSlots slots, boolean all) {
        HashSet<MethodType> b_limitMethodSet = new HashSet<MethodType>();
        HashSet<MethodType> b_addinMethodSet = new HashSet<MethodType>();
        FactoryManager.getGlobal().actionLoaderFactory().findMethodTypes(b_limitMethodSet, t -> this.bw.clz().getAnnotation(t) != null);
        this.loadControllerAide(b_addinMethodSet);
        if (b_limitMethodSet.size() == 0 && this.bMapping != null) {
            for (MethodType b_mt : this.bMapping.method()) {
                if (b_mt == MethodType.ALL) continue;
                b_limitMethodSet.add(b_mt);
            }
        }
        boolean enableProxy = false;
        ClassEggg classEggg = this.bw.rawEggg();
        for (MethodEggg m1 : classEggg.getOwnMethodEgggs()) {
            this.loadActionItem(slots, all, m1, b_limitMethodSet, b_addinMethodSet);
            if (!m1.isPublic()) continue;
            enableProxy = enableProxy || this.bw.context().beanInterceptorHas((AnnotatedElement)m1.getMethod());
        }
        boolean bl = enableProxy = enableProxy || this.bw.context().beanInterceptorHas((AnnotatedElement)this.bw.rawClz());
        if (enableProxy) {
            ProxyBinder.global().binding(this.bw);
        }
    }

    protected void loadActionItem(HandlerSlots slots, boolean all, MethodEggg mE, Set<MethodType> b_limitMethodSet, Set<MethodType> b_addinMethodSet) {
        String m_path;
        Mapping m_map = mE.getMethod().getAnnotation(Mapping.class);
        if (m_map == null) {
            if (!mE.isPublic()) {
                return;
            }
        } else if (!mE.isPublic()) {
            log.warn("This @Mapping method is not public: " + mE.getMethod().getDeclaringClass().getName() + ":" + mE.getName());
        }
        HashSet<MethodType> m_limitMethodSet = new HashSet<MethodType>(b_limitMethodSet);
        HashSet<MethodType> m_addinMethodSet = new HashSet<MethodType>(b_addinMethodSet);
        FactoryManager.getGlobal().actionLoaderFactory().findMethodTypes(m_limitMethodSet, t -> mE.getMethod().getAnnotation(t) != null);
        if (m_map != null) {
            m_path = Utils.annoAlias((String)m_map.value(), (String)m_map.path());
            if (m_limitMethodSet.size() == 0) {
                m_limitMethodSet.addAll(Arrays.asList(m_map.method()));
            }
        } else {
            m_path = mE.getName();
            if (m_limitMethodSet.size() == 0) {
                if (this.bMapping == null) {
                    m_limitMethodSet.add(MethodType.HTTP);
                } else {
                    m_limitMethodSet.addAll(Arrays.asList(this.bMapping.method()));
                }
            }
        }
        if (m_map != null || all) {
            String newPath = this.postActionPath(this.bw, this.bPath, mE, m_path);
            ActionDefault action = this.createAction(this.bw, mE, m_map, newPath, this.bRemoting);
            this.loadActionAide(mE, action, m_addinMethodSet);
            if (m_limitMethodSet.size() > 0 && !m_limitMethodSet.contains(MethodType.HTTP) && !m_limitMethodSet.contains(MethodType.ALL)) {
                m_limitMethodSet.addAll(m_addinMethodSet);
            }
            for (MethodType m1 : m_limitMethodSet) {
                slots.add(newPath, m1, (Handler)action);
            }
        }
    }

    protected void loadControllerAide(Set<MethodType> addinMethodSet) {
        for (Annotation anno : this.bw.clz().getAnnotations()) {
            if (this.loadControllerAideAdd(anno, addinMethodSet)) continue;
            for (Annotation anno2 : anno.annotationType().getAnnotations()) {
                this.loadControllerAideAdd(anno2, addinMethodSet);
            }
        }
    }

    protected boolean loadControllerAideAdd(Annotation anno, Set<MethodType> addinMethodSet) {
        if (anno instanceof Addition) {
            Addition additionAnno = (Addition)anno;
            for (Class clz : additionAnno.value()) {
                MethodType methodType;
                if (Filter.class.isAssignableFrom(clz)) {
                    this.filter(additionAnno.index(), (Filter)this.bw.context().getBeanOrNew(clz));
                    continue;
                }
                if (!Annotation.class.isAssignableFrom(clz) || (methodType = MethodTypeUtil.valueOf((String)clz.getSimpleName().toUpperCase())) == MethodType.UNKNOWN) continue;
                addinMethodSet.add(methodType);
            }
            return true;
        }
        return false;
    }

    protected void loadActionAide(MethodEggg mE, ActionDefault action, Set<MethodType> addinMethodSet) {
        for (Annotation anno : mE.getAnnotations()) {
            if (this.loadActionAideAdd(anno, action, addinMethodSet)) continue;
            for (Annotation anno2 : anno.annotationType().getAnnotations()) {
                this.loadActionAideAdd(anno2, action, addinMethodSet);
            }
        }
    }

    protected boolean loadActionAideAdd(Annotation anno, ActionDefault action, Set<MethodType> addinMethodSet) {
        if (anno instanceof Addition) {
            Addition additionAnno = (Addition)anno;
            for (Class clz : additionAnno.value()) {
                MethodType methodType;
                if (Filter.class.isAssignableFrom(clz)) {
                    action.filter(additionAnno.index(), (Filter)this.bw.context().getBeanOrNew(clz));
                    continue;
                }
                if (!Annotation.class.isAssignableFrom(clz) || (methodType = MethodTypeUtil.valueOf((String)clz.getSimpleName().toUpperCase())) == MethodType.UNKNOWN) continue;
                addinMethodSet.add(methodType);
            }
            return true;
        }
        return false;
    }

    protected String postActionPath(BeanWrap bw, String bPath, MethodEggg mE, String mPath) {
        return FactoryManager.getGlobal().actionLoaderFactory().postActionPath(bw, bPath, mE, mPath);
    }

    protected ActionDefault createAction(BeanWrap bw, MethodEggg mE, Mapping mp, String path, boolean remoting) {
        if (this.allowMethodMapping) {
            return new ActionDefault(bw, this, this.bVersion, mE, mp, path, remoting, this.render);
        }
        return new ActionDefault(bw, this, this.bVersion, mE, null, path, remoting, this.render);
    }
}

