/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.util.function.Function;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.snel.LogicalOp;

public class LogicalNode
implements Expression<Boolean> {
    private LogicalOp operator;
    private Expression left;
    private Expression right;

    public LogicalOp getOperator() {
        return this.operator;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public LogicalNode(LogicalOp operator, Expression left, Expression right) {
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    @Override
    public Boolean eval(Function context) {
        boolean leftValue = this.getOptimizeValue(this.left, context);
        boolean rightValue = this.getOptimizeValue(this.right, context);
        if (this.operator == LogicalOp.AND) {
            return leftValue && rightValue;
        }
        if (this.operator == LogicalOp.OR) {
            return leftValue || rightValue;
        }
        return !leftValue;
    }

    protected boolean getOptimizeValue(Expression expression, Function context) {
        if (expression == null) {
            return false;
        }
        Object value = expression.eval(context);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return ((String)value).length() > 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() > 0;
        }
        return value != null;
    }

    public String toString() {
        return "(" + this.left + " " + this.operator.getCode() + " " + this.right + ")";
    }
}

