/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.server.prompt;

import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.eggg.MethodEggg;
import org.noear.eggg.ParamEggg;
import org.noear.eggg.TypeEggg;
import org.noear.solon.Utils;
import org.noear.solon.ai.annotation.PromptMapping;
import org.noear.solon.ai.chat.message.ChatMessage;
import org.noear.solon.ai.chat.tool.MethodExecuteHandler;
import org.noear.solon.ai.chat.tool.ToolSchemaUtil;
import org.noear.solon.ai.mcp.server.prompt.FunctionPrompt;
import org.noear.solon.ai.util.ParamDesc;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextEmpty;
import org.noear.solon.core.util.Assert;
import org.noear.solon.core.wrap.MethodWrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodFunctionPrompt
implements FunctionPrompt {
    static final Logger log = LoggerFactory.getLogger(MethodFunctionPrompt.class);
    private final BeanWrap beanWrap;
    private final MethodWrap methodWrap;
    private final String name;
    private final PromptMapping mapping;
    private final Map<String, ParamDesc> params;

    public MethodFunctionPrompt(BeanWrap beanWrap, MethodEggg methodEggg) {
        this.beanWrap = beanWrap;
        this.methodWrap = new MethodWrap(beanWrap.context(), beanWrap.clz(), methodEggg);
        this.mapping = methodEggg.getMethod().getAnnotation(PromptMapping.class);
        this.name = Utils.annoAlias((String)this.mapping.name(), (String)methodEggg.getName());
        Assert.notNull((Object)this.mapping, (String)"@PromptMapping annotation is missing");
        Assert.notEmpty((String)this.mapping.description(), (String)"PromptMapping description cannot be empty");
        if (!Collection.class.isAssignableFrom(methodEggg.getReturnTypeEggg().getType())) {
            throw new IllegalArgumentException("@PromptMapping return type is not Collection");
        }
        this.params = new LinkedHashMap<String, ParamDesc>();
        for (ParamEggg p1 : methodEggg.getParamEgggAry()) {
            Map paramMap = ToolSchemaUtil.buildInputParams((AnnotatedElement)p1.getParam(), (TypeEggg)p1.getTypeEggg());
            if (!Utils.isNotEmpty((Map)paramMap)) continue;
            this.params.putAll(paramMap);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String title() {
        return this.mapping.title();
    }

    @Override
    public String description() {
        return this.mapping.description();
    }

    @Override
    public Collection<ParamDesc> params() {
        return this.params.values();
    }

    @Override
    public Collection<ChatMessage> handle(Map<String, Object> args) throws Throwable {
        try {
            return this.doHandle(args);
        }
        catch (Throwable ex) {
            if (log.isWarnEnabled()) {
                log.warn("Prompt handle error, name: '{}'", (Object)this.name, (Object)ex);
            }
            throw ex;
        }
    }

    private Collection<ChatMessage> doHandle(Map<String, Object> args) throws Throwable {
        Context ctx = Context.current();
        if (ctx == null) {
            ctx = new ContextEmpty();
        }
        ctx.attrSet("MCP_BODY", args);
        ctx.result = MethodExecuteHandler.getInstance().executeHandle(ctx, this.beanWrap.get(), this.methodWrap);
        return (Collection)ctx.result;
    }
}

