/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.llm.dialect.openai;

import java.util.List;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.snack4.codec.TypeRef;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.image.ImageConfig;
import org.noear.solon.ai.image.ImageException;
import org.noear.solon.ai.image.ImageResponse;
import org.noear.solon.ai.image.dialect.AbstractImageDialect;
import org.noear.solon.ai.media.Image;

public class OpenaiImageDialect
extends AbstractImageDialect {
    private static OpenaiImageDialect instance = new OpenaiImageDialect();

    public static OpenaiImageDialect getInstance() {
        return instance;
    }

    public boolean isDefault() {
        return true;
    }

    public boolean matched(ImageConfig config) {
        return false;
    }

    public ImageResponse parseResponseJson(ImageConfig config, String respJson) {
        ONode oResp = ONode.ofJson((String)respJson, (Feature[])new Feature[0]);
        String model = oResp.get("model").getString();
        if (oResp.hasKey("error")) {
            return new ImageResponse(model, new ImageException(oResp.get("error").getString()), null, null);
        }
        List data = (List)oResp.get("data").toBean((TypeRef)new TypeRef<List<Image>>(){});
        AiUsage usage = null;
        if (oResp.hasKey("usage")) {
            ONode oUsage = oResp.get("usage");
            long prompt_tokens = oUsage.get("prompt_tokens").getLong();
            long total_tokens = oUsage.get("total_tokens").getLong();
            usage = new AiUsage(prompt_tokens, 0L, total_tokens, oUsage);
        }
        return new ImageResponse(model, null, data, usage);
    }
}

