/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.llm.dialect.openai;

import java.util.Arrays;
import java.util.List;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.snack4.codec.TypeRef;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.generate.GenerateConfig;
import org.noear.solon.ai.generate.GenerateContent;
import org.noear.solon.ai.generate.GenerateException;
import org.noear.solon.ai.generate.GenerateResponse;
import org.noear.solon.ai.generate.dialect.AbstractGenerateDialect;

public class OpenaiGenerateDialect
extends AbstractGenerateDialect {
    private static OpenaiGenerateDialect instance = new OpenaiGenerateDialect();

    public static OpenaiGenerateDialect getInstance() {
        return instance;
    }

    public boolean isDefault() {
        return true;
    }

    public boolean matched(GenerateConfig config) {
        return false;
    }

    public GenerateResponse parseResponseJson(GenerateConfig config, String respJson) {
        ONode oResp = ONode.ofJson((String)respJson, (Feature[])new Feature[0]);
        String model = oResp.get("model").getString();
        if (oResp.hasKey("error")) {
            return new GenerateResponse(model, new GenerateException(oResp.get("error").getString()), null, null);
        }
        List<GenerateContent> data = null;
        if (oResp.hasKey("task_id")) {
            String url = config.getTaskUrlAndId(oResp.get("task_id").getString());
            data = Arrays.asList(GenerateContent.builder().url(url).build());
        } else if (oResp.hasKey("data")) {
            data = (List<GenerateContent>)oResp.get("data").toBean((TypeRef)new TypeRef<List<GenerateContent>>(){});
        }
        AiUsage usage = null;
        if (oResp.hasKey("usage")) {
            ONode oUsage = oResp.get("usage");
            long prompt_tokens = oUsage.get("prompt_tokens").getLong();
            long total_tokens = oUsage.get("total_tokens").getLong();
            usage = new AiUsage(prompt_tokens, 0L, total_tokens, oUsage);
        }
        return new GenerateResponse(model, null, (List)data, usage);
    }
}

