/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.llm.dialect.openai;

import java.util.List;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.snack4.codec.TypeRef;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.embedding.Embedding;
import org.noear.solon.ai.embedding.EmbeddingConfig;
import org.noear.solon.ai.embedding.EmbeddingException;
import org.noear.solon.ai.embedding.EmbeddingResponse;
import org.noear.solon.ai.embedding.dialect.AbstractEmbeddingDialect;

public class OpenaiEmbeddingDialect
extends AbstractEmbeddingDialect {
    private static OpenaiEmbeddingDialect instance = new OpenaiEmbeddingDialect();

    public static OpenaiEmbeddingDialect getInstance() {
        return instance;
    }

    public boolean isDefault() {
        return true;
    }

    public boolean matched(EmbeddingConfig config) {
        return false;
    }

    public EmbeddingResponse parseResponseJson(EmbeddingConfig config, String respJson) {
        ONode oResp = ONode.ofJson((String)respJson, (Feature[])new Feature[0]);
        String model = oResp.get("model").getString();
        if (oResp.hasKey("error")) {
            return new EmbeddingResponse(model, new EmbeddingException(oResp.get("error").getString()), null, null);
        }
        List data = (List)oResp.get("data").toBean((TypeRef)new TypeRef<List<Embedding>>(){});
        AiUsage usage = null;
        if (oResp.hasKey("usage")) {
            ONode oUsage = oResp.get("usage");
            long prompt_tokens = oUsage.get("prompt_tokens").getLong();
            long total_tokens = oUsage.get("total_tokens").getLong();
            usage = new AiUsage(prompt_tokens, 0L, total_tokens, oUsage);
        }
        return new EmbeddingResponse(model, null, data, usage);
    }
}

