/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.llm.dialect.ollama;

import java.util.List;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.snack4.codec.TypeRef;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.image.ImageConfig;
import org.noear.solon.ai.image.ImageException;
import org.noear.solon.ai.image.ImageResponse;
import org.noear.solon.ai.image.dialect.AbstractImageDialect;
import org.noear.solon.ai.media.Image;

public class OllamaImageDialect
extends AbstractImageDialect {
    private static OllamaImageDialect instance = new OllamaImageDialect();

    public static OllamaImageDialect getInstance() {
        return instance;
    }

    public boolean matched(ImageConfig config) {
        return "ollama".equals(config.getProvider());
    }

    public ImageResponse parseResponseJson(ImageConfig config, String respJson) {
        ONode oResp = ONode.ofJson((String)respJson, (Feature[])new Feature[0]);
        String model = oResp.get("model").getString();
        if (oResp.hasKey("error")) {
            return new ImageResponse(model, new ImageException(oResp.get("error").getString()), null, null);
        }
        List data = (List)oResp.get("data").toBean((TypeRef)new TypeRef<List<Image>>(){});
        AiUsage usage = null;
        if (oResp.hasKey("prompt_eval_count")) {
            long prompt_eval_count = oResp.get("prompt_eval_count").getLong();
            usage = new AiUsage(prompt_eval_count, 0L, prompt_eval_count, oResp);
        }
        return new ImageResponse(model, null, data, usage);
    }
}

