/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.llm.dialect.ollama;

import java.util.Arrays;
import java.util.List;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.snack4.codec.TypeRef;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.generate.GenerateConfig;
import org.noear.solon.ai.generate.GenerateContent;
import org.noear.solon.ai.generate.GenerateException;
import org.noear.solon.ai.generate.GenerateResponse;
import org.noear.solon.ai.generate.dialect.AbstractGenerateDialect;

public class OllamaGenerateDialect
extends AbstractGenerateDialect {
    private static OllamaGenerateDialect instance = new OllamaGenerateDialect();

    public static OllamaGenerateDialect getInstance() {
        return instance;
    }

    public boolean matched(GenerateConfig config) {
        return "ollama".equals(config.getProvider());
    }

    public GenerateResponse parseResponseJson(GenerateConfig config, String respJson) {
        ONode oResp = ONode.ofJson((String)respJson, (Feature[])new Feature[0]);
        String model = oResp.get("model").getString();
        if (oResp.hasKey("error")) {
            return new GenerateResponse(model, new GenerateException(oResp.get("error").getString()), null, null);
        }
        List<GenerateContent> data = null;
        if (oResp.hasKey("response")) {
            String text = oResp.get("response").getString();
            data = Arrays.asList(GenerateContent.builder().text(text).build());
        } else if (oResp.hasKey("data")) {
            data = (List<GenerateContent>)oResp.get("data").toBean((TypeRef)new TypeRef<List<GenerateContent>>(){});
        }
        AiUsage usage = null;
        if (oResp.hasKey("prompt_eval_count")) {
            long prompt_eval_count = oResp.get("prompt_eval_count").getLong();
            usage = new AiUsage(prompt_eval_count, 0L, prompt_eval_count, oResp);
        }
        return new GenerateResponse(model, null, data, usage);
    }
}

